package javax.microedition.lcdui;


public class Graphics
{
    public static final int SOLID = 0;
    public static final int DOTTED = 1;

    public static final int HCENTER = 1;
    public static final int VCENTER = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int TOP = 16;
    public static final int BOTTOM = 32;
    public static final int BASELINE = 64;
    
    private java.awt.Graphics m_g;
    private Font m_font;
    private int m_color = 0xff000000;
    private java.awt.Color m_color_o;
    
    private int[] m_poly_x = new int[3];
    private int[] m_poly_y = new int[3];
    
    public Graphics(java.awt.Graphics g)
    {
        m_g = g;
        m_font = Font.getFont(Font.FACE_SYSTEM, 0, Font.SIZE_MEDIUM);
        setColor( 0xff000000 );
    }
    
    public void setColor(int color)
    {
        m_color = color;
        m_color_o = new java.awt.Color( color, true );
    }
    
    public int getColor()
    {
        return m_color;
    }

    public void setFont(Font f)
    {
        m_font = f;
    }

    public Font getFont()
    {
        return m_font;
    }

    public void fillRect(int x, int y, int w, int h )
    {
        m_g.setColor( m_color_o );
        m_g.fillRect( x, y, w, h );
    }

    public void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3)
    {
        m_poly_x[0] = x1;
        m_poly_x[1] = x2;
        m_poly_x[2] = x3;
        m_poly_y[0] = y1;
        m_poly_y[1] = y2;
        m_poly_y[2] = y3;
        
        m_g.setColor( m_color_o );
        m_g.fillPolygon( m_poly_x, m_poly_y, 3 );
    }

    public void drawArc(int x, int y, int w, int h, int ang1, int ang2)
    {
        m_g.setColor( m_color_o );
        m_g.drawArc( x, y, w, h, ang1, ang2 );
    }

    public void fillArc(int x, int y, int w, int h, int ang1, int ang2)
    {
        m_g.setColor( m_color_o );
        m_g.fillArc( x, y, w, h, ang1, ang2 );
    }

    public void drawLine(int x1, int y1, int x2, int y2)
    {
        m_g.setColor( m_color_o );
        m_g.drawLine( x1, y1, x2, y2 );
    }

    public void drawImage(Image img, int x, int y, int handle)
    {
        if ((handle & HCENTER) != 0)
            x -= img.getWidth() / 2;
        if ((handle & RIGHT) != 0)
            x -= img.getWidth();

        if ((handle & VCENTER) != 0)
            y -= img.getHeight() / 2;
        if ((handle & BOTTOM) != 0)
            y -= img.getHeight();

        m_g.drawImage(img.m_bitmap, x, y, null);
    }

    public void drawString(String str, int x, int y, int handle)
    {
        m_g.setColor( m_color_o );
        m_g.setFont( m_font.font );
        m_g.drawString( str, x, y + m_font.getBaselinePosition() );
    }
}
