using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace StarifficEditor
{
    public partial class RunGameForm : Form
    {
        public int width;
        public int height;
        public bool run_exported_data;

        public RunGameForm()
        {
            InitializeComponent();

            comboBoxRunMode.SelectedIndex = 0;
            Validate();
        }

        private void textBoxScreenWidth_TextChanged(object sender, EventArgs e)
        {
            ValidateParams();
        }

        private void textBoxScreenHeight_TextChanged(object sender, EventArgs e)
        {
            ValidateParams();
        }

        private void ValidateParams()
        {
            buttonOk.Enabled = IsValid();
        }

        private bool IsValid()
        {
            try
            {
                width = int.Parse(textBoxScreenWidth.Text);
                height = int.Parse(textBoxScreenHeight.Text);
                if (width <= 0 || height <= 0)
                    return false;
            }
            catch (Exception)
            {
                return false;
            }
            return true;
        }

        private void buttonOk_Click(object sender, EventArgs e)
        {
            if (!IsValid())
                return;

            DialogResult = DialogResult.OK;
            Close();
        }

        private void buttonCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
        }

        private void comboBoxRunMode_SelectedIndexChanged(object sender, EventArgs e)
        {
            run_exported_data = (comboBoxRunMode.SelectedIndex == 1);
        }
    }
}