;******************************************************************************
; rod.asm
; 2006/11/05
; Martin Veilleux
;******************************************************************************
;==============================================================================
; INCLUDES
;==============================================================================
;==============================================================================
; DEFINITIONS
;==============================================================================
;==============================================================================
; MACROS
;==============================================================================
;==============================================================================
section .data
;==============================================================================
cylUVos: dd 0,0,4.0,2.0
cyl2UVos: dd 0,0,4.0,10.0
cylScale: dd 800.0,600.0,5000.0
cyl2Scale: dd 80.0,80.0,5000.0
cylMinRad: dd 1.0
cylPow: dd 1.0
cyl2Bias: dd 1.03
;rodCamAngSpeed: dd 30.0
;rodCamSpeed: dd 15.0
;rodRotSpeed: dd 36.0
rodCamAngSpeed: dd 12.0
rodCamSpeed: dd 3.0
rodRotSpeed: dd 12.0
rodCamRad: dd 200.0,150.0,200.0
rodStorm: dd 0,0,843765,0.2,2.0,0.1,_updateRodStrike, _renderRodStrike
maxBoltFreq: dd 2.0
minBoltFreq: dd 1.0
rodLUT:
dd PACKB2DW(0,240,192,192)
dd PACKB2DW(0,192,192,240)
dd PACKB2DW(0,240,192,128)
dd PACKB2DW(0,240,192,240)
dd PACKB2DW(0,192,240,192)
dd PACKB2DW(0,240,240,160)
dd PACKB2DW(0,210,128,240)
dd PACKB2DW(0,240,128,210)
rodLTNG: dd 20.0,2.1,1.9,0.5,0.457,1.0,1.0,1.0,2.0,2.0,4,4,LTNGF_P2P
;FOGmax: dd 4800.0
;FOGdist: dd 0.001

;==============================================================================
section .bss
;==============================================================================
cylUVptr: resd 1
ltngBolt: resb ltng_size

;==============================================================================
section .text
;==============================================================================
SDECL _updateBolt, 0
;==============================================================================
    MPUSH   ebp
    LCTX    ebp
    LARG    4, _pseed
    LENTER
    xor     eax,eax
    mov     dword[ltngBolt +ltng.tr +trail.flaretex],eax
    mov     dword[ltngBolt +ltng.tr +trail.tex],gtexFlare1d
    Memcpy  ltngBolt +ltng.diam , rodLTNG, ltng_size - trail_size
    RandF   [%$_pseed]
    fmul    dword[maxBoltFreq]
    fadd    dword[minBoltFreq]
    fmul    dword[RTM_time]
    fstp    dword[ltngBolt +ltng.freqY]
    RandF   [%$_pseed]
    fmul    dword[maxBoltFreq]
    fadd    dword[minBoltFreq]
    fmul    dword[RTM_time]
    fstp    dword[ltngBolt +ltng.freqZ]
    RandI   [%$_pseed]
    and     eax,0x7
    rgbaUnpack ltngBolt +ltng.tr +trail.c, [rodLUT +eax*4]
.exit:
    LEXIT
    MPOP    ebp
DECLEND
;==============================================================================
SDECL _updateRodStrike, 0
;==============================================================================
    MPUSH   esi,ebp
    LCTX    ebp
    LARG    4, _pstr, _doinit
    LVAR    4, seed
    LENTER
    
    mov     esi,dword[%$_pstr]
    xor     eax,eax
    or      eax,dword[%$_doinit]
    jnz     .init
    mov     eax,dword[esi +ltngstrike.seed]
    mov     dword[%$seed],eax
    lea     eax,[%$seed]
    RandF   eax
    fadd    dword[cylUVos +vec4.y]
    fld     st0
    frndint
    fsubp   st1
    fld1
    fsubrp  st1
    fmul    dword[cylScale +vec3.z]
    fst     dword[esi +ltngstrike.p1 +vec3.z]
    fstp    dword[esi +ltngstrike.p2 +vec3.z]
    jmp     .exit
.init:
    lea     eax,[esi +ltngstrike.seed]
    RandF   eax
    fldpi
    fadd    st0
    fmulp   st1
    fsincos
    fld     st0
    fmul    dword[cyl2Scale +vec3.x]
    fstp    dword[esi +ltngstrike.p1 +vec3.x]
    fmul    dword[cylScale +vec3.x]
    fstp    dword[esi +ltngstrike.p2 +vec3.x]
    fld     st0
    fmul    dword[cyl2Scale +vec3.y]
    fstp    dword[esi +ltngstrike.p1 +vec3.y]
    fmul    dword[cylScale +vec3.y]
    fstp    dword[esi +ltngstrike.p2 +vec3.y]
.exit:
    LEXIT
    MPOP    esi,ebp
DECLEND
;==============================================================================
SDECL _renderRodStrike, 0
;==============================================================================
    MPUSH   ebp
    LCTX    ebp
    LARG    4, _pstr, _seed
    LVAR    particle_size, mypt
    LENTER
    lea     eax,[%$_seed]
    CCALL   _updateBolt, eax
;render
	RasSetFpgm _FPGM_RGBxT0add_Z
	mov     edx,dword[%$_pstr]
    lea     eax,[edx +ltngstrike.p1]
    lea     edx,[edx +ltngstrike.p2]
    CCALL   _LTNG_renderP2P, ltngBolt, eax, edx
;render particle
    mov     eax,dword[elecGlowRadius]
    mov     dword[%$mypt +particle.rad],eax
	mov     edx,dword[%$_pstr]
	V3smul  %$mypt +particle.p, edx +ltngstrike.p1, cyl2Bias
;    V3eq    %$mypt +particle.p, edx +ltngstrike.p1
    RasSetSrcBlendImm 255,255,255,255
    RasSetTex 0, gtexRainbow
    lea     eax,[%$mypt]
    CCALL   _PT_renderFast, eax, 1
	mov     edx,dword[%$_pstr]
    V3eq    %$mypt +particle.p, edx +ltngstrike.p2
    lea     eax,[%$mypt]
    CCALL   _PT_renderFast, eax, 1
.exit:
    LEXIT
    MPOP    ebp
DECLEND
;==============================================================================
SDECL _initRod, 0
;==============================================================================
    CCALL   _LTNGSTORM_init, rodStorm, 16
    CCALL   _LTNG_init, ltngBolt, 64
DECLEND
;==============================================================================
SDECL _updateRod, 0
;==============================================================================
    CCALL   _LTNGSTORM_update, rodStorm, [RTM_dt]
.exit:
DECLEND
;==============================================================================
SDECL _updateRodCam, 0
;==============================================================================
;    fld     dword[beatTimer +timer.sec]
    fld     dword[RTM_time]
    fdiv    dword[rodCamSpeed]
    fld     st0
    frndint
    fsubp   st1
    fst     dword[cylUVos +vec4.y]
    fstp    dword[cyl2UVos +vec4.y]

;    fld     dword[beatTimer +timer.sec]
    fld     dword[RTM_time]
    fdiv    dword[rodRotSpeed]
    fld     st0
    frndint
    fsubp   st1
    fst     dword[cylUVos +vec4.x]
    fstp    dword[cyl2UVos +vec4.x]
;update camera position
    fldpi
    fadd    st0
    fdiv    dword[rodCamAngSpeed]
;    fmul    dword[beatTimer +timer.sec]
    fmul    dword[RTM_time]
    fsincos
    fmul    dword[rodCamRad +vec3.x]
    fstp    dword[RTmatrix +matrix.t +vec3.x]
    fmul    dword[rodCamRad +vec3.y]
    fstp    dword[RTmatrix +matrix.t +vec3.y]
    fld     dword[rodCamRad +vec3.z]
    fstp    dword[RTmatrix +matrix.t +vec3.z]
    CameraSetPos RAS_main +raster.cam, RTmatrix +matrix.t
    M33id   RTmatrix
    CameraSetRot RAS_main +raster.cam, RTmatrix
    CameraUpdate RAS_main +raster.cam
.exit:
DECLEND
;==============================================================================
SDECL _getFog
;==============================================================================
    LCTX    esp
    LARG    4, _pvec
    LVAR    16,dummy
    LVAR    vec4_size, pos
    
    mov     eax,dword[%$_pvec]
;    lea     edx,[%$pos]
;    M33addMulV3 edx,(RAS_main +raster.cam +camera.irm),eax
;    fld     dword[%$pos +vec3.z]
;    fsubr   dword[FOGmax]
;    fmul    dword[FOGdist]
    fld1
    fsub    dword[eax +vertex.z]
    fadd    st0
    fst     dword[%$pos]
    test    dword[%$pos],REAL_SIGNMASK
    jz      .isPositive
    ffreep  st0
    fldz
    jmp     .exit
.isPositive:
    fld1
    _FCOMP  st1
    jnc     .exit
    ffreep  st0
    fld1
.exit:
DECLEND
;==============================================================================
SDECL _VPGM_cyl
;==============================================================================
    LCTX    esp
    LARG    4, _vert, _rad, _hyp
    
    mov     edx,dword[%$_vert]
    mov     eax,dword[cylUVptr]
    fld     dword[edx +vertex.u0]
    fadd    dword[eax +vec4.x]
    fmul    dword[RAS_main +raster.xtinfo +xtexinfo.uvMax]
    fmul    dword[eax +vec4.z]
    fstp    dword[edx +vertex.u0]
    fld     dword[edx +vertex.v0]
    fadd    dword[eax +vec4.y]
    fmul    dword[RAS_main +raster.xtinfo +xtexinfo.uvMax +4]
    fmul    dword[eax +vec4.w]
    fstp    dword[edx +vertex.v0]
    mov     dword[edx +vertex.c +rgbaUP.b],255
    CCALL   _getFog, edx
    mov     edx,dword[%$_vert]
    fimul   dword[edx +vertex.c +rgbaUP.b]
    fst     dword[edx +vertex.c +rgbaUP.b]
    fst     dword[edx +vertex.c +rgbaUP.g]
    fstp    dword[edx +vertex.c +rgbaUP.r]
.exit:
DECLEND
;==============================================================================
SDECL _renderRod, 0
;==============================================================================
    CCALL   _updateRodCam
    TexClear    myscene +scene.fb
    TexClear    myscene +scene.zb
    
    mov     dword[cylUVptr],cyl2UVos
    M33id   OBJ_tform +objtform.rm
    V3setNull    OBJ_tform +objtform.rm +matrix.t
    ObjSetScale cyl2Scale
    ObjSetVpgm  _VPGM_cyl
    ObjSetFlags 0,0,0
    RasSetTex   0, gtexMetal1
    RasSetCulling CULLING_BACK
    RasSetFpgm  _FPGM_RGBxT0bi_Z
    RasSetVpgm  _VPGM_RGBT0
    RasSetVtxBuf [myobject], 256
    CCALL   _CYL_render3D, [cylMinRad],[cylPow], 32, 1

    mov     dword[cylUVptr],cylUVos
    ObjSetScale cylScale
;    ObjSetVpgm  _VPGM_cyl
;    ObjSetFlags 0,0,0
    RasSetTex   0, gtexCrystal
    RasSetCulling CULLING_FRONT
;    RasSetFpgm  _FPGM_RGBxT0bi_Z
;    RasSetVpgm  _VPGM_RGBT0
;    RasSetVtxBuf [myobject], 256
    CCALL   _CYL_render3D, [cylMinRad],[cylPow], 32, 1
    
    CCALL   _TEX32_downsample, hdrscene +scene.fb, myscene +scene.fb
    CCALL   _TEX_blur, hdrscene +scene.fb, hdrscene +scene.bb, 3, 60, 3
    CCALL   _TEX32_upsample, myscene +scene.fb, hdrscene +scene.fb
    CCALL   _LTNGSTORM_render, rodStorm
;    TexBlit myscene +scene.fb, hdrscene +scene.fb
.exit:
DECLEND
;==============================================================================
