
#ifndef NUM_LIGHTS
	#define NUM_LIGHTS 1
#endif

#ifndef ADAPTIVE_STEPS
	#define ADAPTIVE_STEPS
#endif

varying vec3 normal;
varying vec3 lightDir[NUM_LIGHTS];
varying vec3 eye;
varying float camdot;

uniform sampler2D t_color;
uniform sampler2D t_disp;
//uniform sampler2D t_normal;
/*uniform sampler2D t_occlusion;
uniform sampler2D t_specular;*/
uniform float parallaxHeight;
uniform float tx;	// 1./width
uniform float ty;	// 1./height

vec3 getNormal(vec2 xy) {
	//vec3 o = -1.0+2.0*texture2D(t_disp, xy).xyz;
	float o = texture2D(t_disp, xy).x;
	float h = texture2D(t_disp,xy+vec2(tx, 0.0)).x;
	float v = texture2D(t_disp, xy+vec2(0.0, ty)).y;
	float dh = o-h;
	float dv = o-v;
/*	float x0 = texture2D(t_disp, xy+vec2(-tx, 0.0)).x;
	float x1 = texture2D(t_disp, xy+vec2(+tx, 0.0)).x;
	float y0 = texture2D(t_disp, xy+vec2(0.0, -ty)).x;
	float y1 = texture2D(t_disp, xy+vec2(0.0, +tx)).x;
	float dh = x0-x1;
	float dv = y0-y1;*/
	return normalize(vec3(dh, dv, 0.95));
}

void main(void) {
	vec3 e = normalize(eye);

	#ifdef ADAPTIVE_STEPS
		//float lod = 3.0+50.0*camdot;
		//float lod = 100.0;
		float lod = 100.0-min(camdot*2.0, 10.0);
	#else
		float lod = 5.0;
	#endif

	vec2 texcoord = gl_TexCoord[0].xy;
	float height = texture2D(t_disp, texcoord).r;

	// steep
	//float numSteps = 5.0;
	float numSteps = lod;
	//numSteps = mix(numSteps*2.0, numSteps, e.x);
	float step = 1.0/numSteps;
	vec2 delta = vec2(-e.x,e.y)*parallaxHeight/(e.z*numSteps);
	float bheight = 1.0;
	int counter = 0;
	while (height < bheight && counter < 200) {
		bheight -= step;
		texcoord += delta;
		height = texture2D(t_disp, texcoord).r;
		counter++;
	}

	vec3 n = getNormal(texcoord);	//normalize(-1.0+2.0*texture2D(t_normal, texcoord).xyz);

	vec4 col = texture2D(t_color, texcoord);
	vec4 final = vec4(0.0);
	vec4 fambient = vec4(0.0);
	vec4 fdiff = vec4(0.0);
	vec4 fspec = vec4(0.0);

	for (int i = 0; i < NUM_LIGHTS; i++) {
		vec3 l = normalize(lightDir[i]);
		float diff = dot(n, l);

		fambient += gl_LightSource[i].ambient;

		if (diff > 0.0) {
			fdiff += gl_LightSource[i].diffuse*diff;

			vec3 r = reflect(-l, n);
			fspec += vec4(gl_LightSource[i].specular.xyz, 1.0)*pow(max(dot(r, e), 0.0), gl_LightSource[i].specular.w);
//			fspec += vec4(-0.5, -0.5, -0.5, 1.0)*pow(max(dot(r, e), 0.0), gl_LightSource[i].specular.w);
		}
	}

	gl_FragColor = fambient*col + fdiff*col + fspec;
}
