// simple vertex shader
varying vec3 normal,pos;
varying vec3 lightVec,eyeVec;
varying vec3 gen1,gen2,gen3;
attribute vec3 vTangent; 

varying vec4 v_position;
varying vec3 v_normal;
vec3 rotvec (vec3 invect, float u, float v, float w, float a)
{
    float ux = u*invect.x;
    float uy = u*invect.y;
    float uz = u*invect.z;
    float vx = v*invect.x;
    float vy = v*invect.y;
    float vz = v*invect.z;
    float wx = w*invect.x;
    float wy = w*invect.y;
    float wz = w*invect.z;
    float sa;
    float ca;
	vec3 ret;
    sa = sin(a);
    ca = cos(a);
    ret.x = u*(ux+vy+wz)+(invect.x*(v*v+w*w)-u*(vy+wz))*ca+(-wy+vz)*sa;
    ret.y = v*(ux+vy+wz)+(invect.y*(u*u+w*w)-v*(ux+wz))*ca+(wx-uz)*sa;
    ret.z = w*(ux+vy+wz)+(invect.z*(u*u+v*v)-w*(ux+vy))*ca+(-vx+uy)*sa;
	return ret;
}

void main()
{
int uv_gen_mode=0;
	gl_Position    = gl_ModelViewProjectionMatrix * gl_Vertex;
	gl_FrontColor  = gl_Color;
	pos=(gl_ModelViewProjectionMatrix*gl_Vertex).xyz;
	normal=gl_NormalMatrix*gl_Normal;
	

	vec3 n = normalize(gl_NormalMatrix * gl_Normal);
	normal=n;
	vec3 t = normalize(gl_NormalMatrix * vTangent);
	vec3 b = cross(n, t);
	vec3 vVertex = vec3(gl_ModelViewMatrix * gl_Vertex);
	vec3 tmpVec = gl_LightSource[0].position.xyz - vVertex;
	lightVec.x = dot(tmpVec, t);
	lightVec.y = dot(tmpVec, b);
	lightVec.z = dot(tmpVec, n);
	tmpVec = -vVertex;
	eyeVec.x = dot(tmpVec, t);
	eyeVec.y = dot(tmpVec, b);
	eyeVec.z = dot(tmpVec, n);
	//Uvmap generation
	vec3 temp;
	if(uv_gen_mode==0)
	temp=gl_Vertex.xyz;
	else
	temp=gl_Position.xyz;

	gen1=rotvec(temp,0.0,1.0,0.0,13.0);
	gen1=rotvec(gen1,1.0,0.0,0.0,46.0);
	gen2=rotvec(temp,0.0,0.0,1.0,28.0);
	gen2=rotvec(gen2,.1,.5,0.2,55.0)*vec3(1.5);
	gen3=rotvec(gen1,0.0,0.0,1.0,55.0);

	v_position=gl_Position;
	v_normal=normal;
	gl_TexCoord[0].xy = gl_MultiTexCoord0.xy;
}
