//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID59241dda_5ff5_485d_aaa1_3ad4177aab21
{
    public class Class_Switch : OperatorPart.Function,
                                Framefield.Core.OperatorPartTraits.ITraverseModifier
    {
        //>>> _inputids
        private enum InputId
        {
            Inputs = 0,
            Index = 1
        }
        //<<< _inputids

        public IEnumerable<OperatorPart> GetRelevantConnections()
        {
            List<OperatorPart> connections = new List<OperatorPart>();

            var inputs = OperatorPart.Connections[(int)InputId.Inputs];
            if (_currentIndex >= 0 && inputs.Connections.Count > 0)
                connections.Add(inputs.Connections[_currentIndex % inputs.Connections.Count]);

            connections.Add(OperatorPart.Connections[(int)InputId.Index]);

            return connections;
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Inputs = inputs[(int)InputId.Inputs];
            var Index = inputs[(int)InputId.Index].Eval(context).Value;
            //<<< _params

            _currentIndex = (int)Index;

            if (_currentIndex >= 0 && Inputs.Connections.Count > 0)
            {
                var selectedInput = Inputs.Connections[_currentIndex % Inputs.Connections.Count];
                selectedInput.Eval(context);
            }
            return context;
        }

        int _currentIndex;
    }
}
