//-----------------------------LICENSE NOTICE------------------------------------
//  This file is part of Hair Boy
//  Copyright (C) 2016 Carlos Sevila (@CarlosSevila)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------

#include "maps.h"

u8*** const kMaps[NUM_MAPS][MAP_HEIGHT][MAP_HALF_WIDTH] = {
    // Map 00
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x04, 0x0C, 0x08, 0x00, 0x00, 0x0C, 0x0C},
    	{0x5D, 0x00, 0x00, 0x04, 0x0C, 0x08, 0x00, 0x00, 0x0C, 0x0C},
    	{0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C}
    },
    // Map 01
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x08, 0x00, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0C},
    	{0x08, 0x00, 0x0C, 0x08, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0C},
    	{0x5D, 0x00, 0x0C, 0x19, 0x33, 0x33, 0x33, 0x33, 0x0C, 0x0C},
    	{0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C}
    },
    // Map 02
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x0E},
    	{0x08, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x0C, 0x0C, 0x0C},
    	{0x5D, 0x00, 0x00, 0x00, 0x0C, 0x33, 0x33, 0x0C, 0x0C, 0x0C},
    	{0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C}
    },
    // Map 03
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x04, 0x00, 0x59, 0xF3, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x04, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x04, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x5D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x0C, 0x59, 0xF3, 0xF3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0C},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26, 0x0C}
    },
    // Map 04
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x04},
    	{0x08, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x04},
    	{0x08, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x04},
    	{0x08, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x04},
    	{0x08, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x04},
    	{0x08, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x04},
    	{0x0D, 0x00, 0x0C, 0x33, 0x33, 0x33, 0x33, 0x0C, 0x00, 0xAE},
    	{0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C}
    },
    // Map 05
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x04, 0x0C, 0x08, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x04, 0x00, 0x00, 0x00, 0x0C, 0x04, 0x00, 0x08, 0x04},
    	{0x08, 0x04, 0x00, 0x00, 0x00, 0x0C, 0x04, 0x33, 0x08, 0x04},
    	{0x08, 0x04, 0x00, 0x00, 0x00, 0x0C, 0x04, 0x0C, 0x08, 0x04},
    	{0x08, 0x04, 0x00, 0x00, 0x00, 0x0C, 0x04, 0x0C, 0x08, 0x04},
    	{0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0C, 0x08, 0x04},
    	{0x0D, 0x04, 0x00, 0x00, 0x08, 0x00, 0x04, 0x0C, 0x08, 0xAE},
    	{0x0C, 0x0C, 0x33, 0x33, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C}
    },
    // Map 06
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x19, 0x26},
    	{0x08, 0x00, 0x45, 0x00, 0x08, 0x00, 0x45, 0x08, 0x00, 0x04},
    	{0x08, 0x00, 0x45, 0x00, 0x08, 0x00, 0x04, 0x0D, 0x00, 0x04},
    	{0x08, 0x00, 0x04, 0x00, 0x08, 0x00, 0x00, 0x0C, 0x08, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x08, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x04, 0x00, 0x08, 0x04},
    	{0x08, 0x00, 0x04, 0x00, 0x08, 0x00, 0x45, 0x00, 0x08, 0x04},
    	{0x08, 0x00, 0x45, 0x00, 0x08, 0x00, 0x04, 0x00, 0x08, 0x04},
    	{0x08, 0x00, 0x45, 0x00, 0x00, 0x00, 0x04, 0x00, 0x08, 0x04},
    	{0x08, 0x00, 0x45, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x04},
    	{0x5D, 0x00, 0x45, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x04},
    	{0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C}
    },
    // Map 07
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0A, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0C, 0x00, 0x45},
    	{0x5D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04},
    	{0x0C, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04},
    	{0x0C, 0x19, 0x33, 0x33, 0x08, 0x19, 0x33, 0x26, 0x00, 0x04},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04},
    	{0x0C, 0x04, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x00, 0x04},
    	{0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x0C, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x19, 0x26},
    	{0x0C, 0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x0C, 0x0C}
    },
    // Map 08
    {
        {0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x5D, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x00, 0x45},
    	{0x0C, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x33, 0x4D},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4F},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0C, 0x4D},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 09
    {
        {0x19, 0x33, 0x26, 0x33, 0x33, 0x19, 0x33, 0x26, 0x33, 0x26},
    	{0x08, 0x00, 0x04, 0x00, 0x00, 0x08, 0x00, 0x04, 0x00, 0x04},
    	{0x08, 0x00, 0x04, 0x00, 0x00, 0x08, 0x00, 0x04, 0x00, 0x0E},
    	{0x08, 0x04, 0x04, 0x00, 0x08, 0x08, 0x04, 0x04, 0x04, 0x0C},
    	{0x08, 0x04, 0x04, 0x00, 0x08, 0x08, 0x04, 0x04, 0x04, 0x0C},
    	{0x08, 0x04, 0x04, 0x00, 0x08, 0x08, 0x04, 0x04, 0x04, 0x0C},
    	{0x08, 0x04, 0x04, 0x00, 0x08, 0x08, 0x04, 0x04, 0x04, 0x0C},
    	{0x08, 0x04, 0x04, 0x00, 0x08, 0x08, 0x04, 0x04, 0x04, 0x0C},
    	{0x08, 0x04, 0x04, 0x00, 0x08, 0x08, 0x04, 0x04, 0x04, 0x0C},
    	{0x08, 0x04, 0x04, 0x00, 0x08, 0x08, 0x04, 0x04, 0x04, 0x0C},
    	{0x5D, 0x04, 0x00, 0x00, 0x08, 0x00, 0x04, 0x00, 0x04, 0x0C},
    	{0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C}
    },
    // Map 10
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x5D, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x33, 0x26},
    	{0x0C, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04},
    	{0x0C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x0E},
    	{0x0C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0C},
    	{0x0C, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0C},
    	{0x0C, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x04, 0x04, 0x0C},
    	{0x0C, 0x04, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x0C},
    	{0x0C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x04, 0x0C},
    	{0x0C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0C},
    	{0x0C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0C},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 11
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0xF3, 0xF3, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0xF3, 0xF3, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0xF3, 0xF3, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0xF3, 0xF3, 0x00, 0x00, 0x00, 0x04},
    	{0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAE},
    	{0x0C, 0x0C, 0x08, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0C, 0x0C},
    	{0x08, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 12
    {
        {0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26},
    	{0x8A, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x51, 0x00, 0x00, 0x00, 0x04, 0x0C, 0x00, 0x00, 0x45},
    	{0x8A, 0x51, 0x00, 0x00, 0x00, 0x51, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x51, 0x00, 0x00, 0x00, 0x51, 0x00, 0x00, 0x51, 0xE7},
    	{0x8A, 0x51, 0x00, 0x00, 0x00, 0x51, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x51, 0x00, 0x00, 0xF3, 0x51, 0x51, 0xA2, 0x00, 0x04},
    	{0x0D, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAE},
    	{0x0C, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0C},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 13
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x5D, 0x00, 0x00, 0xF3, 0x00, 0xF3, 0x00, 0x00, 0x00, 0x04},
    	{0x0C, 0x0C, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26, 0x00, 0x04},
    	{0x0C, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x0C, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x0C, 0x08, 0xA2, 0x00, 0x00, 0xA2, 0x00, 0xA2, 0x04, 0x0C},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 14
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x8A, 0x00, 0x00, 0x51, 0x00, 0x00, 0xA2, 0x00, 0x00, 0x45},
    	{0x8A, 0xA2, 0x00, 0x51, 0x00, 0x00, 0xA2, 0x00, 0x51, 0x45},
    	{0x8A, 0xA2, 0x00, 0x51, 0x00, 0x0A, 0xA2, 0x00, 0x51, 0x45},
    	{0x8A, 0xA2, 0x00, 0x00, 0x0C, 0x0C, 0x00, 0x00, 0x51, 0x45},
    	{0x8A, 0xA2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x51, 0x45},
    	{0x8A, 0xA2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x51, 0x45},
    	{0x8A, 0xA2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x51, 0x45},
    	{0x8A, 0xA2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x51, 0x45},
    	{0x8A, 0xA2, 0x00, 0x00, 0x55, 0x00, 0x00, 0x00, 0x51, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x45},
    	{0x19, 0x33, 0x33, 0x33, 0x0C, 0x0C, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 15
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x08, 0x0E},
    	{0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAE},
    	{0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x0C, 0x0C},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 16
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x04, 0x0C, 0x00, 0x04, 0x00, 0x04},
    	{0x08, 0x00, 0x08, 0x00, 0x0C, 0x08, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x19, 0x33, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x8E, 0x0C, 0x08, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x8E, 0x0C, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04},
    	{0x08, 0x00, 0x8E, 0x08, 0x00, 0x00, 0x00, 0x45, 0x00, 0x04},
    	{0x08, 0x00, 0x8E, 0x0D, 0x00, 0x00, 0x00, 0x45, 0x00, 0x04},
    	{0x5D, 0x00, 0x8E, 0x0C, 0x19, 0x33, 0x33, 0x26, 0x33, 0x26},
    	{0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C}
    },
    // Map 17
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x8A, 0x00, 0x04, 0x04, 0x04, 0x04, 0x04},
    	{0x08, 0x00, 0x00, 0x08, 0x00, 0x04, 0x33, 0x33, 0x26, 0xA6},
    	{0x08, 0x00, 0x00, 0xA2, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0xA2, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x08, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x8A, 0x00, 0x04, 0x04, 0x0C, 0x0C, 0x26},
    	{0x08, 0x00, 0x00, 0x8A, 0x00, 0x04, 0x00, 0x00, 0x00, 0x0C},
    	{0x5D, 0x00, 0x00, 0x8A, 0x00, 0x04, 0x51, 0x51, 0x05, 0x0C},
    	{0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x33, 0x33, 0x0C, 0x0C}
    },
    // Map 18
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x00, 0x8A, 0x45, 0x00, 0x8A, 0x45, 0x08, 0x00, 0x04},
    	{0x08, 0x00, 0x8A, 0x45, 0x00, 0x8A, 0x45, 0x08, 0x00, 0x04},
    	{0x08, 0x00, 0x8A, 0x45, 0x00, 0x8A, 0x45, 0x0D, 0x00, 0x04},
    	{0x08, 0x00, 0x08, 0x04, 0x00, 0x08, 0x04, 0x0C, 0x08, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x5D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x0C, 0x00, 0x08, 0x04, 0x00, 0x08, 0x04, 0x00, 0x08, 0x04},
    	{0x08, 0x00, 0x8A, 0x45, 0x00, 0x8A, 0x45, 0x00, 0x8A, 0x04},
    	{0x08, 0x00, 0x08, 0x04, 0x00, 0x08, 0x04, 0x00, 0x08, 0x04},
    	{0x59, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xA6},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 19
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x8A, 0x00, 0x00, 0x00, 0xA2, 0x00, 0xA2, 0x00, 0xA2, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0xA2, 0x00, 0xA2, 0x00, 0xA2, 0x45},
    	{0x8A, 0x00, 0x08, 0x00, 0xA2, 0x00, 0xA2, 0x00, 0xA2, 0x45},
    	{0x8A, 0x00, 0x08, 0x00, 0xA2, 0x00, 0xA2, 0x00, 0xA2, 0x45},
    	{0x8A, 0x00, 0x08, 0x00, 0xA2, 0x00, 0xA2, 0x00, 0xA2, 0x45},
    	{0x8A, 0x00, 0x08, 0x00, 0xA2, 0x00, 0xA2, 0x00, 0xA2, 0x45},
    	{0x8A, 0x00, 0x08, 0x00, 0xA2, 0x00, 0xA2, 0x00, 0xA2, 0x45},
    	{0x08, 0x00, 0x08, 0x00, 0xA2, 0x00, 0xA2, 0x00, 0xA2, 0x04},
    	{0x5D, 0x00, 0x08, 0x00, 0xA2, 0x00, 0xA2, 0x00, 0xA2, 0x0E},
    	{0x0C, 0x08, 0x08, 0x00, 0xA2, 0x00, 0xA2, 0x00, 0xA6, 0x0C},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 20
    {
        {0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x45},
    	{0x8A, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x45},
    	{0x8A, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x45},
    	{0x8A, 0x5D, 0x08, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0E, 0x45},
    	{0x8A, 0x0C, 0x08, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0C, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 21
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x5D, 0x00, 0x0C, 0x0C, 0x08, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x0C, 0x59, 0x0C, 0x0C, 0x08, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x0C, 0x0C, 0x0D, 0x00, 0x00, 0x00, 0x51, 0x45},
    	{0x08, 0x00, 0x0C, 0x0C, 0x0C, 0x0C, 0x00, 0x00, 0x51, 0x45},
    	{0x59, 0x19, 0x0C, 0x19, 0x33, 0x08, 0x00, 0x00, 0x51, 0x45},
    	{0x08, 0x00, 0x0C, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x0C, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x04, 0x59, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x59, 0x00, 0x08, 0x00, 0x19, 0x33, 0x33, 0x33, 0x33, 0x26},
    	{0x19, 0x33, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C}
    },
    // Map 22
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x5D, 0x00, 0x00, 0xF3, 0x00, 0x00, 0xF3, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0xF3, 0x00, 0x00, 0xF3, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0xF3, 0x00, 0x00, 0xF3, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x51, 0xF3, 0x00, 0x51, 0xF3, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E},
    	{0x59, 0xA2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26},
    	{0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C}
    },
    // Map 23
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAE},
    	{0x8A, 0x00, 0xA2, 0xA2, 0xA2, 0xA2, 0xA2, 0xA2, 0xA2, 0xA6},
    	{0x8A, 0x04, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x00, 0x45},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x08, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x0C, 0x59, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x45},
    	{0x0C, 0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 24
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x00, 0x8A, 0x00, 0x04, 0x0C, 0x00, 0x45, 0x00, 0x04},
    	{0x08, 0x00, 0x8A, 0x00, 0x04, 0x0C, 0x00, 0x45, 0x00, 0x04},
    	{0x08, 0x00, 0x8A, 0x00, 0x04, 0x2E, 0x00, 0x45, 0x00, 0x04},
    	{0x08, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04},
    	{0x08, 0x00, 0x8A, 0x00, 0x04, 0x04, 0x00, 0x45, 0x00, 0x04},
    	{0x08, 0x00, 0x8A, 0x00, 0x04, 0x0C, 0x00, 0x45, 0x00, 0x04},
    	{0x5D, 0x00, 0x8A, 0x00, 0x04, 0x0C, 0x00, 0x45, 0x00, 0x0E},
    	{0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C}
    },
    // Map 25
    {
        {0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x00, 0x45},
    	{0x5D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x0C, 0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 26
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x04, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x04, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x08, 0x04, 0x08, 0x04, 0x08, 0x04, 0x00, 0x04},
    	{0x08, 0x00, 0x08, 0x04, 0x08, 0x04, 0x08, 0x04, 0x00, 0x04},
    	{0x08, 0x00, 0x8A, 0x00, 0x00, 0x00, 0x00, 0x45, 0x00, 0x04},
    	{0x8A, 0x00, 0x8A, 0xA2, 0x00, 0x00, 0x51, 0x45, 0x00, 0x45},
    	{0x08, 0x00, 0x8A, 0x00, 0x51, 0xA2, 0x00, 0x45, 0x00, 0x04},
    	{0x08, 0x00, 0x19, 0x33, 0x26, 0x19, 0x33, 0x26, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0xAA, 0x00, 0x00, 0x00, 0x04},
    	{0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C}
    },
    // Map 27
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x8A, 0x00, 0x51, 0xA2, 0x4D, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x8A, 0x00, 0x51, 0xA7, 0x4D, 0x00, 0x00, 0x00, 0x00, 0xAE},
    	{0x8A, 0x00, 0x00, 0x0C, 0x4D, 0x00, 0x00, 0x00, 0x04, 0x0C},
    	{0x8A, 0x00, 0x00, 0x0C, 0x4D, 0x00, 0x00, 0x51, 0x45, 0x0C},
    	{0x08, 0x00, 0x00, 0x0C, 0x4D, 0x00, 0x00, 0x00, 0x45, 0x0C},
    	{0x08, 0x00, 0x00, 0x04, 0x0C, 0x00, 0x51, 0x00, 0x45, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x45, 0x0C},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x51, 0x00, 0x00, 0x45, 0x0C},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x0C},
    	{0x8A, 0x00, 0x00, 0xF3, 0x04, 0x33, 0x33, 0x33, 0x26, 0x0C},
    	{0x19, 0x33, 0x33, 0x33, 0x26, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C}
    },
    // Map 28
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x8A, 0xAA, 0x00, 0x00, 0x00, 0xA2, 0xA2, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0xA2, 0xA2, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0xA2, 0xA2, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0xA2, 0xA2, 0x51, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0xA2, 0xA2, 0x51, 0x00, 0x04},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E},
    	{0x8A, 0xF3, 0x00, 0xF3, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0C},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26},
    	{0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C}
    },
    // Map 29
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x8A, 0x00, 0x8A, 0x00, 0x04, 0xAE},
    	{0x0D, 0x00, 0x00, 0x00, 0x8A, 0x00, 0x8A, 0x00, 0x04, 0xA6},
    	{0x0C, 0x08, 0x00, 0x00, 0x8A, 0x00, 0x8A, 0x00, 0x00, 0x04},
    	{0x8A, 0x00, 0x00, 0xA2, 0x8A, 0x00, 0x08, 0x00, 0x00, 0x04},
    	{0x8A, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x04},
    	{0x8A, 0xA2, 0xA2, 0xA2, 0xF3, 0x00, 0x8A, 0x00, 0x00, 0x04},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8A, 0x00, 0x00, 0x04},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8A, 0x00, 0x00, 0x04},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x19, 0x33, 0x33, 0x26}
    },
    // Map 30
    {
        {0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x26},
    	{0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x45},
    	{0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0xA2, 0x00, 0x08, 0x45},
    	{0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x4D},
    	{0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04},
    	{0x5D, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0E},
    	{0x0C, 0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x0C, 0x0C}
    },
    // Map 31
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x0C, 0x08, 0x51, 0xA2, 0x51, 0xA2, 0x51, 0xA2, 0x04, 0x04},
    	{0x0C, 0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26, 0x04},
    	{0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x04},
    	{0x19, 0x19, 0x33, 0x19, 0x33, 0x19, 0x33, 0x19, 0x26, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x04, 0x08, 0x04, 0x08, 0x04, 0x08, 0x04, 0x08, 0x04},
    	{0x5D, 0x04, 0x08, 0x04, 0x08, 0x04, 0x08, 0x04, 0x08, 0x04},
    	{0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C}
    },
    // Map 32
    {
        {0x19, 0x33, 0x33, 0x26, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x08, 0x04, 0x0A, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x04, 0x00, 0x0C, 0x0C, 0x00, 0xA2, 0x45},
    	{0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x51, 0x45},
    	{0x08, 0x04, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x5D, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x0C, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0xA2, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 33
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x5D, 0x04, 0x00, 0x00, 0x04, 0x00, 0x00, 0x04, 0x00, 0x04},
    	{0x59, 0xA6, 0x00, 0x00, 0x04, 0x00, 0x00, 0x04, 0x0A, 0x04},
    	{0x8A, 0x04, 0x00, 0x08, 0x04, 0x00, 0x08, 0x04, 0x08, 0x04},
    	{0x8A, 0x04, 0x00, 0x08, 0x04, 0x00, 0x08, 0x45, 0x00, 0x04},
    	{0x8A, 0x04, 0x00, 0x08, 0x04, 0x00, 0x08, 0x45, 0x00, 0x04},
    	{0x8A, 0x04, 0x00, 0x08, 0x04, 0x00, 0x08, 0x45, 0x00, 0x04},
    	{0x8A, 0x45, 0x00, 0x08, 0x45, 0x00, 0x08, 0x45, 0x00, 0x45},
    	{0x8A, 0x45, 0x00, 0x08, 0x45, 0x00, 0x08, 0x45, 0x00, 0x45},
    	{0x8A, 0x04, 0x00, 0x08, 0x04, 0x00, 0x08, 0x04, 0xA2, 0x45},
    	{0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x45},
    	{0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C}
    },
    // Map 34
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x19, 0x26},
    	{0x5D, 0x00, 0x08, 0x04, 0x00, 0x00, 0x04, 0x00, 0x00, 0x04},
    	{0x0C, 0x08, 0x08, 0x04, 0x00, 0x00, 0x04, 0x0A, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x04, 0x00, 0x04, 0x04, 0x0C, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04},
    	{0x0C, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04},
    	{0x1D, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04},
    	{0x0C, 0x00, 0x00, 0x00, 0x08, 0x04, 0x00, 0x00, 0x00, 0x04},
    	{0x0C, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 35
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x51, 0x51, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x51, 0x51, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x51, 0x51, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x51, 0x51, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x51, 0x51, 0x00, 0x00, 0x00, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E},
    	{0x08, 0x00, 0x00, 0x00, 0x51, 0x51, 0x00, 0x00, 0x00, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x51, 0x51, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x51, 0x51, 0x00, 0x00, 0x00, 0x04},
    	{0x5D, 0x00, 0x00, 0x00, 0x51, 0x51, 0x00, 0x00, 0x00, 0x0E},
    	{0x0C, 0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26, 0x0C}
    },
    // Map 36
    {
        {0x19, 0x33, 0x26, 0x33, 0x33, 0x33, 0x33, 0x0C, 0x0C, 0x0C},
    	{0x8A, 0x00, 0x45, 0x00, 0x00, 0x00, 0x00, 0x8A, 0x00, 0x04},
    	{0x8A, 0xAA, 0x45, 0x00, 0x00, 0x00, 0x00, 0x8A, 0x00, 0x0E},
    	{0x8A, 0x08, 0x45, 0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x0C},
    	{0x8A, 0x00, 0x45, 0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x45},
    	{0x8A, 0x00, 0x04, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x45, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x45, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x45, 0x00, 0x00, 0x00, 0x04, 0x45},
    	{0x8A, 0x08, 0x00, 0x0C, 0x45, 0x04, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x45, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x19, 0x33, 0x33, 0x33, 0x26, 0x33, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 37
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x5D, 0x08, 0x00, 0x8E, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04},
    	{0x59, 0x08, 0x00, 0x8E, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x8E, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04},
    	{0x08, 0x00, 0x00, 0x8E, 0x0A, 0x00, 0x00, 0x00, 0x04, 0x04},
    	{0x08, 0x00, 0x00, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x04, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x04, 0x33, 0x33, 0x33, 0x26, 0x04},
    	{0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04},
    	{0x08, 0x00, 0x00, 0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x8A, 0xA2, 0xA2, 0xA2, 0xA2, 0xA2, 0xA6},
    	{0x19, 0x33, 0x33, 0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 38
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x51, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x04},
    	{0x08, 0x04, 0x33, 0x33, 0x26, 0x00, 0x08, 0x00, 0x00, 0x04},
    	{0x08, 0x04, 0x0C, 0x0C, 0x0C, 0x08, 0x08, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x45, 0x08, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0xA2, 0xA2, 0x00, 0x45, 0x08, 0x00, 0x00, 0x00, 0x04},
    	{0x19, 0x33, 0x33, 0x08, 0x45, 0x59, 0x00, 0x00, 0x00, 0x04},
    	{0x0C, 0x0C, 0x0C, 0x08, 0x45, 0x08, 0x00, 0xF3, 0x00, 0x04},
    	{0x0D, 0x00, 0x00, 0x00, 0x45, 0x08, 0x00, 0x00, 0x08, 0xAE},
    	{0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x19, 0x33, 0x33, 0x0C, 0x0C}
    },
    // Map 39
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x5D, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x59, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8A, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8A, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0xA2, 0x00, 0x8A, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0xA2, 0x00, 0x8A, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8A, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8A, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8A, 0x4F},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x0C, 0x0C}
    },
    // Map 40
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x8A, 0x00, 0x00, 0x00, 0x5D, 0x04, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x59, 0xA6, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x04, 0x00, 0xA2, 0x51, 0x00, 0x08, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x19, 0x33, 0x33, 0x26, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0xA2, 0x00, 0xA2, 0x00, 0x0A, 0x51, 0x00, 0x51, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x04, 0x08, 0x00, 0x00, 0x00, 0x45},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 41
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x04, 0x0C, 0x08, 0xA2, 0x51, 0x00, 0xA2, 0x00, 0x04},
    	{0x08, 0x00, 0x04, 0x19, 0x33, 0x33, 0x33, 0x33, 0x26, 0x04},
    	{0x08, 0x00, 0x04, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x04},
    	{0x08, 0x00, 0x04, 0x00, 0x08, 0x00, 0x00, 0xA2, 0x00, 0x04},
    	{0x59, 0xF3, 0xA6, 0x00, 0x0D, 0x00, 0x00, 0xA2, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x0C, 0x08, 0x00, 0xA2, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x0C, 0x08, 0x00, 0xA2, 0x00, 0x04},
    	{0x59, 0xF3, 0xA6, 0x55, 0x0C, 0x08, 0x00, 0xA2, 0x00, 0x04},
    	{0x19, 0x33, 0x26, 0x0C, 0x0C, 0x19, 0x33, 0x19, 0x33, 0x26}
    },
    // Map 42
    {
        {0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0xA2, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0xA2, 0x00, 0x8A, 0xA2, 0x00, 0x00, 0x04, 0x00, 0x45},
    	{0x8A, 0xA2, 0x00, 0x8A, 0xA2, 0x00, 0x00, 0x45, 0x00, 0x45},
    	{0x8A, 0xA2, 0x00, 0x8A, 0xA2, 0x00, 0x51, 0x45, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x8A, 0x00, 0x00, 0x51, 0x45, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x8A, 0x00, 0x00, 0x51, 0x45, 0x00, 0x45},
    	{0x8A, 0x00, 0xAA, 0x8A, 0x00, 0x00, 0x00, 0x45, 0x05, 0x45},
    	{0x8A, 0x04, 0x08, 0x8A, 0x00, 0x00, 0x00, 0x45, 0x0C, 0x4D},
    	{0x19, 0x33, 0x33, 0x19, 0x33, 0x33, 0x33, 0x26, 0x33, 0x26}
    },
    // Map 43
    {
        {0x0C, 0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x0C, 0x0C},
    	{0x5D, 0x00, 0x00, 0x00, 0xF3, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x0C, 0x00, 0x00, 0x00, 0xF3, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x8A, 0x00, 0x00, 0x00, 0xF3, 0x00, 0x00, 0x00, 0x00, 0x0E},
    	{0x8A, 0x00, 0x00, 0x00, 0xF3, 0x00, 0x00, 0x00, 0x04, 0x0C},
    	{0x8A, 0x00, 0x00, 0x00, 0xF3, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0xF3, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0xF3, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0xF3, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0xF3, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0xF3, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 44
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x00, 0x55, 0x45},
    	{0x0D, 0x00, 0x51, 0x51, 0x51, 0x00, 0x45, 0x00, 0x51, 0x45},
    	{0x0C, 0x0C, 0x19, 0x19, 0x19, 0x08, 0x45, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0xF3, 0x51, 0x51, 0x51, 0x45, 0x00, 0x00, 0x45},
    	{0x08, 0x04, 0x33, 0x33, 0x33, 0x33, 0x26, 0xA2, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0xA2, 0xA2, 0xA2, 0xA2, 0xA2, 0xA2, 0xA2, 0x00, 0x45},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 45
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x04},
    	{0x08, 0x0C, 0x0C, 0x0C, 0x08, 0x04, 0x0C, 0x0C, 0x0C, 0x04},
    	{0x08, 0x08, 0x00, 0x00, 0x08, 0x04, 0x00, 0x00, 0xAE, 0x04},
    	{0x08, 0x0D, 0x00, 0x00, 0x0C, 0x0C, 0x00, 0x04, 0x0C, 0x04},
    	{0x08, 0x0C, 0x08, 0x00, 0x0C, 0x0C, 0x00, 0x00, 0x04, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x00, 0x00, 0x04, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x00, 0x00, 0x04, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x04},
    	{0x0C, 0x33, 0x33, 0x33, 0x0C, 0x0C, 0x33, 0x33, 0x0C, 0x0C}
    },
    // Map 46
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x5D, 0x08, 0x00, 0x00, 0x04, 0x2E, 0x04, 0x00, 0x00, 0x45},
    	{0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0A, 0x00, 0x45},
    	{0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0C, 0x00, 0x45},
    	{0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE7},
    	{0x08, 0x08, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0xE7},
    	{0x08, 0x08, 0x00, 0x00, 0x45, 0x45, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x08, 0x00, 0x00, 0x45, 0x45, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x45, 0x45, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x45, 0x4D, 0x51, 0xA2, 0x00, 0x45},
    	{0x59, 0xA2, 0x00, 0x00, 0x45, 0x4D, 0x00, 0x00, 0x00, 0x45},
    	{0x19, 0x33, 0x33, 0x33, 0x26, 0x0C, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 47
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x04, 0x2E, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAE},
    	{0x08, 0x00, 0x00, 0x51, 0x51, 0x51, 0x51, 0x51, 0x04, 0x0C},
    	{0x08, 0x19, 0x33, 0x33, 0x26, 0x04, 0x33, 0x33, 0x26, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x59, 0x51, 0x51, 0x51, 0x00, 0x00, 0x00, 0x51, 0x00, 0x0E},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26, 0x0C}
    },
    // Map 48
    {
        {0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x04, 0x0C, 0x59, 0xA6, 0x0C, 0x08, 0x00, 0x45},
    	{0x8A, 0x00, 0x04, 0x00, 0x00, 0x51, 0x00, 0x08, 0x00, 0x45},
    	{0x8A, 0x00, 0x04, 0x15, 0x00, 0x51, 0x00, 0x08, 0x00, 0x45},
    	{0x8A, 0x00, 0x04, 0x00, 0x00, 0x51, 0x05, 0x08, 0x00, 0x45},
    	{0x8A, 0x00, 0x04, 0x0C, 0x0C, 0x0C, 0x0C, 0x08, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x51, 0x51, 0x51, 0x04, 0x08, 0xA2, 0xA2, 0xA2, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 49
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x5D, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x0C, 0x00, 0x0C, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x8A, 0x00, 0x0C, 0x0C, 0x0C, 0x08, 0x00, 0xA2, 0x00, 0x04},
    	{0x8A, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x8A, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x8A, 0x00, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x8A, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x8A, 0x00, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x04},
    	{0x8A, 0x00, 0x08, 0x00, 0x04, 0x08, 0x00, 0x00, 0x00, 0x04},
    	{0x8A, 0x00, 0x00, 0x00, 0x0C, 0x08, 0x00, 0x00, 0x00, 0x04},
    	{0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x19, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 50
    {
        {0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0xAA, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x04, 0x0C, 0x08, 0x04, 0x00, 0x00, 0x04, 0x00, 0x04},
    	{0x08, 0x04, 0x00, 0x00, 0x04, 0x00, 0x00, 0x04, 0x00, 0x04},
    	{0x08, 0x04, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x00, 0x04},
    	{0x08, 0x04, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x00, 0x04},
    	{0x08, 0x04, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04},
    	{0x08, 0x04, 0x0C, 0x08, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x0C}
    },
    // Map 51
    {
        {0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0xA2, 0xA2, 0xA2, 0xA2, 0xA2, 0xA2, 0xE7},
    	{0x8A, 0x00, 0x19, 0x33, 0x33, 0x33, 0x26, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0xA2, 0x00, 0x00, 0x00, 0x45, 0x00, 0x00, 0x45},
    	{0x8A, 0x51, 0x05, 0x00, 0x00, 0x00, 0x45, 0x00, 0x51, 0x45},
    	{0x19, 0x33, 0x0C, 0x33, 0x33, 0x33, 0x26, 0x00, 0x51, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x51, 0x45},
    	{0x8A, 0xAA, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x0C, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x00, 0x45},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 52
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x5D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x0C, 0x0C, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x45},
    	{0x0D, 0x00, 0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x45},
    	{0x0C, 0x00, 0xDB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8A, 0x45},
    	{0x08, 0x00, 0x8A, 0x00, 0x00, 0x51, 0x00, 0x00, 0x8A, 0x45},
    	{0x08, 0x00, 0x19, 0x33, 0x33, 0x33, 0x33, 0x26, 0x08, 0x45},
    	{0x0C, 0x00, 0x04, 0x0C, 0x0C, 0x0C, 0x0C, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x19, 0x33, 0x0C, 0x26, 0x19, 0x0C, 0x26, 0x0C, 0x26, 0x0C}
    },
    // Map 53
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5D, 0x04},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0C, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0xA2, 0x00, 0x0C, 0x08, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0xA2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0xA2, 0x00, 0x00, 0x04},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x0C}
    },
    // Map 54
    {
        {0x19, 0x33, 0x33, 0x26, 0x0C, 0x33, 0x33, 0x33, 0x33, 0x26},
    	{0x8A, 0x00, 0x00, 0x04, 0xAE, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x05, 0x04, 0xA2, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0xDB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF3, 0xF3, 0xE7},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0xF3, 0x00, 0x00, 0x00, 0x00, 0xF3, 0x00, 0x00, 0x45},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 55
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x51, 0x51, 0x51, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x51, 0x51, 0x51, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x51, 0x51, 0x51, 0x00, 0x04},
    	{0x08, 0x00, 0x04, 0x00, 0x08, 0x51, 0x51, 0x51, 0x00, 0x04},
    	{0x08, 0x00, 0x45, 0x00, 0x8A, 0x51, 0x51, 0x51, 0x00, 0x04},
    	{0x08, 0x00, 0x45, 0x00, 0x8A, 0x51, 0x51, 0x51, 0x00, 0x04},
    	{0x08, 0x00, 0x45, 0x00, 0x8A, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x45, 0x00, 0x8A, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x5D, 0x00, 0x45, 0x00, 0x8A, 0x00, 0x00, 0x00, 0x00, 0x0E},
    	{0x0C, 0x08, 0x45, 0x00, 0x8A, 0x00, 0x00, 0x00, 0x0C, 0x0C},
    	{0x19, 0x33, 0x26, 0x33, 0x19, 0x33, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 56
    {
        {0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26, 0x33, 0x26},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x0E},
    	{0x8A, 0x00, 0x00, 0x00, 0x51, 0x00, 0x00, 0x04, 0x04, 0x0C},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04},
    	{0x19, 0x26, 0x51, 0x00, 0x00, 0x00, 0x00, 0x04, 0xA2, 0x04},
    	{0x8A, 0x00, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x8A, 0x00, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x8A, 0xAA, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x0C, 0x0C, 0xA2, 0x00, 0x00, 0x00, 0x00, 0xA2, 0xA2, 0x04},
    	{0x0C, 0x0C, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 57
    {
        {0x0C, 0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x0C, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0xA2, 0x45},
    	{0x8A, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x00, 0x45},
    	{0x8A, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0xA2, 0x45, 0x00, 0xE7},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x00, 0x04},
    	{0x8A, 0x00, 0x00, 0xA2, 0x00, 0x00, 0x00, 0x45, 0x00, 0xAE},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26, 0x0C, 0x0C}
    },
    // Map 58
    {
        {0x19, 0x33, 0x33, 0x33, 0x33, 0x26, 0x33, 0x33, 0x33, 0x26},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x45, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x45, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x04, 0x00, 0x45, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x04, 0x08, 0x04, 0x08, 0x08, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x04, 0x00, 0x00, 0x08, 0x19, 0x08, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x00, 0x45},
    	{0x8A, 0xAE, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x00, 0x45},
    	{0x8A, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x04, 0x0C, 0x0C, 0x08, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 59
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x04, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x00, 0x04},
    	{0x5D, 0x04, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x04},
    	{0x0C, 0x04, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x04},
    	{0x0C, 0x04, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x04},
    	{0x0C, 0x04, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x04},
    	{0x0C, 0x04, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x04},
    	{0x0C, 0x04, 0x0C, 0x00, 0x0C, 0x08, 0x04, 0x0C, 0x0C, 0x04},
    	{0x0C, 0x04, 0x0C, 0x00, 0x0C, 0x08, 0x04, 0x0C, 0x0C, 0x04},
    	{0x0C, 0x04, 0x0C, 0x00, 0x0C, 0x08, 0x04, 0x0C, 0x0C, 0x04},
    	{0x0C, 0x15, 0x00, 0x00, 0x00, 0x00, 0x51, 0xF3, 0xF3, 0x04},
    	{0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C}
    },
    // Map 60
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x5D, 0x00, 0x00, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x0C, 0x0C, 0x08, 0x00, 0x00, 0x00, 0x04, 0x0C, 0x0C, 0x0C},
    	{0x0C, 0x0C, 0x08, 0x00, 0x00, 0x00, 0x51, 0xF3, 0xF3, 0x04},
    	{0x0C, 0x0C, 0x08, 0x00, 0x00, 0x00, 0x51, 0xF3, 0xA6, 0x04},
    	{0x0C, 0x0C, 0x08, 0x00, 0x00, 0x00, 0x51, 0xF3, 0x0C, 0x04},
    	{0x0C, 0x0C, 0x08, 0x00, 0x00, 0x2A, 0x51, 0xA6, 0x0C, 0x04},
    	{0x0C, 0x0C, 0x08, 0x00, 0x00, 0x00, 0x51, 0x0C, 0x0C, 0x04},
    	{0x0C, 0x0C, 0x08, 0x00, 0x00, 0x00, 0x04, 0x0C, 0x0C, 0x04},
    	{0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x00, 0x00, 0x04},
    	{0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0A, 0x00, 0x04},
    	{0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C}
    },
    // Map 61
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x0C, 0x0C, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x08, 0x00, 0x00, 0xA2, 0x00, 0x00, 0x00, 0x04},
    	{0x5D, 0x00, 0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26, 0x04},
    	{0x0C, 0x08, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x04},
    	{0x1D, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x51, 0x04},
    	{0x0C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0xA2, 0xA2, 0xA2, 0xA2, 0xA2, 0xA2, 0xA2, 0xA2, 0x04},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 62
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x00, 0x08, 0x00, 0x1D, 0x0C, 0x00, 0xA2, 0x00, 0x04},
    	{0x5D, 0x00, 0x08, 0x00, 0x08, 0x0C, 0x00, 0xA2, 0x00, 0x0E},
    	{0x0C, 0x08, 0x08, 0x00, 0x00, 0x0C, 0x00, 0xA2, 0x04, 0x0C},
    	{0x08, 0x00, 0x08, 0x00, 0x00, 0x0C, 0x00, 0xA2, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x08, 0x0C, 0x00, 0xA2, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x08, 0x0C, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x08, 0x0C, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x51, 0x00, 0x00, 0x45},
    	{0x19, 0x33, 0x33, 0x33, 0x0C, 0x0C, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 63
    {
        {0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26, 0x0C},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAE},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C},
    	{0x8A, 0x04, 0x0C, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x04, 0x2E, 0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x04, 0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x04, 0x8A, 0xA2, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8E, 0x0C, 0x04, 0x8A, 0xA2, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8E, 0x00, 0x04, 0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8E, 0x0A, 0x04, 0x8A, 0x00, 0x00, 0x00, 0x00, 0x51, 0x45},
    	{0x8E, 0x0C, 0x0C, 0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x0C, 0x0C, 0x0C, 0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 64
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x04},
    	{0x08, 0x00, 0x1D, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04},
    	{0x08, 0x00, 0x51, 0x00, 0x59, 0xA6, 0x00, 0xA2, 0x00, 0x04},
    	{0x08, 0x00, 0x51, 0x00, 0x08, 0x04, 0x00, 0xA2, 0x00, 0x04},
    	{0x08, 0x00, 0x51, 0x00, 0x08, 0x0E, 0x00, 0xA2, 0x00, 0x04},
    	{0x08, 0x00, 0x51, 0x00, 0x0C, 0x0C, 0x00, 0xA2, 0x00, 0x04},
    	{0x08, 0x00, 0x51, 0x00, 0x00, 0x00, 0x00, 0xA2, 0x00, 0x04},
    	{0x08, 0x00, 0x51, 0x00, 0x00, 0x00, 0x00, 0xA2, 0x00, 0x04},
    	{0x08, 0x00, 0x51, 0x00, 0x00, 0x00, 0x00, 0xA2, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x19, 0x33, 0x33, 0x33, 0x0C, 0x0C, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 65
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x5D, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x59, 0xA6, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x59, 0xF3, 0xF3, 0xA6, 0x00, 0x00, 0x00, 0x04, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x2E, 0x00, 0x00, 0x00, 0x45, 0x00, 0x45},
    	{0x59, 0xF3, 0xF3, 0xA6, 0x00, 0xA2, 0x00, 0x45, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0xA2, 0x00, 0x45, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x00, 0x45},
    	{0x59, 0x51, 0x51, 0x51, 0x00, 0x00, 0x00, 0x45, 0x05, 0x45},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26, 0x0C, 0x0C}
    },
    // Map 66
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x8A, 0x00, 0x00, 0xAE, 0x45, 0x4D, 0x04, 0x00, 0x00, 0x45},
    	{0x8A, 0xA2, 0x04, 0x0C, 0x45, 0x4D, 0x04, 0x0A, 0x00, 0x45},
    	{0x8A, 0xA2, 0x00, 0x00, 0x04, 0x2E, 0x04, 0x0C, 0x00, 0x45},
    	{0x8A, 0xA2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x45},
    	{0x8A, 0xA2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x8A, 0xA2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x8A, 0xA2, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x04},
    	{0x8A, 0xA2, 0x00, 0x00, 0x45, 0x4D, 0x00, 0x51, 0x00, 0x04},
    	{0x8A, 0xA2, 0x00, 0x00, 0x45, 0x4D, 0x00, 0x51, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x45, 0x4D, 0x00, 0x51, 0x00, 0x45},
    	{0x19, 0x33, 0x33, 0x33, 0x26, 0x0C, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 67
    {
        {0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0xA2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0xA2, 0x00, 0xA2, 0x00, 0xA2, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0xA2, 0x00, 0xA2, 0x00, 0x45},
    	{0x5D, 0x00, 0x00, 0x00, 0x00, 0xA2, 0x00, 0xA2, 0x00, 0x45},
    	{0x0C, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x08, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xA2, 0x45},
    	{0x08, 0x00, 0x00, 0x2A, 0x00, 0x00, 0x00, 0x00, 0xA2, 0x45},
    	{0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xA2, 0x45},
    	{0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C}
    },
    // Map 68
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x19, 0x26, 0x33, 0x19, 0x26, 0x33, 0x19, 0x26, 0x33, 0x26},
    	{0x08, 0x04, 0x00, 0x08, 0x04, 0x00, 0x08, 0x04, 0x00, 0x04},
    	{0x5D, 0x51, 0x00, 0x08, 0x04, 0x00, 0x08, 0x51, 0x00, 0x04},
    	{0x59, 0x51, 0x00, 0xA2, 0x04, 0x00, 0xA2, 0x51, 0x00, 0x0E},
    	{0x08, 0x51, 0x00, 0xA2, 0x51, 0x00, 0xA2, 0x51, 0x04, 0x0C},
    	{0x08, 0x51, 0x00, 0xA2, 0x51, 0x00, 0xA2, 0x51, 0x00, 0x04},
    	{0x08, 0x51, 0x00, 0xA2, 0x04, 0x00, 0xA2, 0x51, 0x00, 0x04},
    	{0x08, 0x51, 0x00, 0x08, 0x04, 0x00, 0x08, 0x51, 0x00, 0x04},
    	{0x08, 0x04, 0x00, 0x08, 0x04, 0x00, 0x08, 0x04, 0x00, 0x04},
    	{0x19, 0x26, 0x33, 0x19, 0x26, 0x33, 0x19, 0x26, 0x33, 0x26},
    	{0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C}
    },
    // Map 69
    {
        {0x0C, 0x0C, 0x0C, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26},
    	{0x0C, 0x08, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C},
    	{0x08, 0x00, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAE},
    	{0x0D, 0x00, 0x45, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x0C},
    	{0x0C, 0x08, 0x45, 0xA2, 0x08, 0x00, 0xA2, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x45, 0x00, 0x8A, 0x00, 0xA2, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x45, 0x00, 0x8A, 0xA2, 0xA2, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0xE7, 0x00, 0x8A, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x04, 0x00, 0x8A, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x8A, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0xA2, 0xA2, 0xA2, 0x8A, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x19, 0x33, 0x33, 0x33, 0x19, 0x33, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 70
    {
        {0x19, 0x33, 0x33, 0x33, 0x19, 0x33, 0x33, 0x26, 0x0C, 0x0C},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xAA, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x08, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0xA2, 0x51, 0x04, 0x0C, 0x00, 0x45},
    	{0x08, 0x00, 0x19, 0x33, 0x33, 0x33, 0x33, 0x26, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0x00, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x45},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 71
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0xA2, 0x00, 0x00, 0x45, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0xA2, 0x00, 0x00, 0x45, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0xA2, 0xA2, 0x00, 0x04, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0xA2, 0xA2, 0x00, 0x51, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0xA2, 0xA2, 0x00, 0x51, 0x0E},
    	{0x08, 0x55, 0x00, 0x00, 0x00, 0xA2, 0xA2, 0x00, 0x04, 0x0C},
    	{0x08, 0x0C, 0x0C, 0x00, 0x00, 0xA2, 0x00, 0x00, 0x45, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0xA2, 0x00, 0x00, 0x45, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x0C},
    	{0x19, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26, 0x0C}
    },
    // Map 72
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x19, 0x33, 0x26, 0x0C, 0x0C},
    	{0x5D, 0x00, 0x00, 0x00, 0x1D, 0x08, 0x00, 0x04, 0x00, 0x04},
    	{0x0C, 0x0C, 0x08, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x04, 0x04, 0x04},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x04, 0x04},
    	{0x8A, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0xA2, 0xA6, 0x04},
    	{0x19, 0x33, 0x33, 0x33, 0x08, 0x19, 0x33, 0x33, 0x26, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0xA2, 0xA2, 0x04, 0x08, 0x04, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0xA2, 0xA2, 0x00, 0x00, 0x04, 0x04},
    	{0x0D, 0x00, 0xA2, 0xA2, 0xA2, 0xA2, 0x00, 0x00, 0x00, 0x04},
    	{0x0C, 0x19, 0x33, 0x33, 0x0C, 0x0C, 0x0C, 0x26, 0x0C, 0x0C}
    },
    // Map 73
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0xF3, 0xF3, 0xA2, 0x0C, 0x00, 0xAE},
    	{0x08, 0x00, 0x00, 0x00, 0xF3, 0xF3, 0xA7, 0x08, 0x04, 0x0C},
    	{0x08, 0x00, 0x00, 0x00, 0xF3, 0xF3, 0x0C, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x2A, 0x00, 0xF3, 0xF3, 0x08, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0xF3, 0xA6, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0xF3, 0x08, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0xA6, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x0C, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x04},
    	{0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x19, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 74
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x5D, 0x00, 0x04, 0x51, 0xF3, 0xA2, 0x00, 0x00, 0x00, 0x2E},
    	{0x0C, 0x00, 0x04, 0x51, 0xF3, 0xA2, 0x00, 0x00, 0x00, 0x0C},
    	{0x08, 0x00, 0x04, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x04, 0x0A, 0x08, 0x00, 0x00, 0x00, 0x08, 0x45},
    	{0x08, 0x00, 0x04, 0x0C, 0x08, 0x00, 0x00, 0x00, 0x08, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x45},
    	{0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x45},
    	{0x08, 0x00, 0x00, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x19, 0x33, 0x33, 0x0C, 0x0C, 0x33, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 75
    {
        {0x19, 0x33, 0x33, 0x0C, 0x33, 0x26, 0x33, 0x33, 0x33, 0x26},
    	{0x8A, 0xF3, 0x00, 0x00, 0x00, 0x45, 0x00, 0x00, 0x00, 0x45},
    	{0x8A, 0xF3, 0x00, 0x00, 0x00, 0x45, 0x55, 0x00, 0x00, 0x45},
    	{0x8A, 0xF3, 0x00, 0x00, 0x00, 0x45, 0x04, 0x08, 0x00, 0x45},
    	{0x8A, 0xF3, 0x00, 0x00, 0x51, 0x45, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0xF3, 0x00, 0x00, 0x51, 0x04, 0x00, 0x00, 0x00, 0x0C},
    	{0x59, 0xF3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E},
    	{0xDB, 0xA6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C},
    	{0x8A, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x08, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45},
    	{0x0D, 0x45, 0x00, 0xA2, 0x00, 0x51, 0x00, 0x00, 0x51, 0x45},
    	{0x0C, 0x0C, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x26}
    },
    // Map 76
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x5D, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x0C, 0x0C, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x0C, 0x0C, 0x00, 0x15, 0x00, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x0C, 0x0C, 0x00, 0x00, 0x00, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x0C, 0x0C, 0x00, 0x00, 0x51, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x0C, 0x0C, 0x00, 0x00, 0x51, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x0C, 0x0C, 0x00, 0x00, 0x51, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x0C, 0x0C, 0x00, 0x00, 0x51, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x0C, 0x0C, 0x00, 0x00, 0x51, 0x0C, 0x0C, 0x0C, 0x00, 0x0C},
    	{0x0C, 0x0C, 0x00, 0x00, 0x51, 0x00, 0x00, 0x00, 0x05, 0x0C},
    	{0x0C, 0x0C, 0x33, 0x33, 0x26, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C}
    },
    // Map 77
    {
        {0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x0C, 0x0C, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x04, 0x0C, 0x0C},
    	{0x0C, 0x5D, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 0x0C, 0x0C},
    	{0x0C, 0x0C, 0x0C, 0x04, 0x00, 0x04, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x0C, 0x0C, 0x0C, 0x00, 0x15, 0x51, 0xA6, 0x0C, 0x0C, 0x0C},
    	{0x0C, 0x0C, 0x0C, 0x00, 0x00, 0x51, 0xF3, 0xA2, 0x04, 0x0C},
    	{0x0C, 0x0C, 0x0C, 0x00, 0x00, 0x51, 0xF3, 0xA2, 0x0E, 0x0C},
    	{0x0C, 0x0C, 0x00, 0x00, 0x00, 0x51, 0xA6, 0x0C, 0x0C, 0x0C},
    	{0x0C, 0x0C, 0x0C, 0x0C, 0x00, 0x04, 0x0C, 0x0C, 0x0C, 0x0C},
    	{0x0C, 0x0C, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x04, 0x0C, 0x0C},
    	{0x0C, 0x0C, 0x0C, 0x0C, 0x00, 0x00, 0x00, 0x04, 0x0C, 0x0C},
    	{0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C}
    }
};
