//-----------------------------LICENSE NOTICE------------------------------------
//  This file is part of CPCtelera: An Amstrad CPC Game Engine
//  Copyright (C) 2015 ronaldo / Fremos / Cheesetea / ByteRealms (@FranGallegoBR)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public License
//  along with this program.  If not, see <http://www.gnu->org/licenses/>.
//------------------------------------------------------------------------------

#include <cpctelera.h>
#include "characters/ball.h"
#include "maps/tiles.h"
#include "maps/tiles2.h"
#include "maps/marcador.h"
#include "maps/puntos.h"
#include "maps/numbers.h"
#include "maps/gGoal.h"
#include "maps/campo.h"
#include "maps/WinTournament.h"
#include "maps/goal.h"
#include "entities/entities.h"
#include "music/PinguHitsTheIce.h"
#include "music/EpicWin.h"
#include "music/win.h"

#define ANCHO_PANTALLA 80
#define ALTO_PANTALLA 200
#define ORIGEN_MAPA_Y 40 
#define ORIGEN_MAPA cpctm_screenPtr(CPCT_VMEM_START, 0, ORIGEN_MAPA_Y)
#define LIMITE_DERECHO ANCHO_PANTALLA - G_entity_W
#define LIMITE_BAJO ALTO_PANTALLA - G_entity_H

#define cajaMarcadorLocal 0xC850
#define spriteLocal 0xC8A1
#define spriteLocal2 0xC8A4
#define spriteStringLocal 0x0C8A9

#define cajaMarcadorVisit 0xC898
#define spriteVisit 0xC8E9
#define spriteVisit2 0xC8EC
#define spriteStringVisit 0xC8CB

#define SCALE 256

#define spriteRotulo 0xC000
#define spriteRotulo2 0xC028

#define hora 0xC025
#define hora2 0xC029
#define hora3 0xC02C

#define suma 0xF0
#define txt_menu 0xC850
#define ping_menu 0xC88F
#define txt_menu2 0xC940
#define txt_menu3 0xCA30
#define txt_menu4 0xCB20
#define txt_menu5 0xCC10
#define txt_menu6 0xCD00
#define txt_menu7 0xCDF0

#define txt_inst 0xC6E0
#define txt_result 0xE2E0
#define txt_retry 0xC6F0
#define solid_box1 0xD2DE
#define solid_box2 0xF28D

//---credits----
#define txt_credits1 0xC8F0
#define txt_credits3 0xC990
#define txt_credits4 0xC9E0
#define txt_credits5 0xCA48
#define txt_credits6 0xCA80
#define txt_credits7 0xCAD0
#define txt_credits9 0xCBC0
#define txt_credits11 0xCC60
#define txt_credits12 0xCCB0
#define txt_credits14 0xCDA0


cpctm_createTransparentMaskTable (g_tabtrans, 0x0100, M0, 0);	// Tabla de transparencia

const TEntity template_pingu = {
   		g_pingu_2, CPCT_VMEM_START,  													// Sprite and video memory location
      	0, 20, 117, 20, 117, G_PINGU_0_W, G_PINGU_0_H, 1, 40*SCALE,	// id, X, Y, PX, PY, Width and Height (bytes), square pixels to ignore, and kilograms
      	{0, 0, 0, 0, 3*SCALE, 3*SCALE}       													// Velocity values (vx, vy, acum_x,acum_y, max_x, max_y)
};

const TEntity template_enemy = {
   		g_pingu2_6, CPCT_VMEM_START,  													// Sprite and video memory location
      	1, 50, 117, 50, 117, G_PINGU2_0_W, G_PINGU2_0_H, 1, 40*SCALE,	// id, X, Y, PX, PY, Width and Height (bytes), square pixels to ignore, and kilograms
      	{0, 0, 0, 0, 3*SCALE, 3*SCALE}       													// Velocity values (vx, vy, acum_x,acum_y, max_x, max_y)
};

const TEntity template_ball = {
   		g_ball, CPCT_VMEM_START,  													// Sprite and video memory location
      	2, 39, 117, 39, 117, G_BALL_W, G_BALL_H, 1, 5*SCALE,	// id, X, Y, PX, PY, Width and Height (bytes), square pixels to ignore, and kilograms
      	{0, 0, 0, 0, 3*SCALE, 3*SCALE}       													// Velocity values (vx, vy, acum_x,acum_y, max_x, max_y)
};

const u8 menuBola[3 * 12] = {
	0x0c, 0x00, 0x07,
	0x19, 0x55, 0x03,
	0x22, 0xaa, 0x89,
	0x55, 0x55, 0x45,
	0x22, 0xaa, 0x89,
	0x55, 0x55, 0x45,
	0x22, 0xaa, 0x89,
	0x55, 0x55, 0x45,
	0x22, 0xaa, 0x89,
	0x19, 0x55, 0x03,
	0x0c, 0x00, 0x07,
	0x0f, 0x0f, 0x0f
};


u8 goleador; 			// Controlara quien ha marcado el gol.
u8 scoreLocal; 			// Controla los goles locales.
u8 scoreVisit; 			// Controla los goles visitantes.
u16 i; 					// Variable auxiliar para controlar las interrupciones del TIEMPO.
u8 j; 					// Variable axuliar para controlar las interrupciones MUSICALES.
u8 tiempo;				// Controla los segundos. Por defecto 2 MINUTOS.
u8 tiempoMaestro;		// 
i8 ia;					// Controla si jugaremos con la IA o no. Por defecto SI.
i8 iaMaestra;			// 
u8 music;				// Controla si queremos reproducir la música.
u8 musicaMaestro;		// 
u8* menu; 				// Pintara los strings de los menus.
i8 numPartidas; 		// Controlará cuantas partidas se jugarán en el juego. TORNEO = 3, OTHERS = 1;
u8 level; 				// Controla el nivel de la IA. Por defecto 0 (la mas facil).
u8 torneo;				// Controla si estamos jugando un torneo.
u8 Empatetorneo;		// Controla si estamos jugando un torneo.
TEntity pingu; 			// Entidad PINGUINO.
TEntity pingu_enemy;	// Entidad PINGUINO ENEMIGO.
TEntity ball;			// Entidad PELOTA.

const u8 paletaM1[4] = { 0x54, 0x4c, 0x40, 0x4b };
const u8 paletaNegra[16] = { 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54 };
const u8 paletaGrisM1[4] = { 0x40, 0x40, 0x40, 0x40};


extern void play();
extern void stop();
extern u16 cpct_removeInterruptHandler();

void setModo0Paleta()
{
	cpct_setVideoMode(0); // Ponemos el modo de video a 0. 1 byte = 2 pixels.
	cpct_setPalette(g_palette, 16); // Creamos la paleta del juego
}

void setModo1Paleta()
{
	cpct_setVideoMode(1);
	cpct_setPalette(paletaM1, 4);
}


void borrarEntity(TEntity* entity) __z88dk_fastcall
{
	u8 w = entity->width/2 + (entity->px & 1);
	u8 h = entity->height/4 + (entity->py & 3 ? 1 : 0);
	cpct_etm_drawTileBox2x4(entity->px / 2, (entity->py - ORIGEN_MAPA_Y)/4, w , h, g_mapa_W, ORIGEN_MAPA, g_mapa);
}

void dibujarEntity(TEntity* entity) __z88dk_fastcall
{
	//u8* pvmem = cpct_getScreenPtr(CPCT_VMEM_START, entity->x, entity->y);
	cpct_drawSpriteMaskedAlignedTable (entity->sprite, entity->videopos, entity->width, entity->height, g_tabtrans);
}

void wait4Key(cpct_keyID key) __z88dk_fastcall
{
   do
      cpct_scanKeyboard_f();
   while(! cpct_isKeyPressed(key));

   do
      cpct_scanKeyboard_f();
   while(cpct_isKeyPressed(key));
}

u8* pintarNumber(u8 numero) __z88dk_fastcall
{
	switch(numero)
	{
		case 0:  return g_numbers_00;
		case 1:  return g_numbers_01;
		case 2:  return g_numbers_02;
		case 3:  return g_numbers_03;
		case 4:  return g_numbers_04;
		case 5:  return g_numbers_05;
		case 6:  return g_numbers_06;
		case 7:  return g_numbers_07;
		case 8:  return g_numbers_08;
		default: return g_numbers_09;
	}
}

void updateScore(u8 goleador) __z88dk_fastcall
{
	if(goleador==1)
	{
		++scoreLocal;
		cpct_drawSprite(pintarNumber(scoreLocal/10), (void*)spriteLocal, G_NUMBERS_00_W, G_NUMBERS_00_H);
		cpct_drawSprite(pintarNumber(scoreLocal%10), (void*)spriteLocal2, G_NUMBERS_00_W, G_NUMBERS_00_H);
	}
	else
	{
		++scoreVisit;
		cpct_drawSprite (pintarNumber(scoreVisit/10), (void*)spriteVisit, G_NUMBERS_01_W, G_NUMBERS_01_H);
		cpct_drawSprite (pintarNumber(scoreVisit%10), (void*)spriteVisit2, G_NUMBERS_01_W, G_NUMBERS_01_H);
	}

	if(Empatetorneo==1) // Si habia un empate en un torneo.
	{
		tiempo=0;		// Gol de oro.
		Empatetorneo=0;
	}
}

void inicializarCPC()
{
	cpct_disableFirmware(); // Quitamos el Firmware.
	setModo1Paleta();
	cpct_setPalette(paletaGrisM1,4);

	initConstants(0.028*SCALE);
	cpct_memcpy((void*)pingu, (void*)template_pingu, sizeof(TEntity));
	cpct_memcpy((void*)pingu_enemy, (void*)template_enemy, sizeof(TEntity));
	cpct_memcpy((void*)ball, (void*)template_ball, sizeof(TEntity));

	tiempo=tiempoMaestro=120; 	// Ponemos el tiempo por defecto (2 minutos).
	music=musicaMaestro=1;		// Seleccionamos POR DEFECTO si queremos musica (SI).
}

void handlerEnd()
{
	if(++j==3)
	{
		j=0;
		stop();
	}
}

void handlerMusicWin()
{
	if(++i==330)
	{
		cpct_setInterruptHandler(handlerEnd);
		i=0;
	}

	if(++j==3)
	{
		play();
		j=0;
	}
}

void handlerMusica()
{
	if(++j == 6)
	{
		play();
		j = 0;
	}
}

void winRefactor(void* songdata, void* interrupt)
{
	cpct_akp_musicInit(songdata);							// Pones la musica de win.
	stop();													// Paras cualquier tipo de musica.
	j=i=0;													// Ponemos j e i a 0 para controlar la canción de WIN.
	cpct_setInterruptHandler(interrupt);				// Cambiamos el InterrtHandler lo cual cambiara la cancion.
	// cpct_drawSprite (g_mage, (void*)0xCAB4, G_MAGE_W, G_MAGE_H);
}

void looseRefactor()
{
	numPartidas=0;
	if(!torneo && !ia){//perdemos jugando multijugador
		cpct_drawStringM0((void*)"PLAYER 2 WON!", (void*)txt_result, 15, 1);
	}else{
		cpct_drawStringM0((void*)" YOU LOST!", (void*)txt_result, 15, 1);
	}
	stop();
	cpct_removeInterruptHandler();

}

void finalizarPartida()
{
	if(!(torneo && (scoreLocal > scoreVisit) && numPartidas==1)) {
		cpct_drawSolidBox((void*)solid_box1, cpct_px2byteM0(8, 8), 56, 23);//queremos gris
		cpct_drawSolidBox((void*)solid_box2, cpct_px2byteM0(1, 1), 56, 23);//queremos negro
	}

	if(torneo) // Si estamos en modo torneo.
	{
		if(scoreLocal > scoreVisit) // Si hemos ganado.
		{
			if(numPartidas==1) // Si estamos en la ultima partida.
			{
				cpct_drawSpriteMaskedAlignedTable(g_WinTournament, (void*)(solid_box1 - 160*2 + 6), G_WINTOURNAMENT_W, G_WINTOURNAMENT_H, g_tabtrans);

				winRefactor(g_song_epic_win, handlerMusica);
			}
			else//Pintamos los strings de teclas negras y fondo verde
			{
				if(numPartidas==3)
					cpct_drawStringM0((void*)"SEMIFINALS", (void*)txt_result, 15, 1);
				if(numPartidas==2)
					cpct_drawStringM0((void*)"  FINAL", (void*)txt_result, 15, 1);
			}
		}
		if(scoreLocal < scoreVisit) // Si hemos perdido. 
		{
			looseRefactor();
		}

		if(music)
			cpct_setInterruptHandler(handlerMusica);
		else
			cpct_removeInterruptHandler();
	}
	else // Si no estamos en modo torneo.
	{
		if(scoreLocal > scoreVisit) // Si hemos ganado.
		{
			if(ia)
				cpct_drawStringM0((void*)" YOU WON!", (void*)txt_result, 15, 1);
			else
				cpct_drawStringM0((void*)"PLAYER 1 WON!", (void*)txt_result, 15, 1);

			winRefactor(g_song_win, handlerMusicWin);

		}
		else if (scoreLocal < scoreVisit) // Si hemos perdido.
		{
			looseRefactor();
		}
		else // Se ha empatado.
		{
			cpct_drawStringM0((void*)" DRAWN MATCH!", (void*)txt_result, 15, 1);
			stop();
			cpct_removeInterruptHandler();
		}
	}

	// 0xD2DE
	cpct_drawSolidBox((void*)0xD69E, cpct_px2byteM0(8, 8), 56, 23); // AZUL
	cpct_drawSolidBox((void*)0xF64D, cpct_px2byteM0(1, 1), 56, 23); // VERDE
	cpct_drawStringM0((void*)" PRESS SPACE", (void*)txt_retry, 15, 1); // TEXTO

	--numPartidas; 		// Bajaremos una partida (Solo en modo torneo se jugará más de una).
	++level;			// Subiremos el nivel según la partida que juguemos.
	wait4Key(Key_Space);

}

void updateTiempo(u16 tiempo) __z88dk_fastcall
{
	u8 mins = tiempo / 60; // Calculara los minutos.
	u8 segs = tiempo % 60; // Calculara los segundos.
	u8 segsLeft = segs / 10; // Caculara los segundos 
	segs = segs % 10;

	cpct_drawSprite (pintarNumber(mins), (void*)hora, G_NUMBERS_00_W, G_NUMBERS_00_H);
	cpct_drawSprite (pintarNumber(segsLeft), (void*)hora2, G_NUMBERS_00_W, G_NUMBERS_00_H);
	cpct_drawSprite (pintarNumber(segs), (void*)hora3, G_NUMBERS_00_W, G_NUMBERS_00_H);
}

void handlerTiempo()
{
	if(++i == 300 && tiempo!=0) // Hará pasado un segundo.
	{
		i=0;
		updateTiempo(--tiempo);
	}
}

void handlerMusicaTiempo()
{
	handlerMusica();
	handlerTiempo();
}

void esperarNVSYNCs(u8 n) __z88dk_fastcall
{
	do {
      cpct_waitVSYNC();
      __asm__ ("halt");
      __asm__ ("halt");
	} while(--n);
}

void redibujarPinguMenu(u8* pos, u8* anterior)
{
	cpct_drawSolidBox ((void*)anterior, cpct_px2byteM1(2,2,2,2), 6, 12);
	cpct_drawSprite(menuBola, (void*)pos, 3, 12);
}

i8 moverPinguMenu(cpct_keyID key) __z88dk_fastcall
{
	i8 elec=0;
	u8* actual = (void*)ping_menu;
	u8* anterior = (void*)ping_menu;

	cpct_drawSprite(menuBola, (void*) actual, 3, 12);

	do
	{
		cpct_scanKeyboard_f();

		if(cpct_isKeyPressed(Key_CursorUp)) // Moverse hacia arriba.
		{
			if(elec>0)
			{
				--elec;
				anterior = actual;
				actual -= suma;
				redibujarPinguMenu(actual, anterior);

			}
		}
		else if(cpct_isKeyPressed(Key_CursorDown)) // Moverse hacia abajo.
		{
			if(elec<4)
			{
				++elec;
				anterior = actual;
				actual += suma;
				redibujarPinguMenu(actual, anterior);
			}
		}

		esperarNVSYNCs(5);
	}while(!cpct_isKeyPressed(key)); // Mientas no pulsemos la tecla seleccionada.

	return elec;
}

const u8 virgulilla[1 * 8] = {
	0x0f,
	0x0f,
	0x0f,
	0x0f,
	0x0f,
	0x0f,
	0xff,
	0x0f
};

void menuCreditos()
{
	setModo1Paleta();

	cpct_drawSolidBox ((void*)spriteRotulo, cpct_px2byteM1(2,2,2,2), 40, 200);
	cpct_drawSolidBox ((void*)spriteRotulo2, cpct_px2byteM1(2,2,2,2), 40, 200);

	cpct_drawStringM1((void*)"CREDITS", (void*)txt_menu, 0, 2);

	cpct_drawStringM1((void*)"PABLO REQUENA", (void*)txt_credits1, 3, 2);
	cpct_drawStringM1((void*)"GENERAL PROGRAMING AND MANAGEMENT", (void*)txt_menu2, 0, 2);
	cpct_drawStringM1((void*)"MAP AND SPRITE DESING", (void*)txt_credits3, 0, 2);
	cpct_drawStringM1((void*)"INTERFACE AND MECHANICS", (void*)txt_credits4, 0, 2);

	cpct_drawSprite(virgulilla, (void*)txt_credits5, 1, 8);

	cpct_drawStringM1((void*)"MARISA RISUENO", (void*)txt_credits6, 3, 2);
	cpct_drawStringM1((void*)"GENERAL PROGRAMING AND MANAGEMENT", (void*)txt_credits7, 0, 2);
	cpct_drawStringM1((void*)"ARTIFICIAL INTELLIGENCE", (void*)txt_menu4, 0, 2);

	cpct_drawStringM1((void*)"MARCOS GONZALEZ", (void*)txt_credits9, 3, 2);
	cpct_drawStringM1((void*)"ORIGINAL SOUNDTRACK", (void*)txt_menu5, 0, 2);
	cpct_drawStringM1((void*)"GENERAL PROGRAMING AND MANAGEMENT", (void*)txt_credits11, 0, 2);
	cpct_drawStringM1((void*)"SPRITE DESING", (void*)txt_credits12, 0, 2);
	cpct_drawStringM1((void*)"PHYSICS", (void*)txt_menu6, 0, 2);

	cpct_drawStringM1((void*)"HECTOR MOLINA", (void*)txt_credits14, 3, 2);
	cpct_drawStringM1((void*)"THX 4 THAT AMAZING LOADER SCREEN SPRITE", (void*)txt_menu7, 0, 2);

	cpct_drawStringM1((void*)"     \r RETURN", (void*)txt_inst, 0, 2);

	wait4Key(Key_Return);
}

void menuOpciones(cpct_keyID key)
{
	setModo1Paleta();

	cpct_drawSolidBox ((void*)spriteRotulo, cpct_px2byteM1(2,2,2,2), 40, 200);
	cpct_drawSolidBox ((void*)spriteRotulo2, cpct_px2byteM1(2,2,2,2), 40, 200);

	cpct_drawStringM1((void*)"1. 1 MINUTE", (void*)txt_menu, 0, 2);					// Imprime PRACTICE
	cpct_drawStringM1((void*)"2. 2 MINUTES", (void*)txt_menu2, 0, 2);				// Imprime TOURNAMENT
	cpct_drawStringM1((void*)"3. IA'S LEVEL 1", (void*)txt_menu3, 0, 2);			// Imprime MULTIPLAYER
	cpct_drawStringM1((void*)"4. IA'S LEVEL 2", (void*)txt_menu4, 0, 2);			// Imprime OPCIONES
	cpct_drawStringM1((void*)"5. IA'S LEVEL 3", (void*)txt_menu5, 0, 2);			// Imprime OPCIONES
	cpct_drawStringM1((void*)"6. MUSIC ON", (void*)txt_menu6, 0, 2);				// Imprime OPCIONES
	cpct_drawStringM1((void*)"7. MUSIC OFF", (void*)txt_menu7, 0, 2);				// Imprime OPCIONES
	cpct_drawStringM1((void*)"1-7 SELECT      \r RETURN", (void*)txt_inst, 0, 2);		// Imprime AYUDA

	do
	{
		cpct_scanKeyboard_f();

		if(cpct_isKeyPressed(Key_1))
			tiempo = 60;
		else if(cpct_isKeyPressed(Key_2))
			tiempo = 120;
		else if(cpct_isKeyPressed(Key_3))
			level = 0;
		else if(cpct_isKeyPressed(Key_4))
			level = 2;
		else if(cpct_isKeyPressed(Key_5))
			level = 3;
		else if(cpct_isKeyPressed(Key_6))
			music = 1;
		else if(cpct_isKeyPressed(Key_7))
			music = 0;
		else if(cpct_isKeyPressed(Key_P)) // Desactiva la IA, solo para programadores.
			iaMaestra=1;
	}while(!cpct_isKeyPressed(key)); // Mientas no pulsemos la tecla seleccionada.
}

void menuPrincipal()
{
	i8 dumpy; 		// Creamos la variable para controlar la opcion.
	cpct_setBorder(HW_WHITE); // El fondo a negro.
	cpct_clearScreen(cpct_px2byteM1(2,2,2,2));

	stop();
	cpct_removeInterruptHandler();
	tiempo = tiempoMaestro;
	music = musicaMaestro;
	ia=1; 						// Seleccionamos si jugamos o no contra la IA por defecto (SI);
	level=0;					// Ponemos el nivel por defecto (0 -> Menos listo).
	numPartidas=1;				// Ponemos el numero de partidas por defecto (1)
	torneo=0;					// Ponemos que por defecto NO se juega un torneo.

	setModo1Paleta();

	cpct_etm_setTileset2x4(g_tileset); // Creamos el tileset (para el mapa).

	do
	{
		cpct_clearScreen(cpct_px2byteM1(2,2,2,2));
		/*cpct_drawSolidBox ((void*)spriteRotulo, cpct_px2byteM0(8,8), 40, 200);
		cpct_drawSolidBox ((void*)spriteRotulo2, cpct_px2byteM0(8,8), 40, 200);*/

		cpct_drawStringM1((void*)"PRACTICE", (void*)txt_menu, 0, 2);				// Imprime PRACTICE
		cpct_drawStringM1((void*)"TOURNAMENT", (void*)txt_menu2, 0, 2);				// Imprime TOURNAMENT
		cpct_drawStringM1((void*)"MULTIPLAYER", (void*)txt_menu3, 0, 2);			// Imprime MULTIPLAYER
		cpct_drawStringM1((void*)"OPTIONS", (void*)txt_menu4, 0, 2);				// Imprime OPCIONES
		cpct_drawStringM1((void*)"CREDITS", (void*)txt_menu5, 0, 2);				// Imprime OPCIONES
		cpct_drawStringM1((void*)"\n \v MOVE   \r SELECT", (void*)txt_inst, 0, 2);	// Imprime AYUDA

		dumpy=moverPinguMenu(Key_Return); // Elegir entre las opciones.

		if(dumpy==1) // MODO TORNEO
		{
			numPartidas=3;
			torneo = 1;
		}
		else if (dumpy==2)	// MODO PVP
		{
			cpct_etm_setTileset2x4(g_tileset2); // Creamos el tileset (para el mapa).
			ia = 0;
		}
		else if(dumpy==3) // MODO OPCIONES
			menuOpciones(Key_Return);
		else if(dumpy==4)
			menuCreditos();

	}while(dumpy>2);

	tiempoMaestro=tiempo; // Nos guardamos cuanto tiempo quiere jugar el jugador.
	musicaMaestro=music;

	if(iaMaestra) ia=0;


	setModo0Paleta();
	cpct_setBorder(HW_BLACK);
	cpct_setPalette(paletaNegra,16);

}

void printMap() {
	cpct_etm_drawTilemap2x4(g_mapa_W, g_mapa_H, ORIGEN_MAPA, g_mapa); // Dibujamos el mapa
}

void prePartida()
{

	scoreLocal = 0; // Pone el Score Local a 0.
	scoreVisit = 0; // Pone el Score Visitante a 0.
	tiempo = tiempoMaestro; // Igualamos el tiempo de la partida, a la de las opciones.

	// Dibujamos el Rotulo (Marcadores/Local/Visitante)
	cpct_drawSolidBox ((void*)spriteRotulo, 0xc0, 42, 40);
	cpct_drawSolidBox ((void*)spriteRotulo2, 0xc0, 42, 40);

	printMap();

	// Dibuajmos los marcadores iniciales 00 - 00.
	// Local
	cpct_drawSprite (g_marcador, (void*)cajaMarcadorLocal, G_MARCADOR_W, G_MARCADOR_H);
	cpct_drawSprite (g_numbers_00, (void*)spriteLocal, G_NUMBERS_00_W, G_NUMBERS_00_H);
	cpct_drawSprite (g_numbers_00, (void*)spriteLocal2, G_NUMBERS_00_W, G_NUMBERS_00_H);
	cpct_drawStringM0((void*)"HOME", (void*)spriteStringLocal, 10, 1);

	// Visitante
	cpct_drawSprite (g_marcador, (void*)cajaMarcadorVisit, G_MARCADOR_W, G_MARCADOR_H);
	cpct_drawSprite (g_numbers_00, (void*)spriteVisit, G_NUMBERS_00_W, G_NUMBERS_00_H);
	cpct_drawSprite (g_numbers_00, (void*)spriteVisit2, G_NUMBERS_00_W, G_NUMBERS_00_H);
	cpct_drawStringM0((void*)"VISITOR", (void*)spriteStringVisit, 10, 1);

	cpct_drawSprite (g_puntos, (void*)(hora2-0x01), G_PUNTOS_W, G_PUNTOS_H);	

	// cpct_drawSprite (g_soldier, (void*)0xCA2A, G_SOLDIER_W, G_SOLDIER_H);
	cpct_setPalette(g_palette,16);
	updateTiempo(tiempo); // Dibujamos el reloj
	initFuzzy(level);
}

void inicioEnt(TEntity* ent) __z88dk_fastcall
{
	
	borrarEntity(ent);

	switch(ent->id)
	{
		case 0: {cpct_memcpy((void*)ent, (void*)template_pingu, sizeof(TEntity)); break;}
		case 1: {cpct_memcpy((void*)ent, (void*)template_enemy, sizeof(TEntity)); break;}
		case 2: {cpct_memcpy((void*)ent, (void*)template_ball, sizeof(TEntity)); break;}
	}

	updateEntityVideopos(ent);
	dibujarEntity(ent);
}

void posInitEntities()
{
	inicioEnt(&pingu);
	inicioEnt(&pingu_enemy);
	inicioEnt(&ball);
}

void printGoal() {
	cpct_drawSprite(g_goal, (void*)(solid_box1 + 8), G_GOAL_W, G_GOAL_H);
	//while(--count) {};
	esperarNVSYNCs(50);
}

void updatePrePos(TEntity *ent) {
	ent->px = ent->x;
	ent->py = ent->y;
}

void redibujarEntities() {
	cpct_waitVSYNC();

	borrarEntity(&pingu);
	borrarEntity(&pingu_enemy);
	borrarEntity(&ball);


	dibujarEntity(&ball);
	dibujarEntity(&pingu);
	dibujarEntity(&pingu_enemy);

	updatePrePos(&pingu);
	updatePrePos(&pingu_enemy);
	updatePrePos(&ball);
}

void main(void)
{
   	inicializarCPC();
   	
   	while(1)
   	{
   		//cpct_clearScreen(0);
   		menuPrincipal();
   		music = musicaMaestro; // Igualamos el tiempo de la partida, a la de las opciones.

		if(music) // Si queremos musica.
		{
			cpct_akp_musicInit(g_song_prin); // Asignamos la cancion para que suene en la partida.
			cpct_setInterruptHandler(handlerMusicaTiempo); // Llamaremos a las interrupciones con Musica y tiempo.
		}
		else // Si no.
			cpct_setInterruptHandler(handlerTiempo); // Solo a las interrupcuines con tiempo.
	
   		while(numPartidas>0)
	   	{
	   		if(torneo)
	   		{
				if(music) // Si queremos musica.
					cpct_setInterruptHandler(handlerMusicaTiempo); // Llamaremos a las interrupciones con Musica y tiempo.
				else // Si no.
					cpct_setInterruptHandler(handlerTiempo); // Solo a las interrupcuines con tiempo.
			}

	   		prePartida();
			posInitEntities();
			esperarNVSYNCs(50);
// tiempo=1;
// scoreVisit=100;
// numPartidas=1;
		   	while(tiempo>0) // Mientras el tiempo no llegue a cero, se jugará.
		   	{
		   		goleador=0;
		   		goleador=updateEntities(&pingu, &pingu_enemy, &ball, ia);

				// redibujarEntity(&ball);
				// redibujarEntity(&pingu_enemy);
				// redibujarEntity(&pingu);
		   		redibujarEntities();
				if(goleador>0)
				{
					updateScore(goleador);
					printGoal(); 			// Imprimir sprite de gol.
					printMap();
					posInitEntities();
				}

				if(torneo==1 && tiempo==0 && scoreLocal==scoreVisit) // Si estamos en un torneo, no se puede empatar.
				{
					cpct_drawSprite(g_gGoal, (void*)hora, G_GGOAL_W, G_GGOAL_H);
					if(music)
						cpct_setInterruptHandler(handlerMusica);
					else
						cpct_removeInterruptHandler();

					Empatetorneo=1;
					tiempo=60;
				}
		  	}

		  	finalizarPartida();	// Mostraremos el modulo de salida "GANAR, PERDER ETC...".
		}
		setModo1Paleta();
		cpct_setPalette(paletaGrisM1,4);
  	}
}