/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.windows;

import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import sun.awt.Win32GraphicsConfig;
import sun.awt.Win32GraphicsDevice;
import sun.awt.windows.WComponentPeer;
import sun.java2d.InvalidPipeException;
import sun.java2d.ScreenUpdateManager;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.SurfaceDataProxy;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.RenderLoops;
import sun.java2d.loops.SurfaceType;
import sun.java2d.loops.XORComposite;
import sun.java2d.pipe.PixelToShapeConverter;
import sun.java2d.pipe.Region;
import sun.java2d.windows.GDIBlitLoops;
import sun.java2d.windows.GDIRenderer;
import sun.java2d.windows.WindowsFlags;

public class GDIWindowSurfaceData
extends SurfaceData {
    private WComponentPeer peer;
    private Win32GraphicsConfig graphicsConfig;
    private RenderLoops solidloops;
    public static final String DESC_GDI = "GDI";
    public static final SurfaceType AnyGdi = SurfaceType.IntRgb.deriveSubType("GDI");
    public static final SurfaceType IntRgbGdi = SurfaceType.IntRgb.deriveSubType("GDI");
    public static final SurfaceType Ushort565RgbGdi = SurfaceType.Ushort565Rgb.deriveSubType("GDI");
    public static final SurfaceType Ushort555RgbGdi = SurfaceType.Ushort555Rgb.deriveSubType("GDI");
    public static final SurfaceType ThreeByteBgrGdi = SurfaceType.ThreeByteBgr.deriveSubType("GDI");
    protected static GDIRenderer gdiPipe;
    protected static PixelToShapeConverter gdiTxPipe;

    private static native void initIDs(Class var0);

    public static SurfaceType getSurfaceType(ColorModel colorModel) {
        switch (colorModel.getPixelSize()) {
            case 24: 
            case 32: {
                if (colorModel instanceof DirectColorModel) {
                    if (((DirectColorModel)colorModel).getRedMask() == 0xFF0000) {
                        return IntRgbGdi;
                    }
                    return SurfaceType.IntRgbx;
                }
                return ThreeByteBgrGdi;
            }
            case 15: {
                return Ushort555RgbGdi;
            }
            case 16: {
                if (colorModel instanceof DirectColorModel && ((DirectColorModel)colorModel).getBlueMask() == 62) {
                    return SurfaceType.Ushort555Rgbx;
                }
                return Ushort565RgbGdi;
            }
            case 8: {
                if (colorModel.getColorSpace().getType() == 6 && colorModel instanceof ComponentColorModel) {
                    return SurfaceType.ByteGray;
                }
                if (colorModel instanceof IndexColorModel && GDIWindowSurfaceData.isOpaqueGray((IndexColorModel)colorModel)) {
                    return SurfaceType.Index8Gray;
                }
                return SurfaceType.ByteIndexedOpaque;
            }
        }
        throw new InvalidPipeException("Unsupported bit depth: " + colorModel.getPixelSize());
    }

    public static GDIWindowSurfaceData createData(WComponentPeer wComponentPeer) {
        SurfaceType surfaceType = GDIWindowSurfaceData.getSurfaceType(wComponentPeer.getDeviceColorModel());
        return new GDIWindowSurfaceData(wComponentPeer, surfaceType);
    }

    @Override
    public SurfaceDataProxy makeProxyFor(SurfaceData surfaceData) {
        return SurfaceDataProxy.UNCACHED;
    }

    @Override
    public Raster getRaster(int n, int n2, int n3, int n4) {
        throw new InternalError("not implemented yet");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void validatePipe(SunGraphics2D sunGraphics2D) {
        block17: {
            block18: {
                if (sunGraphics2D.antialiasHint == 2) break block17;
                if (sunGraphics2D.paintState > 1) break block17;
                if (sunGraphics2D.compositeState <= 0) break block18;
                if (sunGraphics2D.compositeState != 2) break block17;
            }
            if (sunGraphics2D.clipState == 2) {
                super.validatePipe(sunGraphics2D);
            } else {
                block0 : switch (sunGraphics2D.textAntialiasHint) {
                    case 0: 
                    case 1: {
                        sunGraphics2D.textpipe = solidTextRenderer;
                        break;
                    }
                    case 2: {
                        sunGraphics2D.textpipe = aaTextRenderer;
                        break;
                    }
                    default: {
                        switch (sunGraphics2D.getFontInfo().aaHint) {
                            case 4: 
                            case 6: {
                                sunGraphics2D.textpipe = lcdTextRenderer;
                                break block0;
                            }
                            case 2: {
                                sunGraphics2D.textpipe = aaTextRenderer;
                                break block0;
                            }
                        }
                        sunGraphics2D.textpipe = solidTextRenderer;
                    }
                }
            }
            sunGraphics2D.imagepipe = imagepipe;
            if (sunGraphics2D.transformState >= 3) {
                sunGraphics2D.drawpipe = gdiTxPipe;
                sunGraphics2D.fillpipe = gdiTxPipe;
            } else if (sunGraphics2D.strokeState != 0) {
                sunGraphics2D.drawpipe = gdiTxPipe;
                sunGraphics2D.fillpipe = gdiPipe;
            } else {
                sunGraphics2D.drawpipe = gdiPipe;
                sunGraphics2D.fillpipe = gdiPipe;
            }
            sunGraphics2D.shapepipe = gdiPipe;
            if (sunGraphics2D.loops != null) return;
            sunGraphics2D.loops = this.getRenderLoops(sunGraphics2D);
            return;
        }
        super.validatePipe(sunGraphics2D);
    }

    @Override
    public RenderLoops getRenderLoops(SunGraphics2D sunGraphics2D) {
        if (sunGraphics2D.paintState <= 1) {
            if (sunGraphics2D.compositeState <= 0) {
                return this.solidloops;
            }
        }
        return super.getRenderLoops(sunGraphics2D);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphicsConfig;
    }

    private native void initOps(WComponentPeer var1, int var2, int var3, int var4, int var5, int var6);

    private GDIWindowSurfaceData(WComponentPeer wComponentPeer, SurfaceType surfaceType) {
        super(surfaceType, wComponentPeer.getDeviceColorModel());
        Object object;
        int n;
        ColorModel colorModel = wComponentPeer.getDeviceColorModel();
        this.peer = wComponentPeer;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        switch (colorModel.getPixelSize()) {
            case 24: 
            case 32: {
                if (colorModel instanceof DirectColorModel) {
                    n = 32;
                    break;
                }
                n = 24;
                break;
            }
            default: {
                n = colorModel.getPixelSize();
            }
        }
        if (colorModel instanceof DirectColorModel) {
            object = (DirectColorModel)colorModel;
            n2 = ((DirectColorModel)object).getRedMask();
            n3 = ((DirectColorModel)object).getGreenMask();
            n4 = ((DirectColorModel)object).getBlueMask();
        }
        this.graphicsConfig = (Win32GraphicsConfig)wComponentPeer.getGraphicsConfiguration();
        this.solidloops = this.graphicsConfig.getSolidLoops(surfaceType);
        object = (Win32GraphicsDevice)this.graphicsConfig.getDevice();
        this.initOps(wComponentPeer, n, n2, n3, n4, ((Win32GraphicsDevice)object).getScreen());
        this.setBlitProxyKey(this.graphicsConfig.getProxyKey());
    }

    @Override
    public SurfaceData getReplacement() {
        ScreenUpdateManager screenUpdateManager = ScreenUpdateManager.getInstance();
        return screenUpdateManager.getReplacementScreenSurface(this.peer, this);
    }

    @Override
    public Rectangle getBounds() {
        Rectangle rectangle = this.peer.getBounds();
        rectangle.y = 0;
        rectangle.x = 0;
        return rectangle;
    }

    @Override
    public boolean copyArea(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        CompositeType compositeType = sunGraphics2D.imageComp;
        if (sunGraphics2D.transformState < 3) {
            if (sunGraphics2D.clipState != 2 && (CompositeType.SrcOverNoEa.equals(compositeType) || CompositeType.SrcNoEa.equals(compositeType))) {
                int n7 = (n += sunGraphics2D.transX) + n5;
                int n8 = (n2 += sunGraphics2D.transY) + n6;
                int n9 = n7 + n3;
                int n10 = n8 + n4;
                Region region = sunGraphics2D.getCompClip();
                if (n7 < region.getLoX()) {
                    n7 = region.getLoX();
                }
                if (n8 < region.getLoY()) {
                    n8 = region.getLoY();
                }
                if (n9 > region.getHiX()) {
                    n9 = region.getHiX();
                }
                if (n10 > region.getHiY()) {
                    n10 = region.getHiY();
                }
                if (n7 < n9 && n8 < n10) {
                    gdiPipe.devCopyArea(this, n7 - n5, n8 - n6, n5, n6, n9 - n7, n10 - n8);
                }
                return true;
            }
        }
        return false;
    }

    private native void invalidateSD();

    @Override
    public void invalidate() {
        if (this.isValid()) {
            this.invalidateSD();
            super.invalidate();
        }
    }

    @Override
    public Object getDestination() {
        return this.peer.getTarget();
    }

    public WComponentPeer getPeer() {
        return this.peer;
    }

    static {
        GDIWindowSurfaceData.initIDs(XORComposite.class);
        if (WindowsFlags.isGdiBlitEnabled()) {
            GDIBlitLoops.register();
        }
        gdiPipe = new GDIRenderer();
        if (GraphicsPrimitive.tracingEnabled()) {
            gdiPipe = gdiPipe.traceWrap();
        }
        gdiTxPipe = new PixelToShapeConverter(gdiPipe);
    }
}

