//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDc3c27902_a399_4dca_a530_26b07de94a98
{
    public class Class_BrokenTV : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            DisplaceMap = 2,
            DisplaceX = 3,
            DisplaceY = 4,
            OffsetX = 5,
            OffsetY = 6,
            Desaturation = 7,
            RGBSplitAmount = 8,
            Brightness = 9,
            Contrast = 10,
            Noise = 11,
            Time = 12,
            NoiseScaleX = 13,
            NoiseScaleY = 14,
            RollDisplacementX = 15,
            RollDisplacementY = 16,
            HorizontalSliceWidth = 17,
            HorizontalSlicePosition = 18,
            VerticalSliceSize = 19,
            VerticalSlicePosition = 20,
            NoiseTexture = 21,
            OverallAmount = 22
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {

            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
            var DisplaceMap = inputs[(int)InputId.DisplaceMap].Eval(context).Image; // Needs to be checked for null!
            var DisplaceX = inputs[(int)InputId.DisplaceX].Eval(context).Value;
            var DisplaceY = inputs[(int)InputId.DisplaceY].Eval(context).Value;
            var Displace = new Vector2(DisplaceX, DisplaceY);
            var OffsetX = inputs[(int)InputId.OffsetX].Eval(context).Value;
            var OffsetY = inputs[(int)InputId.OffsetY].Eval(context).Value;
            var Offset = new Vector2(OffsetX, OffsetY);
            var Desaturation = inputs[(int)InputId.Desaturation].Eval(context).Value;
            var RGBSplitAmount = inputs[(int)InputId.RGBSplitAmount].Eval(context).Value;
            var Brightness = inputs[(int)InputId.Brightness].Eval(context).Value;
            var Contrast = inputs[(int)InputId.Contrast].Eval(context).Value;
            var Noise = inputs[(int)InputId.Noise].Eval(context).Value;
            var Time = inputs[(int)InputId.Time].Eval(context).Value;
            var NoiseScaleX = inputs[(int)InputId.NoiseScaleX].Eval(context).Value;
            var NoiseScaleY = inputs[(int)InputId.NoiseScaleY].Eval(context).Value;
            var NoiseScale = new Vector2(NoiseScaleX, NoiseScaleY);
            var RollDisplacementX = inputs[(int)InputId.RollDisplacementX].Eval(context).Value;
            var RollDisplacementY = inputs[(int)InputId.RollDisplacementY].Eval(context).Value;
            var RollDisplacement = new Vector2(RollDisplacementX, RollDisplacementY);
            var HorizontalSliceWidth = inputs[(int)InputId.HorizontalSliceWidth].Eval(context).Value;
            var HorizontalSlicePosition = inputs[(int)InputId.HorizontalSlicePosition].Eval(context).Value;
            var HorizontalSlice = new Vector2(HorizontalSliceWidth, HorizontalSlicePosition);
            var VerticalSliceSize = inputs[(int)InputId.VerticalSliceSize].Eval(context).Value;
            var VerticalSlicePosition = inputs[(int)InputId.VerticalSlicePosition].Eval(context).Value;
            var VerticalSlice = new Vector2(VerticalSliceSize, VerticalSlicePosition);
            var NoiseTexture = inputs[(int)InputId.NoiseTexture].Eval(context).Image; // Needs to be checked for null!
            var OverallAmount = inputs[(int)InputId.OverallAmount].Eval(context).Value;
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));
                
                DisplaceX = Utilities.Lerp(0, DisplaceX, OverallAmount);
                DisplaceY = Utilities.Lerp(0, DisplaceY, OverallAmount);
                
                Noise = Utilities.Lerp(0, Noise, OverallAmount);
                Desaturation = Utilities.Lerp(0, Desaturation, OverallAmount);
                Brightness = Utilities.Lerp(0, Brightness, OverallAmount);
                Contrast = Utilities.Lerp(0, Contrast, OverallAmount);
                RGBSplitAmount  = Utilities.Lerp(0, RGBSplitAmount, OverallAmount);

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                using (var DisplaceMapView = new ShaderResourceView(context.D3DDevice, DisplaceMap))
                using (var NoiseTextureView = new ShaderResourceView(context.D3DDevice, NoiseTexture))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("DisplaceMap").AsShaderResource().SetResource(DisplaceMapView);
                    _effect.GetVariableByName("Displace").AsVector().Set(new Vector2(DisplaceX, DisplaceY));
                    _effect.GetVariableByName("Offset").AsVector().Set(new Vector2(OffsetX, OffsetY));
                    _effect.GetVariableByName("Desaturation").AsScalar().Set(Desaturation);
                    _effect.GetVariableByName("RGBSplitAmount").AsScalar().Set(RGBSplitAmount);
                    _effect.GetVariableByName("Brightness").AsScalar().Set(Brightness);
                    _effect.GetVariableByName("Contrast").AsScalar().Set(Contrast);
                    _effect.GetVariableByName("Noise").AsScalar().Set(Noise);
                    _effect.GetVariableByName("Time").AsScalar().Set(Time);
                    _effect.GetVariableByName("NoiseScale").AsVector().Set(new Vector2(NoiseScaleX, NoiseScaleY));
                    _effect.GetVariableByName("RollDisplacement").AsVector().Set(new Vector2(RollDisplacementX, RollDisplacementY));
                    _effect.GetVariableByName("HorizontalSlice").AsVector().Set(new Vector2(HorizontalSliceWidth, HorizontalSlicePosition));
                    _effect.GetVariableByName("VerticalSlice").AsVector().Set(new Vector2(VerticalSliceSize, VerticalSlicePosition));
                    _effect.GetVariableByName("NoiseTexture").AsShaderResource().SetResource(NoiseTextureView);
                    _effect.GetVariableByName("OverallAmount").AsScalar().Set(OverallAmount);
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

