//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Serialization;
using System.IO;

namespace Framefield.Core.ID46bdd8a1_d8b6_46d1_b5e4_ff24188946d7
{
    public class Class_ContextToString : OperatorPart.Function, Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        //>>> _inputids
        private enum InputId
        {
            Input = 0,
            Filter = 1
        }
        //<<< _inputids
        
        //>>> _outputids
        private enum OutputId
        {
            Output = 0,
            String = 1
        }
        //<<< _outputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Input = inputs[(int)InputId.Input];
            var Filter = inputs[(int)InputId.Filter].Eval(context).Text;
            //<<< _params

            var pattern = String.Empty;
            foreach (var e in Filter)
                pattern += e + ".*";

            switch (outputIdx)
            {
                case (int)OutputId.Output:
                {
                    using (var stringWriter = new StringWriter())
                    using (var jsonTextWriter = new JsonTextWriter(stringWriter)
                                                    {
                                                        QuoteName = false,
                                                        Formatting = Formatting.Indented
                                                    })
                    {
                        _serializer.ContractResolver = new CustomContractResolver(pattern);
                        _serializer.Serialize(jsonTextWriter, context.Variables);
                        _serializer.Serialize(jsonTextWriter, context.Objects);

                        _valueString = "context:\n";
                        foreach (var line in stringWriter.ToString().Split('\n'))
                        {
                            if (Regex.Match(line, pattern, RegexOptions.IgnoreCase) != Match.Empty)
                                _valueString += line;
                        }
                    }

                    Input.Eval(context);

                    OperatorPart.EmitChangedEventForOutput((int)OutputId.String);
                    break;
                }
                case (int)OutputId.String:
                {
                    context.Text = _valueString;
                    break;
                }
            }

            return context;
        }

        public class CustomContractResolver : DefaultContractResolver
        {
            public CustomContractResolver(string pattern)
            {
                _pattern = pattern;
            }

            protected override IList<JsonProperty> CreateProperties(Type type, MemberSerialization memberSerialization)
            {
                IList<JsonProperty> properties = base.CreateProperties(type, memberSerialization);
                return properties.Where(p => Regex.Match(p.PropertyName, _pattern, RegexOptions.IgnoreCase) != Match.Empty).ToList();
            }

            string _pattern;
        }

        string _valueString;
        JsonSerializer _serializer = new JsonSerializer();
    }
}

