//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID78ac0e2c_cd3f_485e_95fa_8e3a2e719060
{
    public class Class_GradientBlur : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            Angle = 2,
            Position = 3,
            Size = 4,
            Strength = 5,
            SampleCount = 6
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {

            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; if (Image == null) return context;
            var Angle = inputs[(int)InputId.Angle].Eval(context).Value;
            var Position = inputs[(int)InputId.Position].Eval(context).Value;
            var Size = inputs[(int)InputId.Size].Eval(context).Value;
            var Strength = inputs[(int)InputId.Strength].Eval(context).Value;
            var SampleCount = inputs[(int)InputId.SampleCount].Eval(context).Value;
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 1));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("Angle").AsScalar().Set(Angle);
                    _effect.GetVariableByName("Position").AsScalar().Set(Position);
                    _effect.GetVariableByName("Size").AsScalar().Set(Size);
                    _effect.GetVariableByName("Strength").AsScalar().Set(Strength);
                    _effect.GetVariableByName("SampleCount").AsScalar().Set(SampleCount);
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

