//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using System.ComponentModel;
using Framefield.Core;
using System.IO;
using Un4seen.Bass;
using System.Windows.Forms;
using Framefield.Core.Inputs;

namespace Framefield.Core.ID6fc49842_5352_422a_967f_9d9b6e09255f
{

    
    public static class MainScenes
    {
        static public int
            OFF=0,
            INTRO=1,
            BACKGROUND=2;
    }

    public class Nominee
    {
        public Nominee() {
            if(Width == 0) Width= 1280;
            if(Height == 0) Height = 720;
        }
        public string Name { get; set; }
        public string Group { get; set; }
        public string FileName { get; set; } /* .mp4, *.mp3, *.wav   */
        public float ExtractStart { get; set; }
        public int Height {get; set;}
        public int Width {get; set;}
    }

    public class Category
    {
        public string Name { get; set; }
        public string FileName { get; set; }
        public List<Nominee> Nominees { get; set; }
        public string Description {get;set;}
        public int Winner { get; set; }
    }

    public class Class_SOAStateMachine : OperatorPart.Function, Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        //>>> _inputids
        private enum InputId
        {
            Input = 0,
            Index = 1,
            CategoriesCSV = 2
        }
        //<<< _inputids

        static public bool InvalidData { get; set; }
    
        static public List<Category> CategoriesAndNominees = new List<Category> {
            new Category(){ Name = "Breakthrough Performance", FileName="BreakthruPerformance", Winner=4,
                Description="A person or group who raised their personal bar significantly during the year. This can be a newcomer group or someone receiving deserved attention after rising above mediocrity.",
            Nominees= new List<Nominee> {
                new Nominee() { Name="Base Case",    Group="Live!", FileName="base-case-by-live", Width= 800, Height=544, ExtractStart=5 },
                new Nominee() { Name="Batman Forever",    Group="Batman Group", FileName="batman-forever-by-batman-group" , Width= 1024, Height=720},
                new Nominee() { Name="Confetti",    Group="Nonoil & Brainstorm", FileName="confetti-by-nonoil-and-brainstorm", ExtractStart=72},
                new Nominee() { Name="Exodus",    Group="#cubernicus", FileName="exodus-by-cubernicus", Width= 640, Height=480, ExtractStart=121 },
                new Nominee() { Name="MGC 2011 Demo",    Group="Retroactive", FileName="mgc-by-retroactive", Width= 640, Height=334, ExtractStart=123},
                new Nominee() { Name="Calyx",    Group="Penumbra", FileName="calyx-by-penumbra", ExtractStart=121 },
            }},
        
            new Category(){ Name = "Most Original Concept", FileName="MostOriginalConcept", Winner=0,
                Description="Most original work in the context of the demoscene. New ideas, innovative use of technology or a new approach in direction or overall style. Can include experimental works or doing simply the unexpected.",
            Nominees= new List<Nominee> {
                new Nominee() { Name="Beta",    Group="Still", FileName="beta-by-still", ExtractStart=35},
                new Nominee() { Name="Earworm",    Group="JCO & Neuro", FileName="earworm-by-jco", ExtractStart=15},
                new Nominee() { Name="Haxholm",    Group="Loonies & Brainstorm", FileName="haxholm-by-loonies-and-brainstorm", ExtractStart=128},
                new Nominee() { Name="Spheres on a Plane",    Group="Dead Roman", FileName="sphere-on-a-plane-by-dead-roman", ExtractStart=188},
                new Nominee() { Name="You Are Lucy",    Group="Spaceballs", FileName="you-are-lucy-by-spaceballs", Width= 640, Height=383, ExtractStart=121},
                new Nominee() { Name="D - Four",    Group="Ctrl-Alt-Test", FileName="d-four-by-ctrl-alt-test", ExtractStart=76},
            }},
            new Category(){ Name = "Best Technical Achievement", FileName="BestTechnicalAchievement", Winner=0,
                Description="Most technically advanced or impressive work. This could be cramming lots of stuff into a really small space, doing crazy things on crazy platforms, or having complex and impressive rendering techniques in a demo.",
            Nominees= new List<Nominee> {
                new Nominee() { Name="Batman Forever",    Group="Batman Group", FileName="batman-forever-by-batman-group", Width= 1024, Height=720, ExtractStart=360},
                new Nominee() { Name="Code Is My Pron",    Group="Nuance", FileName="code-is-my-pron-by-nuance", ExtractStart=70},
                new Nominee() { Name="Numb Res",    Group="CNCD & Fairlight", FileName="numb-res-by-fairlight", ExtractStart=213},
                new Nominee() { Name="Prince of Persia C64",    Group="Mr. SID", FileName="prince-of-persia-by-mr-sid", Width= 480, Height=340},
                new Nominee() { Name="Uncovering Static",    Group="Fairlight & Alcatraz", FileName="uncovering-static-by-fairlight", ExtractStart=35},
                new Nominee() { Name="Just Dance 64",    Group="Algotech", FileName="just-dance-by-algotech", Width= 640, Height=480, ExtractStart=92},
            }},
        
            new Category(){ Name = "Best Effects", FileName="BestEffects", Winner=1, 
                Description="The most innovative use of new effects, pushing the boundaries of existing effects or making something amazing within the context of realtime graphics. Effects can be technically advanced rendering or simply a novel visual expression.",
            Nominees= new List<Nominee> {
                new Nominee() { Name="DUBrovnik",    Group="Gammel Opland af 1891", FileName="dubrovnik-by-gammel-opland", ExtractStart=72},
                new Nominee() { Name="Numb Res",    Group="CNCD & Fairlight", FileName="numb-res-by-fairlight", ExtractStart=214},
                new Nominee() { Name="Shake off the Dust",    Group="Elude", FileName="shake-off-the-dust-by-elude", ExtractStart=225},
                new Nominee() { Name="Spin",    Group="Andromeda Software Development", FileName="spin-by-asd", ExtractStart=165},
                new Nominee() { Name="Uncovering Static",    Group="Fairlight & Alcatraz", FileName="uncovering-static-by-fairlight", ExtractStart=228},
                new Nominee() { Name="Fermion",    Group="Kewlers", FileName="fermion-by-kewlers", ExtractStart=192},
            }},

            new Category(){ Name = "Best Graphics", FileName="BestGraphics", Winner=5,
                Description="The highest quality and most innovative use of graphical content in a demo. This includes painted 2D graphics, 3D modelling and texturing.",
            Nominees= new List<Nominee> {
                new Nominee() { Name="Azathioprine",    Group="Alcatraz", FileName="azathioprine-by-alcatraz", Width= 1024, Height=720, ExtractStart=110},
                new Nominee() { Name="Batman Forever",    Group="Batman Group", FileName="batman-forever-by-batman-group", ExtractStart=197},
                new Nominee() { Name="Dream Travel 90%",    Group="Samar Productions", FileName="dream-travel-by-samar-productions", Width= 480, Height=340, ExtractStart=422},
                new Nominee() { Name="Grandma",    Group="Rustbloom", FileName="grandma-by-rustbloom"},
                new Nominee() { Name="Superhero vs Supervillain tUM 2011 invitation",    Group="Rebels", FileName="superhero-vs-supervillain-by-rebels", ExtractStart=90},
                new Nominee() { Name="Human Traffic",    Group="Ghostown & Loonies", FileName="human-traffic-by-ghostown-and-loonies", ExtractStart=35},
            }},

            new Category(){ Name = "Best Soundtrack", FileName="BestSoundtrack", Winner=5,
                Description="The most outstanding soundtrack in a demo. A solid work both when it comes to craftmanship (mixing, quality of sound) and originality. A soundtrack that supports its demo well and contributes to the viewing experience.",
            Nominees= new List<Nominee> {
                new Nominee() { Name="Haxholm",    Group="Loonies & Brainstorm", FileName="haxholm-by-loonies-and-brainstorm", ExtractStart=35},
                new Nominee() { Name="Human Traffic",    Group="Ghostown & Loonies", FileName="human-traffic-by-ghostown-and-loonies", ExtractStart=90},
                new Nominee() { Name="Shake off the Dust",    Group="Elude", FileName="shake-off-the-dust-by-elude", ExtractStart=97},
                new Nominee() { Name="Spin",    Group="Andromeda Software Development", FileName="spin-by-asd", ExtractStart=134},
                new Nominee() { Name="Struct",    Group="Outracks", FileName="struct-by-outracks"},
                new Nominee() { Name="Numb Res",    Group="CNCD & Fairlight", FileName="numb-res-by-fairlight", ExtractStart=245},
            }},
            new Category(){ Name = "Best Direction", FileName="BestDirection", Winner=1,
                Description="The most outstanding direction in a demo. Direction is about execution, story or flow - about making all the elements of a production fit together in a coherent way.",
            Nominees= new List<Nominee> {
                new Nominee() { Name="Beta",    Group="Still", FileName="beta-by-still"},
                new Nominee() { Name="Numb Res",    Group="CNCD & Fairlight", FileName="numb-res-by-fairlight", ExtractStart=190},
                new Nominee() { Name="Spin",    Group="Andromeda Software Development", FileName="spin-by-asd", ExtractStart=204},    
                new Nominee() { Name="The Butterfly Effect",    Group="Andromeda Software Development", FileName="the-butterfly-effect-by-asd", ExtractStart=200},
                new Nominee() { Name="Uncovering Static",    Group="Fairlight & Alcatraz", FileName="uncovering-static-by-fairlight", ExtractStart=35},
                new Nominee() { Name="Spheres on a Plane",    Group="Dead Roman", FileName="sphere-on-a-plane-by-dead-roman", ExtractStart=91},
            }},
            new Category(){ Name = "Best 4k Intro", FileName="Best4k", Winner=0,
                Description="Most outstanding intro of the year in 4 kilobytes. A work that is aesthetically on a new level, considering the limits of 4k, or is otherwise pushing the limits of 4k intros.",
            Nominees= new List<Nominee> {
                new Nominee() { Name="Chaos Theory 4k (KK remix)",    Group="DMA", FileName="chaos-theory-remix-by-dma"},
                new Nominee() { Name="Code Is My Pron",    Group="Nuance", FileName="code-is-my-pron-by-nuance", ExtractStart=97},
                new Nominee() { Name="Michigan",    Group="Loonies", FileName="michigan-by-loonies"},
                new Nominee() { Name="Sumu",    Group="Cubicle", FileName="sumu-by-cubicle", ExtractStart=97},
                new Nominee() { Name="Wishful Seedling",    Group="Fnuque & Loonies", FileName="wishful-seedling-by-funque-and-loonies", ExtractStart=128},
                new Nominee() { Name="Anglerfish",    Group="Cubicle", FileName="anglerfish-by-cubicle", ExtractStart=65},
            }},
            new Category(){ Name = "Best 64k Intro", FileName="Best64k", Winner=3,
                Description="Most outstanding intro of the year in 64 kilobytes. An intro that has an impressive amount of content for its size, as well as being entertaining in its own right.",
                Nominees= new List<Nominee> {
                new Nominee() { Name="Epsilon",    Group="Mercury", FileName="epsilon-by-mercury"},
                new Nominee() { Name="Pandora",    Group="Brain Control", FileName="pandora-by-brain-control"},
                new Nominee() { Name="Transplant",    Group="Brain Control & Still", FileName="transplant-by-brain-control"},
                new Nominee() { Name="Uncovering Static",    Group="Fairlight & Alcatraz", FileName="uncovering-static-by-fairlight"},
                new Nominee() { Name="Chaos Constructions 2011 Invitation",    Group="Quite", FileName="chaos-constructions-invitation-by-quite"},
            }},
            new Category(){ Name = "Oldschool Platform", FileName="BestOldschool", Winner=3,
                Description="Most outstanding demo on an oldschool platform. Limited to old platforms from the early nineties or before with very limited computational power, where special hardware tricks are necessary to produce a pleasing result.",
                Nominees= new List<Nominee> {
                new Nominee() { Name="2011 - A Press Space Odyssey",    Group="Offence", FileName="a-press-space-odyssey-by-offence", Width= 480, Height=360, ExtractStart=434},
                new Nominee() { Name="Apparatus",    Group="Miracles & Lepsi Developments", FileName="apparatus-by-miracle-and-lepsi-developments", ExtractStart=102},
                new Nominee() { Name="Base Case",    Group="Live!", FileName="base-case-by-live", Width= 800, Height=544, ExtractStart=3 },
                new Nominee() { Name="Batman Forever",    Group="Batman Group", FileName="batman-forever-by-batman-group", Width= 1024, Height=720, ExtractStart=488 },
                new Nominee() { Name="Dream Travel 90%",    Group="Samar Productions", FileName="dream-travel-by-samar-productions", Width= 480, Height=340, ExtractStart=72 },
                new Nominee() { Name="We Are Mature",    Group="Fairlight", FileName="we-are-mature-by-fairlight", ExtractStart=285},
            }},
            new Category(){ Name = "Best Demo", FileName="BestDemo", Winner=1,
                Description="Most outstanding realtime demo of the year. A work that is solid on all fronts - visually, musically and direction-wise - and gives a good overall viewing experience.",
                Nominees= new List<Nominee> {
                new Nominee() { Name="Human Traffic",    Group="Ghostown & Loonies", FileName="human-traffic-by-ghostown-and-loonies", Width= 1152, Height=720 , ExtractStart=147},
                new Nominee() { Name="Numb Res",    Group="CNCD & Fairlight", FileName="numb-res-by-fairlight", ExtractStart=128},
                new Nominee() { Name="Shake off the Dust",    Group="Elude", FileName="shake-off-the-dust-by-elude", ExtractStart=60},
                new Nominee() { Name="Struct",    Group="Outracks", FileName="struct-by-outracks", ExtractStart=120},
                new Nominee() { Name="We Crave Sustenance",    Group="PlayPsyCo", FileName="we-crave-substance-by-playpsyco", ExtractStart=180},
                new Nominee() { Name="Spin",    Group="Andromeda Software Development", FileName="spin-by-asd"},
            }},
            new Category(){ Name = "Public Choice", FileName="PublicChoice", Winner=0,
                Description="Most popular demoscene release of the year voted by the public audience. That means YOU!",
                Nominees= new List<Nominee> {
                new Nominee() { Name="Batman Forever",    Group="Batman Group", FileName="batman-forever-by-batman-group", Width= 1024, Height=720, ExtractStart=455},
                new Nominee() { Name="D - Four",    Group="Ctrl-Alt-Test", FileName="d-four-by-ctrl-alt-test", ExtractStart=35},
                new Nominee() { Name="Human Traffic",    Group="Ghostown & Loonies", FileName="human-traffic-by-ghostown-and-loonies", Width= 1152, Height=720, ExtractStart=125 },
                new Nominee() { Name="Numb Res",    Group="CNCD & Fairlight", FileName="numb-res-by-fairlight", ExtractStart=240},
                new Nominee() { Name="Pirates of the 777 Seas",    Group="Razor 1911", FileName="pirates-of-the-777-seas-by-razor1911", ExtractStart=240},
                new Nominee() { Name="Shake off the Dust",    Group="Elude", FileName="shake-off-the-dust-by-elude", ExtractStart=65},
                new Nominee() { Name="Spin",    Group="Andromeda Software Development", FileName="spin-by-asd", ExtractStart=185},
                new Nominee() { Name="The Butterfly Effect",    Group="Andromeda Software Development", FileName="the-butterfly-effect-by-asd", ExtractStart=120},
                new Nominee() { Name="Uncovering Static",    Group="Fairlight & Alcatraz", FileName="uncovering-static-by-fairlight", ExtractStart=219},
                new Nominee() { Name="We Have Accidently Borrowed Your Votedisk",    Group="Razor 1911", FileName="we-have-accidently-borrowed-your-votedisk-by-razor1911"},
            }},      
        };

        static public int CategoryIndex = 0;
        static public int NomineeIndex = 0;

        public Class_SOAStateMachine() {
            Input.Keyboard.KeyPressedEvent += new KeyboardInput.KeyDelegate(HandleKeyboardKeyPressedEvent);
            Input.Keyboard.KeyReleasedEvent += new KeyboardInput.KeyDelegate(HandleKeyboardKeyReleasedEvent);

            //SoundPlayers["intro"] = new SoundPlayer("./assets-scene-awards/voiceovers/BaseCase_by_Live.wav");
            SoundPlayers["intro"] = new SoundPlayer("./assets/awards/music/soa_intro.mp3");
            SoundPlayers["bg"] = new SoundPlayer("./assets/awards/music/soa_bg.mp3");
            SoundPlayers["voiceover"] = new SoundPlayer("./assets/awards/music/soa_bg.mp3");
            SoundPlayers["soundtrack"] = new SoundPlayer("./assets/awards/music/soa_bg.mp3");

            currentState = new OffState();
            currentState.OnEnter();
        }

        public static void SetState(Type newState) {
            currentState.OnPass();
            Logger.Info("StateMachine >> Enter state {0}", newState);
            currentState = Activator.CreateInstance(newState) as SimpleState;
            currentState.OnEnter();
            StateSwitchTime= currentTime;
        }

        bool _ExitTriggered = false;
        bool _ContinueTriggered = false;


        void HandleKeyboardKeyPressedEvent(object o, KeyboardInput.KeyEventArgs e) {
            if (currentState != null) {
                if (!currentState.OnKeyPressed(e)) {
                    if (e.Keys == Keys.Enter) {
                        _ContinueTriggered = true;
                    }
                    else if (e.Keys == Keys.Q) {
                        if (currentState.ExitState != null) {
                            _ExitTriggered=true;
                            
                        }
                    }
                }
            }
        }
        void HandleKeyboardKeyReleasedEvent(object o, KeyboardInput.KeyEventArgs e) {
        }


        List<List<string>> SplitCSV(string line)
        {
            bool escapeActive = false;
            bool quoteActive = false;
            List<List<string>> result = new List<List<string>>();
            var lineStrings = new List<string>();
            string token = "";
            foreach (char c in line)
            {
                if (c == '\\') {
                    if (escapeActive) {
                        token += c; 
                    }
                    else {
                        escapeActive = true;
                    }
                } 
                else if (c == '"') {
                    if (escapeActive) {
                        token += c;
                    } else if (quoteActive) {
                        quoteActive = false;
                    } else {
                        quoteActive = true;
                    }
                } else if (c == ',') {
                    if (quoteActive) {
                        token += c;
                    } else {
                        lineStrings.Add(token);
                        token = "";
                    }
                }
                else if (c == '\n') {
                    if (quoteActive) {
                        token += c;
                    }
                    else {
                        lineStrings.Add(token);
                        token = String.Empty;
                        result.Add(lineStrings);
                        lineStrings = new List<string>();
                    }
                }
                else {
                    token += c;
                }
            }
            if (!String.IsNullOrEmpty(token)) {
                lineStrings.Add(token);
                result.Add(lineStrings);
            }
            return result;
        }

        Dictionary<string, int> KeysFromHeadline(List<string> headlineStrings) {
            int id = 0;
            Dictionary<string, int> result = new Dictionary<string, int>();
            foreach (var s in headlineStrings) {
                result[s] = id++;
            }
            return result;
        }

        public void UpdateWinnersFromCSV(string csv) {
            return;
//            if(csv != _keepCategoriesCSV) {
//                InvalidData = false;
//                _keepCategoriesCSV = csv;
//                Logger.Info(this,"Updateing winners from CSV");
//
//                if (csv != "") {
//                    var lineStrings = SplitCSV(csv);
//                    var keyIds = KeysFromHeadline(lineStrings[0]);
//                    if (!keyIds.ContainsKey("CategoryID") || !keyIds.ContainsKey("WinnerID")) {
//                        Logger.Warn(this,"Invalid category csv fileformat. CategoryID or WinnerID not found");
//                        InvalidData = true;
//                    }
//                    else {
//
//                        Dictionary<string, string> categoryWinnerIds = new Dictionary<string, string>();
//
//                        for (int i = 1; i < lineStrings.Count; i++) {
//                            var ls = lineStrings[i];
//                            string catId = ls[keyIds["CategoryID"]];
//                            string winnerId = ls[keyIds["WinnerID"]];
//                            categoryWinnerIds[catId] = winnerId;
//                        }
//
//                        foreach (var c in CategoriesAndNominees) {
//                            if (categoryWinnerIds.ContainsKey(c.FileName)) {
//                                int id = 0;
//                                foreach (var n in c.Nominees) {
//                                    if (n.FileName == categoryWinnerIds[c.FileName]) {
//                                        break;
//                                    }
//                                    else {
//                                        id++; 
//                                    }
//                                }
//                                if (id < c.Nominees.Count) {
//                                    c.Winner = id;
//                                }
//                                else {
//                                    Logger.Warn(this,String.Format("WinnerID {0} not found in Category {1}", categoryWinnerIds[c.FileName], c.FileName));
//                                    InvalidData = true;
//                                }
//                            }
//                        }
//                    }
//                }
//                Logger.Info(this,"...completed");
//            }
        }
//        private string _keepCategoriesCSV="";

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
       
            //>>> _params
            var Input = inputs[(int)InputId.Input];
            var Index = inputs[(int)InputId.Index].Eval(context).Value;
            var CategoriesCSV = inputs[(int)InputId.CategoriesCSV].Eval(context).Text;
            //<<< _params        
            
            //UpdateWinnersFromCSV(CategoriesCSV);
            
            currentTime= context.Time;

            if (currentState != null) {
                currentState.OnFrame();

                if (currentState.Duration != 0 && currentState.NextState != null) {
                    if (currentTime - StateSwitchTime > currentState.Duration) {
                        SetState(currentState.NextState);
                    }
                }
            }

            if (_ExitTriggered) {
                currentState.OnExit();
                SetState(currentState.ExitState);
                _ExitTriggered = false;
            }
            if (_ContinueTriggered) {
                if (currentState.NextState != null) {
                    SetState(currentState.NextState);
                }
                _ContinueTriggered= false;
            }

            SoundPlayers["bg"].SetVolume((float)backgroundLoopVolumeAnimator.GetValue(currentTime));

            context.Variables["RingFocus"] = (float) ringFocusAnimator.GetValue(context.Time);
            context.Variables["CategoryTypeAnim"] = (float) categoryDescriptionAnimator.GetValue(context.Time);
            context.Variables["CategoryId"] = CategoryIndex;
            context.Variables["NomineeId"]  = NomineeIndex;
            context.Variables["InvalidData"] = InvalidData?1:0;

            NomineeIndex = Math.Min(NomineeIndex, CategoriesAndNominees[CategoryIndex].Nominees.Count);
            NomineeFileName= CategoriesAndNominees[CategoryIndex].Nominees[NomineeIndex].FileName;
            context.Objects["NomineeFileName"]  = NomineeFileName;
            context.Objects["CategoryName"] = CategoriesAndNominees[CategoryIndex].Name;
            context.Objects["CategoryDescription"] = CategoriesAndNominees[CategoryIndex].Description;
            context.Objects["ReleaseName"]  = CategoriesAndNominees[CategoryIndex].Nominees[NomineeIndex].Name;
            context.Objects["GroupName"]    = CategoriesAndNominees[CategoryIndex].Nominees[NomineeIndex].Group;


            foreach (var k in FloatVariables.Keys) {
                context.Variables[k]= FloatVariables[k];
            }
            foreach (var k in StringVariables.Keys) {
                context.Objects[k]= StringVariables[k];
            }

            Input.Eval(context);
            return context;
        }
        static public string NomineeFileName { get; set; }
        static public Dictionary<String, float> FloatVariables = new Dictionary<string, float>();
        static public Dictionary<String, string> StringVariables = new Dictionary<string, string>();
        //static public Dictionary<String, object> GenericVariables = new Dictionary<string, object>();
        static public Dictionary<String, SoundPlayer> SoundPlayers = new Dictionary<string, SoundPlayer>();

        static public SmoothInterpolator ringFocusAnimator = new SmoothInterpolator(defaultValue:0, acceleration:0.4, delta:0.001);
        static public SmoothInterpolator categoryDescriptionAnimator = new SmoothInterpolator(0, acceleration:0.6, delta:0.001);
        static public SmoothInterpolator backgroundLoopVolumeAnimator = new SmoothInterpolator(defaultValue:1,  acceleration:0.1 );

        static public SimpleState currentState { get; set; }
        static public float currentTime = 0;
        static public float StateSwitchTime { get; set; }
    }

    //---------------------------------------------------------------------------------


    public class OffState : SimpleState
    {
        public OffState()
            : base() {
            NextState= typeof(IntroState);
        }
        override public void OnEnter() {
            Class_SOAStateMachine.FloatVariables["MainSceneId"] = MainScenes.OFF;
            Class_SOAStateMachine.SoundPlayers["intro"].Stop();
            Class_SOAStateMachine.SoundPlayers["bg"].Stop();
            Class_SOAStateMachine.SoundPlayers["voiceover"].Stop();
        }
    }


    public class IntroState : SimpleState
    {
        public IntroState()
            : base() {
            NextState= typeof(BackgroundState);
            ExitState= typeof(OffState);
            Duration = 185.0;  
        }

        override public void OnEnter() {
            Class_SOAStateMachine.FloatVariables["MainSceneId"] = MainScenes.INTRO;
            Class_SOAStateMachine.FloatVariables["StateEnterTime"] = Class_SOAStateMachine.currentTime;
            Class_SOAStateMachine.SoundPlayers["intro"].Play();            
        }

        public override void OnPass() {
            base.OnPass();
            Class_SOAStateMachine.SoundPlayers["bg"].Play(loop: true);
            Class_SOAStateMachine.SoundPlayers["bg"].SetVolume(0.2f);
            //SOAStateMachine.FloatVariables["StateEnterTime"] = SOAStateMachine.currentTime;
        }

        public override void OnExit() {
            base.OnExit();
            Class_SOAStateMachine.SoundPlayers["intro"].Stop();
        }
    }


    public class BackgroundState : SimpleState
    {
        public static int _autoTestCategoryIndex=0;

        public BackgroundState()
            : base() {
            //NextState= typeof(CategoryIntroState);
            ExitState = typeof(OffState);
        }

        override public void OnEnter() {
            Class_SOAStateMachine.FloatVariables["MainSceneId"] = MainScenes.BACKGROUND;

            Class_SOAStateMachine.FloatVariables["NomineeMaxTime"] = 0.0f;
            Class_SOAStateMachine.SoundPlayers["intro"].Stop();
            Class_SOAStateMachine.ringFocusAnimator.AnimateTo(0);
            Class_SOAStateMachine.categoryDescriptionAnimator.AnimateTo(0);

            // Continue on caps lock (autotest)
            if( Control.IsKeyLocked(Keys.CapsLock)  ) {
                Class_SOAStateMachine.CategoryIndex = _autoTestCategoryIndex;
                _autoTestCategoryIndex++;
                if (_autoTestCategoryIndex > 11) {
                    _autoTestCategoryIndex =0;
                }
                NextState = typeof(CategoryIntroState);
                Duration = 2;
            }

        }
        // Toggle categories by keyboard
        public override bool OnKeyPressed(KeyboardInput.KeyEventArgs e) {
            switch (e.Keys) {
                case Keys.D1: Class_SOAStateMachine.CategoryIndex = 0; break;
                case Keys.D2: Class_SOAStateMachine.CategoryIndex = 1; break;
                case Keys.D3: Class_SOAStateMachine.CategoryIndex = 2; break;
                case Keys.D4: Class_SOAStateMachine.CategoryIndex = 3; break;
                case Keys.D5: Class_SOAStateMachine.CategoryIndex = 4; break;
                case Keys.D6: Class_SOAStateMachine.CategoryIndex = 5; break;
                case Keys.D7: Class_SOAStateMachine.CategoryIndex = 6; break;
                case Keys.D8: Class_SOAStateMachine.CategoryIndex = 7; break;
                case Keys.D9: Class_SOAStateMachine.CategoryIndex = 8; break;
                case Keys.D0: Class_SOAStateMachine.CategoryIndex = 9; break;
                case Keys.A: Class_SOAStateMachine.CategoryIndex =  10; break;
                case Keys.B: Class_SOAStateMachine.CategoryIndex =  11; break;
                default: return false;
            }
            Class_SOAStateMachine.SetState(typeof(CategoryIntroState)); 
            return true;
        }


    }

    /**
     * "Best Demo!"
     */
    public class CategoryIntroState : SimpleState
    {
        public CategoryIntroState()
            : base() {
            ExitState= typeof(BackgroundState);
            NextState= typeof(CategoryDescriptionState);
            Duration=3.0;
            Class_SOAStateMachine.categoryDescriptionAnimator.SetValue(0);
        }
        public override void OnEnter() {
            Class_SOAStateMachine.NomineeIndex=0;
            Class_SOAStateMachine.FloatVariables["NomineeMaxTime"] = 0.0f;
            Class_SOAStateMachine.categoryDescriptionAnimator.AnimateTo(1);
            Class_SOAStateMachine.backgroundLoopVolumeAnimator.AnimateTo(0.02);
            Class_SOAStateMachine.FloatVariables["NominleeStartTime"] = Class_SOAStateMachine.currentTime-7.5f;
            
            Class_SOAStateMachine.ringFocusAnimator.AnimateTo(1);
            Class_SOAStateMachine.SoundPlayers["voiceover"].Play(
                filepath: String.Format("./assets-scene-awards/voiceovers-misc/{0}.wav", Class_SOAStateMachine.CategoriesAndNominees[Class_SOAStateMachine.CategoryIndex].FileName));
        }        
    }

    /**
     * "This category blah, blah blah..."
     */
    public class CategoryDescriptionState : SimpleState
    {
        public CategoryDescriptionState()
            : base() {
            ExitState= typeof(BackgroundState);
            NextState = typeof(CategoryNomineesIntroState);

            // Continue on caps lock (autotest)
            if (Control.IsKeyLocked(Keys.CapsLock)) {
                Duration=5;
            }
        }

        public override void OnEnter() {
            base.OnEnter();            
            Class_SOAStateMachine.categoryDescriptionAnimator.AnimateTo(2);
            Class_SOAStateMachine.SoundPlayers["voiceover"].Play(
                filepath: String.Format("./assets-scene-awards/voiceovers-misc/{0}Description.wav", Class_SOAStateMachine.CategoriesAndNominees[Class_SOAStateMachine.CategoryIndex].FileName));
        }
    }

    /**
     *  "And the nominees are..."
     */
    public class CategoryNomineesIntroState : SimpleState
    {
        public CategoryNomineesIntroState()
            : base() {
                ExitState= typeof(CategoryBackgroundState);
            NextState = typeof(CategoryNomineesState);
            Duration = 2;
        }

        public override void OnEnter() {
            base.OnEnter();
            Class_SOAStateMachine.backgroundLoopVolumeAnimator.AnimateTo(0.0);
            //SOAStateMachine.ringFocusAnimator.AnimateTo(2);
            //SOAStateMachine.categoryDescriptionAnimator.AnimateTo(3);
            //SOAStateMachine.SoundPlayers["voiceover"].Play(filepath: "./assets-scene-awards/voiceovers-misc/AndTheNomineesAre.wav");
            //SOAStateMachine.FloatVariables["NomineeStartTime"] = SOAStateMachine.currentTime;
            //SOAStateMachine.NomineeIndex=1;
            Class_SOAStateMachine.ringFocusAnimator.AnimateTo(2);
            Class_SOAStateMachine.categoryDescriptionAnimator.AnimateTo(3);
        }
    }

    /**
     *  "Blah! by XYZ..."
     */
    public class CategoryNomineesState : SimpleState
    {
        public CategoryNomineesState()
            : base() {
                ExitState= typeof(CategoryBackgroundState);
            Duration=10;

            if (Class_SOAStateMachine.NomineeIndex < Class_SOAStateMachine.CategoriesAndNominees[Class_SOAStateMachine.CategoryIndex].Nominees.Count - 1) {
                NextState = typeof(CategoryNomineesState);
            }
            else {
                NextState = typeof(CategoryBackgroundState);
            }
        }

        public override void OnEnter() {
            base.OnEnter();
            Class_SOAStateMachine.FloatVariables["NomineeMaxTime"] = 10.0f;
            Class_SOAStateMachine.FloatVariables["NomineeStartTime"] = Class_SOAStateMachine.currentTime;
            Class_SOAStateMachine.SoundPlayers["voiceover"].Play(
                filepath: String.Format("./assets-scene-awards/voiceovers-nominees/{0}.wav",
                Class_SOAStateMachine.CategoriesAndNominees[Class_SOAStateMachine.CategoryIndex].Nominees[Class_SOAStateMachine.NomineeIndex].FileName));
            Class_SOAStateMachine.FloatVariables["NomineeWidth"] = Class_SOAStateMachine.CategoriesAndNominees[Class_SOAStateMachine.CategoryIndex].Nominees[Class_SOAStateMachine.NomineeIndex].Width;
            Class_SOAStateMachine.FloatVariables["NomineeHeight"] = Class_SOAStateMachine.CategoriesAndNominees[Class_SOAStateMachine.CategoryIndex].Nominees[Class_SOAStateMachine.NomineeIndex].Height;
            Class_SOAStateMachine.FloatVariables["ExtractStart"] = Class_SOAStateMachine.CategoriesAndNominees[Class_SOAStateMachine.CategoryIndex].Nominees[Class_SOAStateMachine.NomineeIndex].ExtractStart;



            //SOAStateMachine.SoundPlayers["soundtrack"].Play(
            //    filepath: String.Format("./assets-scene-awards/soundtracks/{0}.mp3",
            //    SOAStateMachine.CategoriesAndNominees[SOAStateMachine.CategoryIndex].Nominees[SOAStateMachine.NomineeIndex].FileName), loop:false, seektime:90);
        
        }
        public override void OnPass() {
            Class_SOAStateMachine.NomineeIndex++;
        }
    }

    /**
     * ...waiting for winner...
     */
    public class CategoryBackgroundState : SimpleState
    {
        public CategoryBackgroundState()
            : base() {
            ExitState= typeof(BackgroundState);
            NextState = typeof(CategoryWinnerState);
            // Continue on caps lock (autotest)
            if (Control.IsKeyLocked(Keys.CapsLock)) {
                Duration=2;
            }
        }

        public override void OnEnter() {
            Class_SOAStateMachine.NomineeIndex=0;
            Class_SOAStateMachine.FloatVariables["NomineeMaxTime"] = 0f;
            Class_SOAStateMachine.backgroundLoopVolumeAnimator.AnimateTo(0.1);
            Class_SOAStateMachine.categoryDescriptionAnimator.AnimateTo(4);
            Class_SOAStateMachine.ringFocusAnimator.AnimateTo(1);
            base.OnEnter();
        }
    }

    /**
     * "The the winner is..."
     */
    public class CategoryWinnerState : SimpleState
    {
        public CategoryWinnerState()
            : base() {
                ExitState= typeof(CategoryBackgroundState);
                NextState = typeof(CategoryWinnerState2);
            Duration= 2.0;
        }

        public override void OnEnter() {
            base.OnEnter();
            Class_SOAStateMachine.backgroundLoopVolumeAnimator.AnimateTo(0.02);
            Class_SOAStateMachine.categoryDescriptionAnimator.AnimateTo(5);
            //SOAStateMachine.SoundPlayers["voiceover"].Play(filepath: "./assets-scene-awards/voiceovers-misc/AndTheNomineesAre.wav");
            //SOAStateMachine.SoundPlayers["voiceover"].Play(
            //    filepath: String.Format("./assets-scene-awards/voiceovers-misc/TheWinnerIs.wav", SOAStateMachine.CategoriesAndNominees[SOAStateMachine.CategoryIndex].FileName));

        }
    }

    /**
     * "The the winner is 2"
     */
    public class CategoryWinnerState2 : SimpleState
    {
        public CategoryWinnerState2()
            : base() {
            ExitState= typeof(CategoryBackgroundState);
            NextState = typeof(CategoryExitState);
            // Continue on caps lock (autotest)
            if (Control.IsKeyLocked(Keys.CapsLock)) {
                Duration=10;
            }
        }

        public override void OnEnter() {
            base.OnEnter();

            int winnerId= (int) Class_SOAStateMachine.CategoriesAndNominees[Class_SOAStateMachine.CategoryIndex].Winner;
            Class_SOAStateMachine.NomineeIndex= winnerId;

            Class_SOAStateMachine.backgroundLoopVolumeAnimator.AnimateTo(0.0);
            Class_SOAStateMachine.FloatVariables["NomineeStartTime"] = Class_SOAStateMachine.currentTime;
            Class_SOAStateMachine.FloatVariables["NomineeMaxTime"] = 7.5f;
            Class_SOAStateMachine.categoryDescriptionAnimator.AnimateTo(6);
            Class_SOAStateMachine.ringFocusAnimator.AnimateTo(2);
            //SOAStateMachine.SoundPlayers["voiceover"].Play(
            //    filepath: String.Format("./assets-scene-awards/voiceovers-nominees/{0}.wav",
            //    SOAStateMachine.CategoriesAndNominees[SOAStateMachine.CategoryIndex].Nominees[winnerId].FileName));

            Class_SOAStateMachine.FloatVariables["NomineeWidth"]  = Class_SOAStateMachine.CategoriesAndNominees[Class_SOAStateMachine.CategoryIndex].Nominees[Class_SOAStateMachine.NomineeIndex].Width;
            Class_SOAStateMachine.FloatVariables["NomineeHeight"] = Class_SOAStateMachine.CategoriesAndNominees[Class_SOAStateMachine.CategoryIndex].Nominees[Class_SOAStateMachine.NomineeIndex].Height;

            //SOAStateMachine.SoundPlayers["soundtrack"].Play(
            //    filepath: String.Format("./assets-scene-awards/soundtracks/{0}.mp3",
            //    SOAStateMachine.CategoriesAndNominees[SOAStateMachine.CategoryIndex].Nominees[winnerId].FileName));
        }

        public override void OnPass() {            
            base.OnPass();
            Class_SOAStateMachine.categoryDescriptionAnimator.AnimateTo(7);
            Class_SOAStateMachine.ringFocusAnimator.AnimateTo(0);
            Class_SOAStateMachine.backgroundLoopVolumeAnimator.AnimateTo(0.4);
            Class_SOAStateMachine.FloatVariables["NomineeStartTime"] = Class_SOAStateMachine.currentTime-7.5f;
            Class_SOAStateMachine.FloatVariables["NomineeMaxTime"] = 10000.0f;            
        }
        public override void OnExit() {
            Logger.Info("StateMachine >> CategoryWinnerState2.OnExit()");
        }      
    }
    

    /**
     * "...back to idle mode"
     */
    public class CategoryExitState : SimpleState
    {
        public CategoryExitState()
            : base() {
                ExitState= typeof(BackgroundState);
                NextState = typeof(BackgroundState);
            Duration= 2.5;
        }

        public override void OnEnter() {
            base.OnEnter();
            //SOAStateMachine.backgroundLoopVolumeAnimator.AnimateTo(0.02);
            //SOAStateMachine.categoryDescriptionAnimator.AnimateTo(5);
            Class_SOAStateMachine.FloatVariables["NomineeStartTime"] = Class_SOAStateMachine.currentTime-7.5f;
            Class_SOAStateMachine.FloatVariables["NomineeMaxTime"] = 10.0f;
            //SOAStateMachine.SoundPlayers["voiceover"].Play(filepath: "./assets-scene-awards/voiceovers-misc/AndTheNomineesAre.wav");
            //SOAStateMachine.SoundPlayers["voiceover"].Play(
            //    filepath: String.Format("./assets-scene-awards/voiceovers-misc/TheWinnerIs.wav", SOAStateMachine.CategoriesAndNominees[SOAStateMachine.CategoryIndex].FileName));

        }
    }    



    //---------------------------------------------------------------------------------

    public class SimpleState
    {
        public Type NextState { get; set; }
        public Type ExitState { get; set; }
        public Double Duration { get; set; }

        public virtual void OnEnter() { }
        public virtual void OnPass() { }        // Triggered when jumping leaving the state (e.g. always)
        public virtual void OnExit() { }        // Triggered only when when q is pressed while state is active

        public virtual void OnFrame() { }

        public virtual bool OnKeyPressed(KeyboardInput.KeyEventArgs e) {
            return false;   // not handled
        }

        public virtual bool OnKeyReleased(KeyboardInput.KeyEventArgs e) {
            return false;   // not handled
        }
    }

    /**
     * Simple sound Player
     */
    public class SoundPlayer
    {
        public SoundPlayer(string filepath) {
            FilePath = filepath;
        }

        public void Load(string filepath) {
            FilePath = filepath;
            _stream=0;
        }


        public void Pause() {
            Bass.BASS_ChannelPause(_stream);
        }



        public void Play(string filepath=null, bool loop= false, double seektime=0) {
            Stop();
            if (filepath != null && filepath != FilePath) {
                FilePath= filepath;
                _stream=0;
            }

            if (_stream == 0) {
                if (File.Exists(FilePath)) {
                    _fileName = FilePath;
                    _stream = Bass.BASS_StreamCreateFile(_fileName, 0, 0, BASSFlag.BASS_STREAM_PRESCAN);
                    _channelInfo = Bass.BASS_ChannelGetInfo(_stream);
                    Logger.Debug("StateMachine >> Opened sound: {0}", _fileName);
                }
            }

            Bass.BASS_ChannelPlay(_stream, true);
            Bass.BASS_ChannelSetPosition(_stream, seektime);
            //Bass.BASS_ChannelSetAttribute(_stream, BASSAttribute.BASS_ATTRIB_FREQ, _channelInfo.freq*PlaySpeed);
            if (loop) {
                Bass.BASS_ChannelFlags(_stream, BASSFlag.BASS_MUSIC_LOOP, BASSFlag.BASS_MUSIC_LOOP);
            }
        }

        public void SetVolume(float v) {
            Bass.BASS_ChannelSetAttribute(_stream, BASSAttribute.BASS_ATTRIB_VOL, v);
        }


        public float GetPlayTime() {
            return (float) Bass.BASS_ChannelBytes2Seconds(_stream, Bass.BASS_ChannelGetPosition(_stream, BASSMode.BASS_POS_BYTES));
        }

        public void Stop() {
            if (_stream != 0) {
                Bass.BASS_ChannelPause(_stream);
                Bass.BASS_ChannelStop(_stream);
                //Bass.BASS_StreamFree(_stream);
                Logger.Debug("StateMachine >> closed sound: {0}", _fileName);
            }
        }
        private bool IsSoundInitialized() {
            return Bass.BASS_GetInfo() != null;
        }

        private bool IsPlaying() {
            return Bass.BASS_ChannelIsActive(_stream) == Un4seen.Bass.BASSActive.BASS_ACTIVE_PLAYING;
        }

        public string FilePath { get; set; }

        string _fileName;
        int _stream;
        BASS_CHANNELINFO _channelInfo;
    }
} 