//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID1b36129e_4716_4595_a7a3_6a55c4e610ba
{
    public class Class_WorldToView : OperatorPart.Function, Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        //>>> _outputids
        private enum OutputId
        {
            ScreenPositionX = 0,
            ScreenPositionY = 1
        }
        //<<< _outputids
        //>>> _inputids
        private enum InputId
        {
            WorldPositionX = 0,
            WorldPositionY = 1,
            WorldPositionZ = 2
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> _params
            var WorldPositionX = inputs[(int)InputId.WorldPositionX].Eval(context).Value;
            var WorldPositionY = inputs[(int)InputId.WorldPositionY].Eval(context).Value;
            var WorldPositionZ = inputs[(int)InputId.WorldPositionZ].Eval(context).Value;
            var WorldPosition = new Vector3(WorldPositionX, WorldPositionY, WorldPositionZ);
            //<<< _params

            if (Changed)
            {
                Matrix worldToView = context.WorldToCamera*context.CameraProjection;
                _lastEvaluatedScreenPosition = Vector3.TransformCoordinate(WorldPosition, worldToView);
                Changed = false;
            }

            context.Value = 0.0f;
            switch (outputIdx)
            {
                case (int)OutputId.ScreenPositionX: context.Value = _lastEvaluatedScreenPosition.X; break;
                case (int)OutputId.ScreenPositionY: context.Value = _lastEvaluatedScreenPosition.Y; break;
            }            
            return context;
        }

        Vector3 _lastEvaluatedScreenPosition;
    }
}

