//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID69bc520e_e470_450d_86c9_673da671ef67
{
    public class Class_FMod : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Value1 = 0,
            Value2 = 1
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> _params
            var Value1 = inputs[(int)InputId.Value1].Eval(context).Value;
            var Value2 = inputs[(int)InputId.Value2].Eval(context).Value;
            //<<< _params
            //>>> function
            if (Value2 != 0) {
                if(Value1 < 0) {
                    context.Value= Value2 + (Value1 % Value2);
                }
                else {
                    context.Value= Value1 % Value2;
                }
            }
            else {
                context.Value= 0.0f;
            }
            //<<< function
            
            return context;
        }
    }
}

