//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID2e57110e_4c07_4fb4_894b_d30197b639c7
{
    public class Class_FindMinOrMax : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Value = 0,
            Mode = 1,
            ResetTrigger = 2
        }
        //<<< _inputids
        
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Value = inputs[(int)InputId.Value].Eval(context).Value;
            var Mode = (int) inputs[(int)InputId.Mode].Eval(context).Value;
            var ResetTrigger = inputs[(int)InputId.ResetTrigger].Eval(context).Value;
            //<<< _params
            
            bool resetFlankUpDetected = _lastResetTrigger < 0.5 && ResetTrigger > 0.5;
            _lastResetTrigger = ResetTrigger;
            if (resetFlankUpDetected)
            {
                Logger.Info(this,"Resetting Trigger");
                switch ((int)Mode)
                {
                    case 0: _lastValue = Value = 999999; break;
                    case 1: _lastValue = Value = -999999; break;
                }
            }

            switch ((int)Mode)
            {
                case 0: _lastValue = Math.Min(_lastValue, Value); break;
                case 1: _lastValue = Math.Max(_lastValue, Value); break;
            }
            context.Value = _lastValue;
            return context;
        }

        float _lastResetTrigger;
        float _lastValue;
    }
}

