//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using Framefield.Core.Profiling;

namespace Framefield.Core.ID0e253ab5_b38e_4619_b6ab_e7c12fdb78e5
{
    public class Class_FrameDropPeriod : OperatorPart.Function, Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        //>>> _inputids
        private enum InputId
        {
            Threshold = 0,
            ResetTrigger = 1,
            MaxCount = 2
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Threshold = inputs[(int)InputId.Threshold].Eval(context).Value;
            var ResetTrigger = inputs[(int)InputId.ResetTrigger].Eval(context).Value;
            var MaxCount = inputs[(int)InputId.MaxCount].Eval(context).Value;
            //<<< _params
            
            if(ResetTrigger > 0.5 || context.Time < _lastTime) {
                _lastTime = context.Time;
                _lastFrameDropTime = context.Time;                
                _outputString = "";
                _count = 0;
            }
                        
            if(context.Time != _lastTime) {
                var lastDuration = (float)(context.Time - _lastTime);
                if(lastDuration > Threshold && _count < MaxCount) {
                    _lastFrameDropPeriod = context.Time - _lastFrameDropTime;
                    _outputString += String.Format("{0,6:0.00} {1,6:0.00}\n", context.Time, _lastFrameDropPeriod);
                    _lastFrameDropTime = context.Time;
                    _count++;
                }
                _lastTime = context.Time;
            }
            context.Value = (float)_lastFrameDropPeriod;
            context.Text = _outputString;
            return context;
        }
        private float _lastDuration;
        private double _lastTime; 
        private double _lastFrameDropTime;
        private double _lastFrameDropPeriod;
        private string _outputString;
        private int _count;
    }
}


