//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using


namespace Framefield.Core.IDd61df8a2_e602_47dd_a47f_344e9573ea7d
{
    public class Class_GenerateMips : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Image = 0
        }
        //<<< _inputids


        public override void Dispose() 
        {
            base.Dispose();
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> _params
            var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
            //<<< _params

            if (Changed)
            {
                using (var srv = new ShaderResourceView(context.D3DDevice, Image))
                {
                    context.D3DDevice.ImmediateContext.GenerateMips(srv);
                }
            }
            context.Image = Image;

            return context;
        }

    }
}

