//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID8ac787a9_f9a3_47a5_8afb_4fc9eafdc09e
{
    public class Class_LocatorScreen : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Input = 0
        }
        //<<< _inputids
        
        //>>> _outputids
        private enum OutputId
        {
            Output = 0,
            PositionX = 1,
            PositionY = 2,
            PositionDepth = 3
        }
        //<<< _outputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Input = inputs[(int)InputId.Input];
            //<<< _params
           
            switch (outputIdx)
            {
                case (int)OutputId.Output:
                {
                    context.ObjectTWorld.Decompose(out _scale, out _rotation, out _position);
                    Matrix worldToView = context.WorldToCamera*context.CameraProjection;
                    _screenPosition = Vector3.TransformCoordinate(_position, worldToView);

                    Input.Eval(context);

                    //because these outputs are dependent on this evaluation, we need to invalidate them here
                    OperatorPart.EmitChangedEventForOutput((int)OutputId.PositionX);
                    OperatorPart.EmitChangedEventForOutput((int)OutputId.PositionY);
                    OperatorPart.EmitChangedEventForOutput((int)OutputId.PositionDepth);
                    break;
                }
                case (int)OutputId.PositionX: context.Value = _screenPosition.X; break;
                case (int)OutputId.PositionY: context.Value = _screenPosition.Y; break;
                case (int)OutputId.PositionDepth: context.Value = _screenPosition.Z; break;
            }

            return context;
        }

        Vector3 _scale;
        Quaternion _rotation;
        Vector3 _position;
        Vector3 _screenPosition;
    }
}

