//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using Framefield.Core.Rendering;

namespace Framefield.Core.ID736482d6_370a_4f0a_995b_db4c5ded13e7
{
    public class Class_MoveByImageMap : FXSourceCodeFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Scene = 1,
            DisplaceMap = 2,
            TextureScaleX = 3,
            TextureScaleY = 4,
            RotateAmount = 5,
            RotateOffset = 6,
            InitialScaleX = 7,
            InitialScaleY = 8,
            Shading = 9,
            DisplaceScaleX = 10,
            DisplaceScaleY = 11
        }
        //<<< _inputids
        #region Renderer
        public class Renderer : BaseRenderer
        {
            public override void SetupEffect(OperatorPartContext context)
            {
                base.SetupEffect(context);
                try
                {
                    SetupMaterialConstBuffer(context);
                    SetupFogSettingsConstBuffer(context);
                    SetupPointLightsConstBuffer(context);
                }
                catch (Exception e)
                {
                    Logger.Error(ParentFunc,"Error building constant buffer: {0} - Source: {1}", e.Message, e.Source);
                }
            }
            public OperatorPart.Function ParentFunc{get;set;}
        }
        #endregion

        public Class_MoveByImageMap()
        {
            _renderer = new Renderer(){ParentFunc=this};
        }

        public override void Dispose()
        {
            Utilities.DisposeObj(ref _renderer);
            base.Dispose();
        }

        bool _firstEval = true;
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            // >>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Scene = inputs[(int)InputId.Scene];
            var DisplaceMap = inputs[(int)InputId.DisplaceMap].Eval(context).Image; if (DisplaceMap == null) return context;
            var TextureScaleX = inputs[(int)InputId.TextureScaleX].Eval(context).Value;
            var TextureScaleY = inputs[(int)InputId.TextureScaleY].Eval(context).Value;
            var TextureScale = new Vector2(TextureScaleX, TextureScaleY);
            var RotateAmount = inputs[(int)InputId.RotateAmount].Eval(context).Value;
            var RotateOffset = inputs[(int)InputId.RotateOffset].Eval(context).Value;
            var Rotate = new Vector2(RotateAmount, RotateOffset);
            var InitialScaleX = inputs[(int)InputId.InitialScaleX].Eval(context).Value;
            var InitialScaleY = inputs[(int)InputId.InitialScaleY].Eval(context).Value;
            var InitialScale = new Vector2(InitialScaleX, InitialScaleY);
            var Shading = (int) inputs[(int)InputId.Shading].Eval(context).Value;
            var DisplaceScaleX = inputs[(int)InputId.DisplaceScaleX].Eval(context).Value;
            var DisplaceScaleY = inputs[(int)InputId.DisplaceScaleY].Eval(context).Value;
            var DisplaceScale = new Vector2(DisplaceScaleX, DisplaceScaleY);
            // <<< _params

            if (_firstEval)
            {
                for (int i = 0; i < NumCodes(); ++i)
                    Compile(i);
                _firstEval = false;
                Changed = true;
            }
                
                using (new PropertyStasher<OperatorPartContext>(context, "Effect", "Renderer"))
                // >>> __setup
                using (var DisplaceMapView = new ShaderResourceView(context.D3DDevice, DisplaceMap))
                {                    
                    _effect.GetVariableByName("DisplaceMap").AsShaderResource().SetResource(DisplaceMapView);
                    _effect.GetVariableByName("TextureScale").AsVector().Set(new Vector2(TextureScaleX, TextureScaleY));
                    _effect.GetVariableByName("Rotate").AsVector().Set(new Vector2(RotateAmount, RotateOffset));
                    _effect.GetVariableByName("InitialScale").AsVector().Set(new Vector2(InitialScaleX, InitialScaleY));
                    _effect.GetVariableByName("DisplaceScale").AsVector().Set(new Vector2(DisplaceScaleX, DisplaceScaleY));
                    _effect.GetVariableByName("Shading").AsScalar().Set(Shading);
                // <<< __setup
                

                context.Effect = _effect;
                context.Renderer = _renderer;
                Scene.Eval(context);
            }
            return context;
        }

        Renderer _renderer;
    }
}


