using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;

namespace Framefield.Core.ID4f0fb7d8_76d1_4d57_805e_5754ebbc6f40
{
    public class Class_RoundValue : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Value = 0,
            Precision = 1
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {

            //>>> _params 
            var Value = inputs[(int)InputId.Value].Eval(context).Value;
            var Precision = inputs[(int)InputId.Precision].Eval(context).Value;
            //<<< _params

            
            // Function 
            context.Value = (float)(Math.Round((double)Value/Precision) * (double)Precision);
            // Function
            return context;
        }
    }
}