using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using SharpDX;
using SharpDX.D3DCompiler;
using SharpDX.Direct3D11;
using SharpDX.DXGI;
using SharpDX.Windows;
using Framefield.Core.Rendering;

namespace Framefield.Core.ID71f2f01e_656e_43a8_b9ef_2b15dfd60d4c
{ 
    public class Class_SphereDisplace : OperatorPart.Function
    {
        public class Renderer : BaseRenderer
        {
            public override void SetupEffect(OperatorPartContext context) {
                base.SetupEffect(context);
                context.Effect.GetVariableByName("center").AsVector().Set(_center);
                context.Effect.GetVariableByName("radius").AsVector().Set(_radius);
                context.Effect.GetVariableByName("strength").AsScalar().Set(_strength);
                context.Effect.GetVariableByName("bias").AsScalar().Set(_bias);
            }

            public SharpDX.Vector2 _center;
            public SharpDX.Vector2 _radius;
            public float _strength;
            public float _bias;
        }

        public Class_SphereDisplace() {
            try {
                using (var bytecode = ShaderBytecode.CompileFromFile("assets-common/fx/SphereDisplace.fx", "fx_5_0", ShaderFlags.None, EffectFlags.None, null, null))
                    _effect = new Effect(D3DDevice.Device, bytecode);
                _renderer = new Renderer();
            }
            catch (Exception ex) {
                Logger.Error(this,"error creating effect: {0}", ex.Message);
            }
        }

        public override void Dispose() {
            Utilities.DisposeObj(ref _effect);
            Utilities.DisposeObj(ref _renderer);
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            var Scene = inputs[0];//.Eval(context);
            var CenterX = inputs[1].Eval(context).Value;
            var CenterY = inputs[2].Eval(context).Value;
            _renderer._center = new SharpDX.Vector2(CenterX, CenterY);
            var RadiusX = inputs[3].Eval(context).Value;
            var RadiusY = inputs[4].Eval(context).Value;
            _renderer._radius = new SharpDX.Vector2(RadiusX, RadiusY);
            _renderer._strength = inputs[5].Eval(context).Value;
            _renderer._bias = inputs[6].Eval(context).Value;

            var D3DDevice = context.D3DDevice;
            var subContext = new OperatorPartContext(context);
            try {
                subContext.Effect = _effect;
                subContext.InputLayout = context.Renderer.SceneDefaultInputLayout;
                subContext.Renderer = _renderer;

                Scene.Eval(subContext);
            }
            catch (Exception exception) {
                Logger.Error(this,"Load Effect error: {0}", exception.Message);
            }

            return context;
        }

        Effect _effect;
        Renderer _renderer;
    }
}

