using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;

namespace Framefield.Core.ID71c69cbd_8afd_4eb1_8c67_9046ca16f7a2
{
    public class Class_TransformUV : OperatorPart.Function
    {
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            var SceneInput = inputs[0];
            var TranslateX = (float) inputs[1].Eval(context).Value;
            var TranslateY = (float) inputs[2].Eval(context).Value;
            var TranslateZ = (float) inputs[3].Eval(context).Value;
            var RotateX = (float) inputs[4].Eval(context).Value;
            var RotateY = (float) inputs[5].Eval(context).Value;
            var RotateZ = (float) inputs[6].Eval(context).Value;
            var ScaleX = (float) inputs[7].Eval(context).Value;
            var ScaleY = (float) inputs[8].Eval(context).Value;
            var ScaleZ = (float) inputs[9].Eval(context).Value;
            var PivotX = (float) inputs[10].Eval(context).Value;
            var PivotY = (float) inputs[11].Eval(context).Value;
            var PivotZ = (float) inputs[12].Eval(context).Value;
            //!!automatic generated code ends here
            var translation = new Vector3(TranslateX, TranslateY, TranslateZ);
            var rotation = Quaternion.RotationYawPitchRoll(RotateX / 360.0f * (float)(2.0 * Math.PI),
                                                           RotateY / 360.0f * (float)(2.0 * Math.PI),
                                                           RotateZ / 360.0f * (float)(2.0 * Math.PI));
            var scale = new Vector3(ScaleX, ScaleY, ScaleZ);
            var pivot = new Vector3(PivotX, PivotY, PivotZ);
            
            var transform = Matrix.Transformation(pivot, new Quaternion(), scale, pivot, rotation, translation);
            var prevTransform = context.TextureMatrix;
            context.TextureMatrix = transform * prevTransform;
            var result = SceneInput.Eval(context);
            context.TextureMatrix = prevTransform;
            //!!automatic generated code starts here
            return context;
        }
    }
}

