//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDd2df29b5_97c9_4bcf_80c9_be7c8510164e
{
    public class Class_BlendImagesWithMask : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image1 = 1,
            Image2 = 2,
            Mask = 3
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            return PrepareAndEvalOnChange(context, () =>
            {
                //>>> _params
                var Code = inputs[(int)InputId.Code].Eval(context).Text;
                var Image1 = inputs[(int)InputId.Image1].Eval(context).Image; // Needs to be checked for null!
                var Image2 = inputs[(int)InputId.Image2].Eval(context).Image; // Needs to be checked for null!
                var Mask = inputs[(int)InputId.Mask].Eval(context).Image; // Needs to be checked for null!
                //<<< _params
                
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));
                
                if(Image1 == null || Image2 == null || Mask == null)
                    return;

                //>>> _setup
                using (var Image1View = new ShaderResourceView(context.D3DDevice, Image1))
                using (var Image2View = new ShaderResourceView(context.D3DDevice, Image2))
                using (var MaskView = new ShaderResourceView(context.D3DDevice, Mask))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image1").AsShaderResource().SetResource(Image1View);
                    _effect.GetVariableByName("Image2").AsShaderResource().SetResource(Image2View);
                    _effect.GetVariableByName("Mask").AsShaderResource().SetResource(MaskView);
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

