using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;


namespace Framefield.Core.ID19109abb_fc95_4103_b2bb_9c2ddc4bbbd2
{
    public class Class_CombineStringList : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            StringList = 0,
            Seperator = 1
        }
        //<<< _inputids



        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> params
            dynamic StringList = inputs[(int)InputId.StringList].Eval(context).Dynamic;
            var Seperator = inputs[(int)InputId.Seperator].Eval(context).Text;
            //<<< params            
            
            Seperator = Seperator.Replace("\\n", "\n");
            
            
            if(StringList == null) {
                Logger.Info(this,"Can't convert incoming structure to Dynamic");
                return context;
            }
            
            context.Text = String.Join( Seperator, StringList);
            Logger.Info(this,"{0}", context.Text);
            
            return context;
        }
    }
}

