//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

using System.Text.RegularExpressions;


namespace Framefield.Core.IDc393d6c6_0b9a_45f2_85c2_32f92b2435d4
{
    public class Class_FilterTestResults : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            String = 0
        }
        //<<< _inputids


        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var String = inputs[(int)InputId.String].Eval(context).Text;
            //<<< _params            
            
            if(String == String.Empty) {
                String = _lastResult;
            }
            else {
                _lastResult = String;
            }             
            
            int failCount = 0;
            string result = string.Empty;
            foreach( var line in  String.Split('\n')) {
                if( new Regex(@"(passed)").Match(line).Success )
                    continue;
                    
                if( new Regex(@"\(.*\<.*\)").Match(line).Success )
                    failCount++;
                    
                result+= line.Replace("Tests", "").Replace(": FAILED","") + "\n";
            }
            
            context.Text = String.Format( "{0} TESTS FAILED\n\n", failCount) + result;
            return context;
        }
        
        String _lastResult = String.Empty;
    }
}

