//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID49aedb82_a569_407c_98ec_acaf5dfb0164
{
    public class Class_Hold : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            HoldTrigger = 0,
            ClearTrigger = 1,
            Value = 2
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var HoldTrigger = inputs[(int)InputId.HoldTrigger].Eval(context).Value;
            var ClearTrigger = inputs[(int)InputId.ClearTrigger].Eval(context).Value;
            var Value = inputs[(int)InputId.Value].Eval(context).Value;
            //<<< _params

            bool holdTriggerUp = _oldHoldTrigger < 0.5f && HoldTrigger > 0.5f;
            _oldHoldTrigger = HoldTrigger;
            bool clearTriggerUp = _oldClearTrigger < 0.5f && ClearTrigger > 0.5f;
            _oldClearTrigger = ClearTrigger;
            if (holdTriggerUp)
            {
                _holdValue = Value;
                _holdValueSet = true;
            }
            if (clearTriggerUp)
            {
                _holdValueSet = false;
            }

            context.Value = _holdValueSet ? _holdValue : Value;
            return context;
        }

        float _oldHoldTrigger;
        float _oldClearTrigger;
        float _holdValue;
        bool _holdValueSet = false;
    }
}

