//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using


namespace Framefield.Core.ID1f140717_cc1b_41ed_a2d6_3bf73aac8741
{
    public class Class_Replace : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            String = 0,
            SearchText = 1,
            ReplaceText = 2
        }
        //<<< _inputids


        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var String = inputs[(int)InputId.String].Eval(context).Text;
            var SearchText = inputs[(int)InputId.SearchText].Eval(context).Text;
            var ReplaceText = inputs[(int)InputId.ReplaceText].Eval(context).Text;
            //<<< _params            
            
            if (String.IsNullOrEmpty(String) || String.IsNullOrEmpty(SearchText) || String.IsNullOrEmpty(ReplaceText) ) {
                context.Text = String.Empty;
                return context;
            }
            string result = string.Empty;
            if(ReplaceText == "\\n")
                ReplaceText = "\n";
            context.Text = String.Replace(SearchText, ReplaceText);            
            return context;
        }
    }
}

