//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using SharpDX.DXGI;

namespace Framefield.Core.IDd37a6247_6d99_4567_b7d3_651b2757fefd
{
    public class Class_SetImageBufferFormat : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Input = 0,
            ImageFormat = 1
        }
        //<<< _inputids
        
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Input = inputs[(int)InputId.Input];
            var ImageFormat = (int) inputs[(int)InputId.ImageFormat].Eval(context).Value;
            //<<< _params
            
            var oldImageBufferFormat = context.ImageBufferFormat;
            context.ImageBufferFormat = (SharpDX.DXGI.Format)ImageFormat;

            Input.Eval(context);
            context.ImageBufferFormat = oldImageBufferFormat;

            return context;
        }
    }
}

