/*
 * Decompiled with CFR 0.152.
 */
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PImage;

public class cheers
extends PApplet {
    Moonlander moon;
    PImage keiju;
    PImage kuvio;

    public void setup() {
        this.frameRate(60.0f);
        this.keiju = this.loadImage("data/krapulakeiju.png");
        this.keiju.resize(this.width, this.height);
        this.kuvio = this.loadImage("data/kuvio.png");
        this.imageMode(3);
        this.moon = Moonlander.initWithSoundtrack((PApplet)this, (String)"data/MoveForward.mp3", (int)111, (int)8);
        this.moon.start("localhost", 1339, "data/synkki");
    }

    public void taustakaruselli(float time, float val) {
        float suunta = 0.0f;
        if (val != 4.0f) {
            switch (cheers.floor((float)val)) {
                case 6: {
                    suunta = 1.0f;
                    break;
                }
                default: {
                    suunta = -1.0f;
                }
            }
            this.pushMatrix();
            float angle = cheers.radians((float)(suunta * time / 30.0f));
            this.translate(this.width / 2, this.height / 2);
            this.rotate(angle);
            this.scale(1.8f);
            this.image(this.kuvio, 0.0f, 0.0f);
            this.popMatrix();
        }
    }

    public void bcolsync(float val) {
        int num = cheers.floor((float)val);
        switch (num) {
            case 1: {
                this.background(235.0f, 240.0f, 30.0f);
                break;
            }
            case 2: {
                this.background(250.0f, 130.0f, 40.0f);
                break;
            }
            case 3: {
                this.background(210.0f, 60.0f, 45.0f);
                break;
            }
            case 4: {
                this.background(this.keiju);
                break;
            }
            case 5: {
                this.background(80.0f, 225.0f, 115.0f);
                break;
            }
            default: {
                this.background(250.0f, 200.0f, 80.0f);
            }
        }
    }

    public void spiral(float time) {
        this.pushMatrix();
        this.translate(this.width / 2, this.height / 2);
        this.noStroke();
        this.fill(50.0f, 180.0f, 245.0f);
        int i = 0;
        while (i < 1000) {
            float r = cheers.radians((float)((float)i * time / 2.0f));
            float x = r * cheers.cos((float)r);
            float y = r * cheers.sin((float)r);
            this.ellipse(x, y, 8.0f, 8.0f);
            i += 5;
        }
        this.popMatrix();
    }

    public void draw() {
        this.moon.update();
        float time = this.millis();
        this.background(250.0f, 200.0f, 80.0f);
        float val = (float)this.moon.getValue("val");
        this.bcolsync(val);
        this.taustakaruselli(time, val);
        this.spiral(time / 1000.0f);
        if (val == 13.0f) {
            this.exit();
        }
    }

    public void settings() {
        this.fullScreen();
        this.smooth();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"cheers"};
        if (passedArgs != null) {
            PApplet.main((String[])cheers.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

