/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;

public class PKIXCertPathBuilderResult
extends PKIXCertPathValidatorResult
implements CertPathBuilderResult {
    private CertPath certPath;

    public PKIXCertPathBuilderResult(CertPath certPath, TrustAnchor trustAnchor, PolicyNode policyNode, PublicKey publicKey) {
        super(trustAnchor, policyNode, publicKey);
        if (certPath == null) {
            throw new NullPointerException("certPath must be non-null");
        }
        this.certPath = certPath;
    }

    @Override
    public CertPath getCertPath() {
        return this.certPath;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PKIXCertPathBuilderResult: [\n");
        stringBuffer.append("  Certification Path: " + this.certPath + "\n");
        stringBuffer.append("  Trust Anchor: " + this.getTrustAnchor().toString() + "\n");
        stringBuffer.append("  Policy Tree: " + String.valueOf(this.getPolicyTree()) + "\n");
        stringBuffer.append("  Subject Public Key: " + this.getPublicKey() + "\n");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

