void verticalStripes(float centerX, float centerY, float w, float h, int stripes, float stripeWidthProportion) {
  float x1 = centerX - w/2;
  float y1 = centerY - h/2;
  
  float totalWidth = h;
  float stripeAndSpacingWidth = totalWidth / ((stripes-1) + stripeWidthProportion);
  float stripeWidth = stripeAndSpacingWidth * stripeWidthProportion;
  
  for (int i = 0; i < stripes; i++) {
    float x_ = x1;
    float y_ = y1 + i*stripeAndSpacingWidth;
    handDrawn.rect(x_, y_, w, stripeWidth);
  }
}
  
void horizontalStripes(float centerX, float centerY, float w, float h, int stripes, float stripeWidthProportion) {
  float x1 = centerX - w/2;
  float y1 = centerY - h/2;
  
  float totalWidth = w;
  float stripeAndSpacingWidth = totalWidth / ((stripes-1) + stripeWidthProportion);
  float stripeWidth = stripeAndSpacingWidth * stripeWidthProportion;
  
  for (int i = 0; i < stripes; i++) {
    float x_ = x1 + i*stripeAndSpacingWidth;
    float y_ = y1;
    handDrawn.rect(x_, y_, stripeWidth, h);
  }
}
