// Song: Untitled deep house (Repeat Beat - UK) by Lee Trax
// https://soundcloud.com/leetrax/lee-trax-untitled-deep-house

import moonlander.library.*;
import ddf.minim.*;

Moonlander moonlander;

int bpm = 125;

PFont font;
HandDrawnGraphics handDrawn;
float scale;
color bgColor, mainColor, textColor, highlightColor;

float baseDrawStepSize;

int numberOfHairs;
float noiseWeightForHairs, noiseSizeForHairs, hairStrokeWeightAvg, hairStrokeWeightVariance, circleRadius, plumScatterDiameter, flowerX, flowerY;
int beatDivided = 4;

void setup() {
  moonlander = Moonlander.initWithSoundtrack(this, "data/Lee Trax - Untitled deep house.mp3", bpm, beatDivided);
  
  //size(800, 450);
  fullScreen();
  //size(1280, 720);
  
  //pixelDensity(displayDensity());
  font = createFont("Open_Sans_Condensed/OpenSansCondensed-Light.ttf", 100);
  //baseDrawStepSize = height / 1000.0 * 5;
  baseDrawStepSize = 1000.0 / height;
  handDrawn = new HandDrawnGraphics(this.g, baseDrawStepSize);
  noiseDetail(9, 0.45);
  colorMode(HSB, 360, 100, 100, 100);
  moonlander.start();
}

void draw() {
  moonlander.update();
  float beat = (float) moonlander.getCurrentTime() * bpm/60;
  
  int scene = (int) moonlander.getValue("scene");

  handDrawn.drawStepSize = baseDrawStepSize * pow(2, (float) moonlander.getValue("draw step size ex"));

  bgColor = color(50, 5, 100);
  mainColor = color(20, 100, 20, 40);
  textColor = color(20, 100, 20, 75 * (float) moonlander.getValue("textOpacity"));
  highlightColor = color(350, 100, 80);
  
  
  numberOfHairs = (int) moonlander.getValue("plum count");
  noiseWeightForHairs = 1.8 * pow(2, (float) moonlander.getValue("plum hair noise weight"));
  noiseSizeForHairs = 400 * pow(2, (float) moonlander.getValue("plum hair noise size"));
  hairStrokeWeightAvg = 2 * pow(2, (float) moonlander.getValue("plum hair weight ex"));
  hairStrokeWeightVariance = 1.5;
  circleRadius = 12.0 * pow(2, (float) moonlander.getValue("plum radius ex"));
  plumScatterDiameter = 1000.0 * pow(2, (float) moonlander.getValue("plum scatter diameter ex"));
  flowerX = 320 + (float) moonlander.getValue("plum center x");
  flowerY = 80;
  noiseSeed((int) moonlander.getValue("noise seed"));
  
  int stripeAreas = (int) moonlander.getValue("stripe areas");
  float stripeAvgX = (float) moonlander.getValue("stripe x avg");
  float stripeVarX = (float) moonlander.getValue("stripe x variance");
  float stripeAvgY = (float) moonlander.getValue("stripe y avg");
  float stripeVarY = (float) moonlander.getValue("stripe y variance");
  float stripeAvgW = (float) moonlander.getValue("stripe w avg");
  float stripeVarW = (float) moonlander.getValue("stripe w variance");
  float stripeAvgH = (float) moonlander.getValue("stripe h avg");
  float stripeVarH = (float) moonlander.getValue("stripe h variance");
  float pSpeed = (float) moonlander.getValue("stripe p speed");
  int maxStripes = (int) moonlander.getValue("stripe max n");
  handDrawn.noiseWeight = (float) moonlander.getValue("noise weight");
  handDrawn.noiseSize = exp((float) moonlander.getValue("noise size"));
  
  background(50, 5, 100);
  
  translate(width/2, height/2);
  scale(height/850.0);

  rectMode(CENTER);
  textAlign(CENTER, CENTER);

  handDrawn.noiseZ = beat / 20.0;
  
  
  
  // flower
  if (scene == 0 || scene >= 4) {
    drawFlower();
    
    fill(textColor);
    
    if (scene == 0) {
      textFont(font, 150);
      text("A lifeform?", -450, -200, 550, 500);
    }
    
    if (scene == 4) {
      textAlign(LEFT, CENTER);
      textFont(font, 100);
      textLeading(120);
      text("Feeling lonely sometimes?", -300, -200, 550, 500);
    }
    
    if (scene == 5) {
      textAlign(LEFT, CENTER);
      textFont(font, 100);
      textLeading(120);
      text("Hey, you are not alone!", -300, -200, 550, 500);
    }
    
    if (scene >= 6) {
      float step = beat * beatDivided;
      println("step", step);
      textAlign(LEFT, CENTER);
      textFont(font, 100);
      textLeading(120);
      
      if (scene == 6) {
        text("Magic shapes?", -300, -280, 550, 500);
      }
      if (scene == 7) {
        text("Nah.", -300, -100, 550, 500);
      }
      if (scene == 8) {
        text("Just noise", 400, 230, 550, 500);
      }
      if (scene == 9) {
        textAlign(LEFT, TOP);

        float w = 650;
        float y = 50;
        if (step < 88*8) {
          text("Greetings to\nKen Perlin", 350, y, w, 500);
        } else if (step < 89*8) {
          text("Greetings to\nDemoscene newbies", 350, y, w, 500);
        } else if (step < 90*8) {
          text("Greetings to\nDemoscene veterans", 350, y, w, 500);
        } else if (step < 91*8) {
          text("Greetings to\nDemoscene not-sure-which's", 350, y, w, 500);
        } else if (step < 92*8) {
          text("Greetings to\nGraffathon organizers", 350, y, w, 500);
        } else if (step < 93*8) {
          text("Greetings to\nNoise enthusiasts", 350, y, w, 500);
        } else if (step < 94*8) {
          text("Greetings to\nAlgorithmic artists", 350, y, w, 500);
        } else if (step < 95*8) {
          text("Greetings to\nyou", 350, y, w, 500);
        }
      }
    }
  }
  
  
  // stripes
  if (scene == 1) {
    handDrawn.noiseZ = beat / 20.0;
    
    handDrawn.noiseWeight(0.78);
    handDrawn.noiseSize(19);
    
    noStroke();
    for (int i = 0; i < stripeAreas; i++) {
      float x = stripeAvgX + (noise(i, 2)-0.5) * stripeVarX; // 2500
      float y = stripeAvgY + (noise(i, 3)-0.5) * stripeVarY; // 1500
      float w = stripeAvgW + (noise(i, 4, beat/10+0.5)-0.5) * stripeVarW; // 2000
      float h = stripeAvgH + (noise(i, 5, beat/10)-0.5) * stripeVarH; // 2000
      int n = round(maxStripes * noise(i, 5, int(beat)/2));
      float p = noise(i, 1, int(beat) * pSpeed);
  
      if (p > 0.3) {
        fill(0, 0, 5);
      } else {
        fill(340, 100, 80);
      }
  
      if (noise(i, 0, beat/2) < 0.5) {
        horizontalStripes(x, y, w, h, n, p);
      } else {
        verticalStripes(x, y, w, h, n, p);
      } 
    }
  }
  
  // halftone / ensing titles
  if (scene == 2 || scene == 3) {
    noStroke();
    
    pushMatrix();
    rotate(TAU/8);
    int n = 100;
    float noiseSize = 5;
    noiseDetail(9, 0.5);
    float bias = 0.7*sin(beat*TAU/32);
    float noiseZ = bias;
    for (int i = 0; i < n; i++) {
      for (int j = 0; j < n; j++) {
        fill(0, 0, 5);
        
        pushMatrix();
        float d = 3000/n * max(0, (noise(i/noiseSize, j/noiseSize, noiseZ) + map(n+i-j, 0, 2*n, -1, 1)+bias));
        float x = map(i, 0, n, -1000, 1000);
        float y = map(j, 0, n, -1000, 1000);
        ellipse(x, y, d, d);
        popMatrix();
      }
    }
    popMatrix();
    
    textFont(font, 100);
    textLeading(120);
      textAlign(LEFT, CENTER);

    if (scene == 2) {
      textColor = color(50, 5, 100, 100 * (float) moonlander.getValue("textOpacity"));
      fill(textColor);
      text("Noise Demonstration by Bad Felix", 350, -30, 700, 500);
      
    } else {
      textColor = color(20, 100, 20, 100 * (float) moonlander.getValue("textOpacity"));
      fill(textColor);
      text("Made at Graffathon 2018", -320, -120, 700, 500);
      
      textFont(font, 50);
      textLeading(60);

      text("Music: Untitled deep house (Repeat Beat - UK) by Lee Trax", -420, 220, 500, 500);
    }
  }
  
  if (scene == -1) {
    exit();
  }
}

void drawFlower() {
    // float noiseWeight = (float) moonlander.getValue("noise weight");  

  pushMatrix();
  handDrawn.noiseWeight(1.8);
  handDrawn.noiseSize(400);
  float cdx = handDrawn.getNoiseShiftXAt(0, 0);
  float cdy = handDrawn.getNoiseShiftYAt(0, 0);
  translate(flowerX - cdx/2, flowerY - cdy/2);

  // plums
  for (int i = 0; i < numberOfHairs; i++) {
    float x = plumScatterDiameter * (noise(i, 0)-0.5);
    float y = plumScatterDiameter * (noise(i, 1)-0.5);
    
    handDrawn.noiseWeight(noiseWeightForHairs);
    handDrawn.noiseSize(noiseSizeForHairs);
    float dx = handDrawn.getNoiseShiftXAt(x, y);
    float dy = handDrawn.getNoiseShiftYAt(x, y);
    handDrawn.noiseWeight(0.78);
    handDrawn.noiseSize(19);
    fill(highlightColor);
    noStroke();
    handDrawn.circle(x+dx, y+dy, circleRadius);
  }
  
  // lines
  for (int i = 0; i < numberOfHairs; i++) {
    float x = plumScatterDiameter * (noise(i, 0)-0.5);
    float y = plumScatterDiameter * (noise(i, 1)-0.5);
        
    handDrawn.noiseWeight(noiseWeightForHairs);
    handDrawn.noiseSize(noiseSizeForHairs);
    noFill();
    stroke(mainColor);
    strokeWeight(hairStrokeWeightAvg + hairStrokeWeightVariance*(noise(i*32)*2 - 1));
    handDrawn.line(0, 0, x, y);
  }
  
  popMatrix();
}
