/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.signals;

import ddf.minim.AudioListener;
import ddf.minim.AudioSignal;
import ddf.minim.Minim;

public abstract class Oscillator
implements AudioSignal {
    protected static final float TWO_PI = (float)Math.PI * 2;
    private float freq;
    private float newFreq;
    private float srate;
    private float amp;
    private float newAmp;
    private float step;
    private float stepSize;
    private boolean port;
    private float portSpeed;
    private float portStep;
    private float pan;
    private float newPan;
    private float leftScale;
    private float rightScale;
    private AudioListener listener;
    private AudioSignal ampMod;
    private AudioSignal freqMod;
    private static float panAmpStep = 1.0E-4f;

    public Oscillator(float frequency, float amplitude, float sampleRate) {
        this.newFreq = this.freq = frequency;
        this.newAmp = this.amp = amplitude;
        this.srate = sampleRate;
        this.step = 0.0f;
        this.stepSize = this.freq / sampleRate;
        this.port = false;
        this.portStep = 0.01f;
        this.pan = 0.0f;
        this.newPan = 0.0f;
        this.rightScale = 1.0f;
        this.leftScale = 1.0f;
        this.listener = null;
        this.ampMod = null;
        this.freqMod = null;
    }

    public final float sampleRate() {
        return this.srate;
    }

    public final void setFreq(float f) {
        this.newFreq = f;
        float msStep = (this.newFreq - this.freq) / this.portSpeed;
        float spms = this.srate / 1000.0f;
        this.portStep = msStep / spms;
    }

    public final float frequency() {
        return this.freq;
    }

    public final void setAmp(float a) {
        this.newAmp = this.constrain(a, 0.0f, 1.0f);
    }

    public final float amplitude() {
        return this.amp;
    }

    public final void setPan(float p) {
        this.newPan = this.constrain(p, -1.0f, 1.0f);
    }

    public final void setPanNoGlide(float p) {
        this.setPan(p);
        this.pan = this.constrain(p, -1.0f, 1.0f);
    }

    public final float pan() {
        return this.pan;
    }

    public final void portamento(int millis) {
        if (millis <= 0) {
            Minim.error("Oscillator.portamento: The portamento speed must be greater than zero.");
        }
        this.port = true;
        this.portSpeed = millis;
    }

    public final void noPortamento() {
        this.port = false;
    }

    private final void updateFreq() {
        if (this.freq != this.newFreq) {
            this.freq = this.port ? (Math.abs(this.freq - this.newFreq) < 0.1f ? this.newFreq : (this.freq += this.portStep)) : this.newFreq;
        }
        this.stepSize = this.freq / this.srate;
    }

    private final float generate(float fmod, float amod) {
        this.step += fmod;
        this.step -= (float)Math.floor(this.step);
        return this.amp * amod * this.value(this.step);
    }

    @Override
    public final void generate(float[] signal) {
        float[] fmod = new float[signal.length];
        float[] amod = new float[signal.length];
        if (this.freqMod != null) {
            this.freqMod.generate(fmod);
        }
        if (this.ampMod != null) {
            this.ampMod.generate(amod);
        }
        for (int i = 0; i < signal.length; ++i) {
            this.updateFreq();
            signal[i] = this.ampMod != null ? this.generate(fmod[i], amod[i]) : this.generate(fmod[i], 1.0f);
            this.monoStep();
        }
        if (this.listener != null) {
            this.listener.samples(signal);
        }
    }

    @Override
    public final void generate(float[] left, float[] right) {
        float[] fmod = new float[left.length];
        float[] amod = new float[right.length];
        if (this.freqMod != null) {
            this.freqMod.generate(fmod);
        }
        if (this.ampMod != null) {
            this.ampMod.generate(amod);
        }
        int i = 0;
        while (i < left.length) {
            this.updateFreq();
            left[i] = this.ampMod != null ? this.generate(fmod[i], amod[i]) : this.generate(fmod[i], 1.0f);
            right[i] = left[i];
            int n = i;
            left[n] = left[n] * this.leftScale;
            int n2 = i++;
            right[n2] = right[n2] * this.rightScale;
            this.stereoStep();
        }
        if (this.listener != null) {
            this.listener.samples(left, right);
        }
    }

    public final void setAudioListener(AudioListener al) {
        this.listener = al;
    }

    final void setAmplitudeModulator(AudioSignal s) {
        this.ampMod = s;
    }

    final void setFrequencyModulator(AudioSignal s) {
        this.freqMod = s;
    }

    private void monoStep() {
        this.stepStep();
        this.stepAmp();
    }

    private void stereoStep() {
        this.stepStep();
        this.stepAmp();
        this.calcLRScale();
        this.stepPan();
    }

    private void stepStep() {
        this.step += this.stepSize;
        this.step -= (float)Math.floor(this.step);
    }

    private void calcLRScale() {
        if (this.pan <= 0.0f) {
            this.rightScale = this.pan + 1.0f;
            this.leftScale = 1.0f;
        }
        if (this.pan >= 0.0f) {
            this.leftScale = 1.0f - this.pan;
            this.rightScale = 1.0f;
        }
        if (this.pan == 0.0f) {
            this.rightScale = 1.0f;
            this.leftScale = 1.0f;
        }
    }

    private void stepPan() {
        if (this.pan != this.newPan) {
            this.pan = this.pan < this.newPan ? (this.pan += panAmpStep) : (this.pan -= panAmpStep);
            if (Math.abs(this.pan - this.newPan) < panAmpStep) {
                this.pan = this.newPan;
            }
        }
    }

    private void stepAmp() {
        if (this.amp != this.newAmp) {
            this.amp = this.amp < this.newAmp ? (this.amp += panAmpStep) : (this.amp -= panAmpStep);
            if (Math.abs(this.amp - this.newAmp) < panAmpStep) {
                this.pan = this.newPan;
            }
        }
    }

    public final float period() {
        return 1.0f / this.freq;
    }

    protected abstract float value(float var1);

    float constrain(float val, float min, float max) {
        return val < min ? min : (val > max ? max : val);
    }
}

