/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import processing.core.PApplet;
import processing.sound.Engine;
import processing.sound.SoundObject;

public class Delay
implements SoundObject {
    PApplet parent;
    private Engine m_engine;
    private int[] m_nodeId = new int[]{-1, -1};
    private float m_maxDelayTime = 2.0f;
    private float m_delayTime = 0.0f;
    private float m_feedBack = 0.0f;

    public Delay(PApplet pApplet) {
        this.parent = pApplet;
        this.parent.registerMethod("dispose", (Object)this);
        Engine.setPreferences(pApplet, 512, 44100);
        Delay delay = this;
        delay.m_engine.start();
    }

    public void process(SoundObject soundObject, float f, float f2, float f3) {
        this.m_maxDelayTime = f;
        this.m_delayTime = f2;
        this.m_feedBack = f3;
        this.m_nodeId = Engine.delayPlay(soundObject.returnId(), this.m_maxDelayTime, this.m_delayTime, this.m_feedBack);
    }

    public void process(SoundObject soundObject, float f, float f2) {
        this.m_maxDelayTime = f;
        this.m_delayTime = f2;
        this.m_nodeId = Engine.delayPlay(soundObject.returnId(), this.m_maxDelayTime, this.m_delayTime, this.m_feedBack);
    }

    public void process(SoundObject soundObject, float f) {
        this.m_maxDelayTime = f;
        this.m_nodeId = Engine.delayPlay(soundObject.returnId(), this.m_maxDelayTime, this.m_delayTime, this.m_feedBack);
    }

    private void set() {
        if (this.m_nodeId[0] != -1) {
            Engine.delaySet(this.m_delayTime, this.m_feedBack, this.m_nodeId[0]);
        }
    }

    public void set(float f, float f2) {
        this.m_delayTime = f;
        this.m_feedBack = f2;
        this.set();
    }

    public void time(float f) {
        this.m_delayTime = f;
        this.set();
    }

    public void feedback(float f) {
        this.m_feedBack = f;
        this.set();
    }

    @Override
    public int[] returnId() {
        return this.m_nodeId;
    }

    public void stop() {
        if (this.m_nodeId[0] != -1) {
            Engine.synthStop(this.m_nodeId);
            for (int i = 0; i < this.m_nodeId.length; ++i) {
                this.m_nodeId[i] = -1;
            }
        }
    }

    public void dispose() {
        Engine.synthStop(this.m_nodeId);
    }
}

