class Pulse extends Drawable
{
	constructor(ctx, position, color, speed)
	{
        super(ctx, position, color);
        this.speed = speed;
        
        this.angle = 0;
        this.r = 255;
        this.g = 0;
        this.b = 0;
        this.rDirection = 0;
        this.gDirection = 1;
        this.bDirection = 0;
        this.oldTime = Date.now();
        this.firstTime = Date.now();
        this.TWO_PER_PI = 2.0 / Math.PI;
        this.circles = [];
        this.move = function(delta, time){};
        
        var _this = this;
        this.interval = setInterval(function(){_this.spawner()}, this.speed);
	}
    
    update()
    {
        var delta = Date.now() - this.oldTime;
        var time = Date.now() - this.firstTime;
        var _this = this;
        
        this.move(delta, time);
        
        this.circles.forEach(function(child){
			child.speed *= 0.975;
			child.radius *= 0.975;// ((_this.TWO_PER_PI * Math.asin(Math.sin(time * 0.0001))) + 1);
		});

        this.r += delta * this.rDirection;
        this.g += delta * this.gDirection;
        this.b += delta * this.bDirection;
        
        if(this.r > 255)   {this.r = 255;  this.rDirection = 0;    this.bDirection = -1;}
        if(this.r < 51)     {this.r = 51;    this.rDirection = 0;    this.bDirection = 1;}
        
        if(this.g > 255)   {this.g = 255;  this.gDirection = 0;    this.rDirection = -1;}
        if(this.g < 51)     {this.g = 51;    this.gDirection = 0;    this.rDirection = 1;}
        
        if(this.b > 255)   {this.b = 255;  this.bDirection = 0;    this.gDirection = -1;}
        if(this.b < 51)     {this.b = 51;    this.bDirection = 0;    this.gDirection = 1;}
        
        this.oldTime = Date.now();
    }
    
    destroy()
    {
        clearInterval(this.interval);
        var _this = this;
        
        //this.circles.forEach(function(child){
        //    _this.parent.remove(child);
        //});
    }
    
    spawner()
    {
        for(var i = 0; i < 360; i += 10)
        {
            var newCircle = new MyCircle(ctx, 0.2, new Vector(this.position.x, this.position.y),
                                         "RGBA(" + this.r + "," + this.g + "," + this.b + ",0.5)", i, 0.1);
            this.parent.add(newCircle);
            this.circles.push(newCircle);
        }
    }
}