class Drawable
{
    constructor(ctx, position, color)
    {
        this.ctx = ctx;
        this.position = position;
        this.scale = new Vector(1, 1);
		this.color = color;
		this.children = [];
    }
    
    update() {}
    
    _update()
    {
        this.update();
        
        this.children.forEach(function(child){
			child._update();
		});
    }
    
	draw()
    {
        for(var i = 0; i < this.children.length; i++)
        {
            this.children[i].draw();
        }
    }
	
	get globalPosition()
	{
        var x = this.position.x;
        var y = -this.position.y;
        var parent = this.parent;
        while(parent != null)
        {
            x *= parent.scale.x;
            y *= parent.scale.y;
            x += parent.position.x;
            y -= parent.position.y;
            parent = parent.parent;
        }
		return new Vector(x, y);
	}
	
	get globalScale()
	{
        var x = this.scale.x;
        var y = this.scale.y;
        
        var parent = this.parent;
        while(parent != null)
        {
            x *= parent.scale.x;
            y *= parent.scale.y;
            parent = parent.parent;
        }
		return new Vector(x, y);
	}
    
    addChild(child)
    {
        this.children.push(child);
        child.parent = this;
    }
    remove(object)
    {
        var i = this.children.indexOf(object);
        this.children.splice(i, 1);
    }
    
    destroy() {}
}

class Rectangle extends Drawable
{
    constructor(ctx, width, height, position, color)
    {
        super(ctx, position, color);
        this.width = width;
        this.height = height;
    }
    
    draw()
    {
		var position = this.globalPosition;
        position.x -= this.width / 2.0;
        position.y -= this.height / 2.0;
		this.ctx.fillStyle = this.color;
        this.ctx.fillRect(position.x, position.y, this.width, this.height);
        super.draw();
    }
}

class Circle extends Drawable
{
    constructor(ctx, radius, position, color)
    {
        super(ctx, position, color);
        this.radius = radius;
    }
    
    draw()
    {
		var position = this.globalPosition;
		this.ctx.beginPath();
        this.ctx.arc(position.x, position.y, this.radius * this.globalScale.y, 0, 2 * Math.PI);
		this.ctx.fillStyle = this.color;
		this.ctx.fill();
        super.draw();
    }
}

class Text extends Drawable
{
    constructor(ctx, text, position, color, font, horizontalAlign, verticalAlign)
    {
        super(ctx, position, color);
        this.text = text;
        this.font = font;
        this.horizontalAlign = horizontalAlign;
        this.verticalAlign = verticalAlign;
    }
    
    draw()
    {
		var position = this.globalPosition;
		ctx.font = this.font;
		ctx.textAlign = this.horizontalAlign;
		ctx.textBaseline = this.verticalAlign;
		this.ctx.fillStyle = this.color;
		ctx.fillText(this.text, position.x, position.y);
        super.draw();
    }
}