#version 330 core

// Ouput data



in vec2 UV;

uniform sampler2D myTextureSampler;
uniform vec3 object_color;
uniform vec3 light_color;

in vec3 FragPos;
in vec3 Normal;
out vec4 color;

uniform vec3 lightPos;
uniform vec3 viewPos;
uniform vec3 lightColor;
uniform vec3 objectColor;


void main()
{
	vec2 UVi = vec2(UV.x, UV.y); // Coord fix
	//color = texture( myTextureSampler, UVi ).rgb;
//	color = vec4(object_color * light_color , 1.0f);

	//Ambient
	float ambientStrength = 0.1f;
	vec3 ambient = ambientStrength * lightColor;

	//diffuse
	vec3 norm = normalize(Normal);
	vec3 lightDir = normalize(lightPos - FragPos);
	float diff = max(dot(norm, lightDir), 0.0);
	vec3 diffuse = diff * lightColor;

	// Specular 
     float specularStrength = 0.5f;
     vec3 viewDir = normalize(viewPos - FragPos);
     vec3 reflectDir = reflect(-lightDir, norm);
     float spec = pow(max(dot(viewDir, reflectDir), 0.0), 32);
     vec3 specular = specularStrength * spec * lightColor;

     vec3 result =  texture( myTextureSampler, UVi ).rgb;
     color = vec4(result, 1.0f);
	 
}