#!/usr/bin/env -S 64tass -o 'star.prg'

; Copyright (C) 2022 by Krill/Plush

; Permission to use, copy, modify, and/or distribute this software for any
; purpose with or without fee is hereby granted.

; THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
; REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
; AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
; INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
; LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
; OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
; PERFORMANCE OF THIS SOFTWARE.

BSOUT = $ffd2

            * = $032c ; CLALL vector, executed when closing loaded file

            ; 4 bytes header
           ;.word $032c
            .word entry

entry       ldx #16    ; row counter 16..0
            lda #$8d   ; CR, negative to signal next row upon pop
row         ldy #-10   ; column counter -10..8
column      iny        ; next column
            bpl right  ; if right-hand side of star, pop character from stack
            pha        ; otherwise push last printed character or CR to stack
            lda #' '*2 ; on carry set, set carry: ****.........**** for midchar
            cmp $e47a,x; magic ROM location with "*** COMMODORE 64 "
            rol left,x ; next character bit << table byte << middle column char
            bcs +      ; branch if carry set
            lda #'*'*2 ; on carry clear
+           lsr        ; normalise char to ' ' or '*'
            pha        ; push to counter pop in next opcode
right       pla        ; on right-hand side, pop character from stack
            jsr BSOUT  ; print *, space or CR
            bpl column ; branch on left-hand side or last column not yet reached
            dex        ; next row
            bpl row    ; branch until done
            rts        ; exit to BASIC

left        .byte %11110111; look-up table of lhs characters: 1 = ' ', 0 = '*'
            .byte %11110011; one byte per character row
            .byte %11110001
            .byte %11110000
            .byte %00000000
            .byte %10000000
            .byte %11000000
            .byte %11100000
            .byte %11110000
            .byte %11100000
            .byte %11000000
            .byte %10000000
            .byte %00000000
            .byte %11110000
            .byte %11110001
            .byte %11110011
            .byte %11110111
