"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.writeMetroConfig = writeMetroConfig;
exports.copyTemplateMetroConfig = copyTemplateMetroConfig;
var _chalk = _interopRequireDefault(require("chalk"));
var _fs = _interopRequireDefault(require("fs"));
var _path = _interopRequireDefault(require("path"));
var Log = _interopRequireWildcard(require("../log"));
var _errors = require("../utils/errors");
var _link = require("../utils/link");
var _ora = require("../utils/ora");
var _updatePackageJson = require("./updatePackageJson");
function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
        return obj;
    } else {
        var newObj = {};
        if (obj != null) {
            for(var key in obj){
                if (Object.prototype.hasOwnProperty.call(obj, key)) {
                    var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};
                    if (desc.get || desc.set) {
                        Object.defineProperty(newObj, key, desc);
                    } else {
                        newObj[key] = obj[key];
                    }
                }
            }
        }
        newObj.default = obj;
        return newObj;
    }
}
function writeMetroConfig(projectRoot, { pkg , templateDirectory  }) {
    /**
   * Add metro config, or warn if metro config already exists. The developer will need to add the
   * hashAssetFiles plugin manually.
   */ const updatingMetroConfigStep = (0, _ora).logNewSection("Adding Metro bundler config");
    try {
        const didChange = copyTemplateMetroConfig(projectRoot, {
            pkg,
            templateDirectory
        });
        if (!didChange) {
            // Nothing to change, hide the step and exit.
            updatingMetroConfigStep.stop();
            updatingMetroConfigStep.clear();
            return;
        }
        updatingMetroConfigStep.succeed("Added Metro config");
    } catch (error) {
        updatingMetroConfigStep.stopAndPersist({
            symbol: _chalk.default.yellow("\u203A"),
            text: _chalk.default.yellow(_chalk.default`{bold Metro skipped:} ${error.message}`)
        });
        // Log.log(`\u203A ${e.message}`);
        Log.log(_chalk.default`\u203A Ensure the project uses {bold expo/metro-config}.\n  {dim ${(0, _link).learnMore("https://docs.expo.dev/guides/customizing-metro")}}`);
    }
}
function copyTemplateMetroConfig(projectRoot, { pkg , templateDirectory  }) {
    const sourceConfigPath = _path.default.join(templateDirectory, "metro.config.js");
    const targetConfigPath = _path.default.join(projectRoot, "metro.config.js");
    const targetConfigPathExists = _fs.default.existsSync(targetConfigPath);
    if (targetConfigPathExists) {
        // Prevent re-runs from throwing an error if the metro config hasn't been modified.
        const contents = (0, _updatePackageJson).createFileHash(_fs.default.readFileSync(targetConfigPath, "utf8"));
        const targetContents = (0, _updatePackageJson).createFileHash(_fs.default.readFileSync(sourceConfigPath, "utf8"));
        if (contents !== targetContents) {
            throw new _errors.CommandError("Project metro.config.js does not match prebuild template.");
        }
        return false;
    }
    // We don't support legacy file names so just throw.
    if (_fs.default.existsSync(_path.default.join(projectRoot, "metro.config.json")) || pkg.metro || _fs.default.existsSync(_path.default.join(projectRoot, "rn-cli.config.js"))) {
        throw new _errors.CommandError("Project is using a legacy config system that cannot be extend automatically.");
    }
    // Finally, copy if nothing goes wrong.
    _fs.default.copyFileSync(sourceConfigPath, targetConfigPath);
    return true;
}

//# sourceMappingURL=writeMetroConfig.js.map