"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.isInspectorProxyRequest = isInspectorProxyRequest;
var _resolvePlatform = require("./resolvePlatform");
const debug = require("debug")("expo:start:server:metro:historyFallback");
const WS_DEVICE_URL = "/inspector/device";
const WS_DEBUGGER_URL = "/inspector/debug";
const PAGES_LIST_JSON_URL = "/json";
const PAGES_LIST_JSON_URL_2 = "/json/list";
const PAGES_LIST_JSON_VERSION_URL = "/json/version";
function isInspectorProxyRequest(req) {
    const ua = req.headers["user-agent"];
    const url = req.url;
    // This check is very fragile but it enables websites to use any of the
    // endpoints below without triggering the inspector proxy.
    if (!url || ua && !ua.includes("node-fetch")) {
        // This optimizes for the inspector working over the endpoint being available on web.
        // Web is less fragile.
        return false;
    }
    return [
        WS_DEVICE_URL,
        WS_DEBUGGER_URL,
        PAGES_LIST_JSON_URL,
        PAGES_LIST_JSON_URL_2,
        PAGES_LIST_JSON_VERSION_URL, 
    ].includes(url);
}
class HistoryFallbackMiddleware {
    constructor(indexMiddleware){
        this.indexMiddleware = indexMiddleware;
    }
    getHandler() {
        return (req, res, next)=>{
            const platform = (0, _resolvePlatform).parsePlatformHeader(req);
            if (!platform || platform === "web") {
                if (isInspectorProxyRequest(req)) {
                    debug("Inspector proxy request:", req.url, "UA:", req.headers["user-agent"]);
                    return next();
                }
                // Redirect unknown to the manifest handler while preserving the path.
                // This implements the HTML5 history fallback API.
                return this.indexMiddleware(req, res, next);
            }
            return next();
        };
    }
}
exports.HistoryFallbackMiddleware = HistoryFallbackMiddleware;

//# sourceMappingURL=HistoryFallbackMiddleware.js.map