"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JS_ENGINE_PROP_KEY = exports.DEFAULT_JS_ENGINE = void 0;
exports.getJsEngine = getJsEngine;
exports.setJsEngine = setJsEngine;
exports.withJsEngineGradleProps = void 0;

function _androidPlugins() {
  const data = require("../plugins/android-plugins");

  _androidPlugins = function () {
    return data;
  };

  return data;
}

const JS_ENGINE_PROP_KEY = 'expo.jsEngine';
exports.JS_ENGINE_PROP_KEY = JS_ENGINE_PROP_KEY;
const DEFAULT_JS_ENGINE = 'jsc';
exports.DEFAULT_JS_ENGINE = DEFAULT_JS_ENGINE;

const withJsEngineGradleProps = config => {
  return (0, _androidPlugins().withGradleProperties)(config, config => {
    config.modResults = setJsEngine(config, config.modResults);
    return config;
  });
};

exports.withJsEngineGradleProps = withJsEngineGradleProps;

function getJsEngine(config) {
  var _ref, _config$android$jsEng, _config$android;

  return (_ref = (_config$android$jsEng = (_config$android = config.android) === null || _config$android === void 0 ? void 0 : _config$android.jsEngine) !== null && _config$android$jsEng !== void 0 ? _config$android$jsEng : config.jsEngine) !== null && _ref !== void 0 ? _ref : DEFAULT_JS_ENGINE;
}

function setJsEngine(config, gradleProperties) {
  var _ref2, _config$android$jsEng2, _config$android2;

  const oldPropIndex = gradleProperties.findIndex(prop => prop.type === 'property' && prop.key === JS_ENGINE_PROP_KEY);
  const newProp = {
    type: 'property',
    key: JS_ENGINE_PROP_KEY,
    value: (_ref2 = (_config$android$jsEng2 = (_config$android2 = config.android) === null || _config$android2 === void 0 ? void 0 : _config$android2.jsEngine) !== null && _config$android$jsEng2 !== void 0 ? _config$android$jsEng2 : config.jsEngine) !== null && _ref2 !== void 0 ? _ref2 : DEFAULT_JS_ENGINE
  };

  if (oldPropIndex >= 0) {
    gradleProperties[oldPropIndex] = newProp;
  } else {
    gradleProperties.push(newProp);
  }

  return gradleProperties;
}
//# sourceMappingURL=JsEngine.js.map