import { GraphQLError } from 'graphql';
import { Exchange } from '../types';
export interface SerializedResult {
    hasNext?: boolean;
    data?: string | undefined;
    extensions?: string | undefined;
    error?: {
        graphQLErrors: Array<Partial<GraphQLError> | string>;
        networkError?: string;
    };
}
export interface SSRData {
    [key: string]: SerializedResult;
}
export interface SSRExchangeParams {
    isClient?: boolean;
    initialState?: SSRData;
    staleWhileRevalidate?: boolean;
    includeExtensions?: boolean;
}
export interface SSRExchange extends Exchange {
    /** Rehydrates cached data */
    restoreData(data: SSRData): void;
    /** Extracts cached data */
    extractData(): SSRData;
}
/** The ssrExchange can be created to capture data during SSR and also to rehydrate it on the client */
export declare const ssrExchange: (params?: SSRExchangeParams | undefined) => SSRExchange;
