//
//Source code for SpikeOn&On 1K intro by Rudi/Darklite, released at Lovebyte,
//a demoparty sizecoding event held in Cyberspace on February 2024."
//

#include "Nebula.h"

BYTE heightmap[256 * 256];
BYTE sphericalMap[256 * 256];

#define SPHEREMAP 0.02454369260617025967546875  //mul
#define ANGLE_FACTOR 40.74366543152505956868525755869

int WINAPI WinMainCRTStartup(_In_ HINSTANCE hInstance, _In_opt_ HINSTANCE hPrevInstance, _In_ LPSTR lpCmdLine, _In_ int nShowCmd)
{
    InitGraphicsDCBitmap

    for (long i = 65536; i >= 0; --i) heightmap[i] = 128 + 127 * sin(0.1 * (i & 255)) * sin(0.1 * double(i >> 8));
    MIDIOpen, MIDIInstrument(0, 97);
    Loop
    {
        //Sculpted for size optimization:
        BYTE xi = 0;
        static BYTE yOld;
        for (DWORD p = S_1; xi++, p--;)
        {
            double fx = long(p & WIDTHMASK) - HALFWIDTH;
            double fy = long(p >> WIDTHLOG2) - HALFHEIGHT;
            BYTE dist = 255 - BYTE(sqrt(ASPECT_SQR * (SQR(fx) + SQR(fy))));
            BYTE angle = BYTE(atan2(fy, fx) * ANGLE_FACTOR);
            long x = p >> 8; // Extract x from p

            //Beregning av sfærisk kart:        
            BYTE height = heightmap[BYTE(cos(x * SPHEREMAP) * xi) | BYTE(sin(x * SPHEREMAP) * xi + itime) << 8];
            for (yOld = !xi ? 255 : yOld; yOld >= 255 - (xi * height >> 8); yOld--) sphericalMap[x + (yOld << 8)] = height;

            //Tegne voksel (klump)
            BYTE c = sphericalMap[angle + (dist << 8)];
            pixel[p] = RGB32(c ^ dist, c + dist, c - dist); // blue and yellow
        }
        if (!(itime & 0x03))
        {
            if (yOld >> 3 & 1)  midiOutShortMsg(hMidiOut, 0x7f2499);        //kickdrum
            if (yOld >> 5 & 1)  midiOutShortMsg(hMidiOut, 0x7f2a99);        //hihat
            if (!(yOld & 0x1f)) midiOutShortMsg(hMidiOut, 0x7f2899);        //snare
        }
        if (itime == 0x10) midiOutShortMsg(hMidiOut, 0x2590), midiOutShortMsg(hMidiOut, 0x7f2c90); else
        if (itime == 0x50) midiOutShortMsg(hMidiOut, 0x2c90), midiOutShortMsg(hMidiOut, 0x7f2a90); else
        if (itime == 0x90) midiOutShortMsg(hMidiOut, 0x2a90), midiOutShortMsg(hMidiOut, 0x7f2390); else
        if (itime == 0xd0) midiOutShortMsg(hMidiOut, 0x2390), midiOutShortMsg(hMidiOut, 0x7f2590);
        RenderToContext(pixel, 1-FULLSCREEN), Delay
    }
    ExitProcess(0);
}

// My initial voxel routine, dating back to 2012 during the creation of the Pluto 128-byte intro,
// featured a simple voxel-landscape algorithm. Incorporating polar coordinates for the tunnel and blob was a
// straightforward task. The first voxel-blob routine had two loops, while the later version for this intro
// contains only one, which contributes to its slower performance.

// Resolution for this intro: 512x384 32bit color.
// It generates a heightmap and a spherical map.
// The spherical map is generated within the same loop as the voxel-renderer.
// The rendering involves calculating pixel colors based on polar coordinates and height information.
// MIDI messages are sent based on certain conditions.
// The RenderToContext macro performs the StretchDIBits operation.

// Enjoy coding your tiny intros!
