; Commodore C64 post-challenge entry for VCCC2024 by GeirS, 2025-05-24.
; Size: 42 bytes excl. load address. Assemble using 64tass.
; Requires loading at specific address (e.g. LOAD "PRESENT",8,1) and SYS 2091 to start.

StrOut          = $ab1e             ; Print null-terminated string pointed to by A and Y
NewLine         = $aad7             ; Print new line char
BoxChars        = $fd8d             ; Contains values 32 and 45
EorValues       = $b91e             ; Contains values 1 and 6
Pnt             = $d1               ; Pointer to current screen line
Pntr            = $d3               ; Cursor column on current line
Every9thRow     = $2b               ; Variable for determining every 9th row (1 at startup)
Every9thCol     = $b0               ; Variable for determining every 9th column (0 at startup)

                * = $082a           ; Load address

; Code and data (42 bytes)
                .byte $cd           ; '\'
Start           sre @w $002f        ; Will set acc. to $2a (also: 'O', '/', 0)
                ldy #$08            ; Column number and hi byte of address of ribbon chars
                sty Pntr            ; Set cursor column
                jsr StrOut          ; Print ribbon (chars at $082a)
RowLoop         txa
                lsr                 ; Set carry flag to 9th bit of Every9thRow
                ror Every9thRow
                rol
                tax                 ; Index to 'BoxChars'
                jsr NewLine         ; Print new line char
                sec
                .byte $ac           ; Opcode for 'ldy $b076' (will set y to 18)
ColLoop         ror Every9thCol,x   ; Skipped on first loop iteration due to 'ldy' above
                lda BoxChars,x      ; Get space or '-'
                bcc PutChar         ; Branch if not 0th, 9th or 18th column
                eor EorValues,x     ; Change space to '!' or '-' to '+'
PutChar         sta (Pnt),y         ; Put char on screen
                dey
                bpl ColLoop         ; Loop for all columns
                asl $46,x           ; Contains word $2400 at startup
                bcc RowLoop         ; Loop for all rows
                rts
