#version 450 core
    out vec4 FragColor;
    in vec2 coord;
    uniform float width;
    uniform float height;
    uniform float iTime;




float a1(float a, float b, float q, float t)
{
    return cos(a)*cos(b)*tan(cos(t)) + (cos(a)*sin(b)*sin(q) - sin(a)*cos(q))*tan(sin(t));
}


float a2(float a, float b, float q, float t)
{
    return sin(a)*cos(b)*tan(cos(t)) + (sin(a)*sin(b)*sin(q) + cos(a)*cos(q))*tan(sin(t));
}

float a3(float a, float b, float q, float t)
{
    return -tan(cos(t))*sin(b) + tan(sin(t))*cos(b)*sin(q);
}



vec2 pos2f(float i, float t){
    return 0.5*vec2(tan(cos(i)) * cos(t) - tan(sin(i)) * sin(t),tan(cos(i)) * sin(t) + tan(sin(i)) * cos(t));


}


vec2 poscf(float i, float t)
{
    return 0.05*(vec2(a3(0.0,0.5,i,t*i),a1(1.0,i,0.5,i*t)*a2(0.0,0.0,t,t*i)) + 1.0/t*vec2(0.25,-0.5));
}


vec2 pos1f(float i, float t,float r1,float r2,float r3)
{
    return r1*vec2(t/r2*a1(t,i/r3,i,t),t/r2*a2(t,0.0,i,t));
}

vec2 posf(float i, float t)
{
    return 0.5*vec2(a1(t,0.0,i,t*i),a2(t,0.0,i,t*i));
}



vec2 tex0f(float t){
    return 5.*vec2(fract(100.0*sin(t))+cos(t)/10.*sin(t),exp(-t+1.0)+cos(t)/10.*cos(t));


}

vec2 pos0dd(float i, float t)
{
    return vec2(i*tan(cos(t*i)),i*tan(sin(t*i))) + (0.5,-0.75)*1.0/t;


}

float tr(float d, float start, float end)
{
    return (atan(34.*d - 34.*start) + 3.14159/2.0)/3.14159 * (atan((-1.0)*(34.*d - 34.*end)) + 3.14159/2.0)/3.14159;
}

void main()
{
/*         vec2 uv = coord;
    uv.y *= aspect;
    
    FragColor = vec4(width/2.0, height/2.0, 0.0, 1.0f); */

    //aspect = width/height * height

    // Normalized pixel coordinates (from 0 to 1)


    vec2 uv = vec2(2.0*coord.x,coord.y);


    float s=tr(iTime,79.,110.);
    uv =  uv*(1.0-s)+s*(fract(uv*(cos(iTime)*cos(iTime)+1.0))*2.-1.);

    //Time varying pixel color
    //vec3 col = uv.xxx + vec3(0,1,1);
    //float d = sin(8. + iTime)/8.;

    vec3 canvas = vec3(0.0,0.0,0.0);
    
    //[0,13) stage 0 "spiral closeup"
    //[14,79) stages 1-1, 1-2, 1,3
    //[79,110) stage 2-0 "fract"
    //[110,140) stages 3-1, 3-2
    //[140,145) stage 4-1 "ending: spiral recedes"
    
    
    for(float i = 0.0; i <= 6.29; i = i+0.005)
    {   
        vec2 v = pos0dd  (i,iTime)*tr(iTime,0.,14.);
        v += cos(iTime*8.)*pos1f(i,iTime,0.05,10.,10.)*tr(iTime,10.,67.);
        v += sin(iTime/80.)*posf(i,iTime)*tr(iTime,13.,40.);
        v += pos1f(i,iTime,0.05,2.5,8.)*tr(iTime,25.,41.);
        v += posf(i,iTime)*tr(iTime,39.,66.);
        v += pos1f(i,iTime,0.01,3.,100.)*tr(iTime,67.,80.);
        v += posf(i,iTime-67.)*tr(iTime,67.,79.);
        v += posf(i,iTime)*tr(iTime,80.,109.);
        v += pos0dd(i,-iTime)*tr(iTime,110.,140.);
        //v += pos0dd(i,-iTime-132.)*tr(iTime,119.,125.);
        //v += pos1f(i,-iTime,0.025,2.0,8.)*tr(iTime,139.,145.);
        //v += pos0dd(i,-iTime+140.)*tr(iTime,145.,155.);
        canvas += vec3(cos(1.0+2.0*sin(iTime)),sin(iTime),cos(iTime+1.0))*(1.0-smoothstep(0.0,0.005,length(uv-v)));
    }
    
    
       
    

    // Output to screen
    FragColor = vec4(canvas,1.0);

}