
	org #8000

	;test code

begin

	ld hl,music_data
	call play
	ret
	
	
	
	;engine code

;SquatM by Shiru, 08'21 (minor mods for the original Squat 06'17)
;Squeeker like, just without the output value table
;4 channels of tone with different duty cycle
;sample drums, non-interrupting
;customizeable noise percussion, interrupting


;music data is all 16-bit words, first control then a few optional ones

;control word is PSSSSSSS DDDN4321, where P=percussion,S=speed, D=drum, N=noise mode, 4321=channels
;D triggers non-interruping sample drum
;P trigger
;if 1, channel 1 freq follows
;if 2, channel 2 freq follows
;if 3, channel 3 freq follows
;if 4, channel 4 freq follows
;if N, channel 4 mode follows, it is either #0000 (normal) or #04cb (noise)
;if P, percussion follows, LSB=volume, MSB=pitch



RLC_H=#04cb			;to enable noise mode
NOP_2=#0000			;to disable noise mode
RLC_HL=#06cb		;to enable sample reading
ADD_IX_IX=#29dd		;to disable sample reading


play

	di
	
	ld e,(hl)
	inc hl
	ld d,(hl)
	inc hl
	ld (pattern_ptr),de
	
	ld e,(hl)
	inc hl
	ld d,(hl)
	
	ld (loop_ptr),de

	dec hl
	ld (sample_list),hl
	
	ld hl,ADD_IX_IX
	ld (sample_read),hl
	ld hl,NOP_2					;normal mode
	ld (noise_mode),hl
	
	ld ix,0						;needs to be 0 to skip sample reading

	ld c,0
	exx
	ld de,#0808					;sample bit counter and reload value

play_loop

pattern_ptr=$+1
	ld sp,0
	
return_loop

	pop bc						;control word
								;B=duration of the row (0=loop)
								;C=flags DDDN4321 (Drum, Noise, 1-4 channel update)
	ld a,b
	or a
	jp nz,no_loop
	
loop_ptr=$+1
	ld sp,0
	
	jp return_loop
	
no_loop

	ld a,c
	
	rra
	jr nc,skip_note_0
	
	pop hl
	ld (ch0_add),hl
	
skip_note_0

	rra
	jr nc,skip_note_1

	pop hl
	ld (ch1_add),hl
	
skip_note_1

	rra
	jr nc,skip_note_2
	
	pop hl
	ld (ch2_add),hl
	
skip_note_2

	rra
	jr nc,skip_note_3
	
	pop hl
	ld (ch3_add),hl
	
skip_note_3

	rra
	jr nc,skip_mode_change
	
	pop hl						;nop:nop or rlc h
	ld (noise_mode),hl

skip_mode_change

	and 7
	jp z,skip_drum
	
sample_list=$+1
	ld hl,0						;sample_list-2
	add a,a
	add a,l
	ld l,a
	ld a,(hl)
	inc l
	ld h,(hl)
	ld l,a
	ld (sample_ptr),hl
	ld hl,RLC_HL
	ld (sample_read),hl

skip_drum

	bit 7,b						;check percussion flag
	jp z,skip_percussion

	res 7,b						;clear percussion flag

	ld (noise_bc),bc
	ld (noise_de),de

	pop hl						;read percussion parameters

	ld a,l						;noise volume
	ld (noise_volume),a
	ld b,h						;noise pitch
	ld c,h
	ld de,#2174					;utz's rand seed			
	exx
	ld bc,429					;noise duration, takes as long as inner sound loop

noise_loop

	exx							;4
	dec c						;4
	jr nz,noise_skip			;7/12
	ld c,b						;4
	add hl,de					;11
	rlc h						;8		utz's noise generator idea
	inc d						;4		improves randomness
	jp noise_next				;10
	
noise_skip

	jr $+2						;12
	jr $+2						;12
	nop							;4
	nop							;4
	
noise_next

	ld a,h						;4
	
noise_volume=$+1
	cp #80						;7
	sbc a,a						;4
	out (#fe),a					;11
	exx							;4

	dec bc						;6
	ld a,b						;4
	or c						;4
	jp nz,noise_loop			;10=106t

	exx

noise_bc=$+1
	ld bc,0
noise_de=$+1
	ld de,0



skip_percussion

	ld (pattern_ptr),sp

sample_ptr=$+1
	ld hl,0

sound_loop0

	ld c,64						;internal loop runs 64 times

sound_loop

sample_read=$
	rlc (hl)					;15 	rotate sample bits in place, rl (hl) or add ix,ix (dummy operation)
	sbc a,a						;4		sbc a,a to make bit into 0 or 255, or xor a to keep it 0

	dec e						;4--+	count bits
	jp z,sample_cycle			;10 |
	jp sample_next				;10

sample_cycle

	ld e,d						;4	|	reload counter
	inc hl						;6--+	advance pointer --24t

sample_next

	exx							;4		squeeker type unrolled code
	ld b,a						;4		sample mask
	xor a						;4
	
	ld sp,sound_list			;10
		
	pop de						;10		ch0_acc
	pop hl						;10		ch0_add
	add hl,de					;11
	rla							;4
	ld (ch0_acc),hl				;16
						
	pop de						;10		ch1_acc
	pop hl						;10		ch1_add
	add hl,de					;11
	rla							;4
	ld (ch1_acc),hl				;16
	
	pop de						;10		ch2_acc
	pop hl						;10		ch2_add
	add hl,de					;11
	rla							;4
	ld (ch2_acc),hl				;16

	pop de						;10		ch3_acc
	pop hl						;10		ch3_add
	add hl,de					;11
	
noise_mode=$
	ds 2,0						;8		rlc h for noise effects

	rla							;4
	ld (ch3_acc),hl				;16

	add a,c						;4		no table like in Squeeker, channels summed as is, for uneven 'volume'
	add a,#ff					;7
	sbc a,#ff					;7
	ld c,a						;4
	sbc a,a						;4

	or b						;4		mix sample
	
	out (#fe),a					;11
		
	exx							;4

	dec c						;4
	jp nz,sound_loop			;10=336t


	dec hl						;last byte of a 64 byte sample packet is #80 means it was the last packet
	ld a,(hl)
	inc hl
	cp #80
	jr nz,sample_no_stop

	ld hl,ADD_IX_IX
	ld (sample_read),hl			;disable sample reading

sample_no_stop

	djnz sound_loop0

	ld (sample_ptr),hl
	
	jp play_loop
	
	
		
;variables in the sound_list can't be reordered because of stack-based fetching

sound_list

ch0_add		dw 0
ch0_acc		dw 0
ch1_add		dw 0
ch1_acc		dw 0
ch2_add		dw 0
ch2_acc		dw 0
ch3_add		dw 0
ch3_acc		dw 0


;compiled music data

	align 2

music_data:
	dw .pattern
	dw .loop
;sample data

.sample_list:
	dw .sample_1
	dw .sample_2
	dw .sample_3
	dw .sample_4
	dw .sample_5
	dw .sample_6
	dw .sample_7
	align 256

	align 64/8

.sample_1:
	db 15,195,255,0,0,28,1,255
	db 255,160,0,0,0,0,0,5
	db 255,255,255,240,0,0,0,0
	db 1,255,255,255,240,0,0,0
	db 0,0,0,0,0,0,3,255
	db 255,224,0,195,255,248,0,0
	db 0,127,255,248,0,0,0,0
	db 0,15,255,255,255,254,0,0
	db 0,0,0,0,63,255,255,255
	db 224,0,0,0,0,0,7,255
	db 255,255,255,255,255,255,0,0
	db 0,0,0,0,0,0,0,128
.sample_2:
	db 59,96,32,0,223,159,128,0
	db 0,0,255,255,192,0,0,127
	db 248,0,4,30,240,13,3,255
	db 192,0,7,252,16,1,3,255
	db 192,0,0,255,112,11,119,176
	db 0,0,23,255,148,12,16,64
	db 19,125,11,87,0,0,0,143
	db 255,176,7,240,1,0,67,123
	db 120,0,48,192,105,194,63,129
	db 246,128,0,5,106,190,232,192
	db 0,6,184,79,200,6,144,0
	db 81,224,0,1,47,224,0,128
.sample_3:
	db 0,1,0,0,64,0,20,0
	db 1,0,136,0,0,0,0,0
	db 0,69,0,0,4,0,19,42
	db 0,0,0,0,0,0,0,128
.sample_4:
.sample_5:
.sample_6:
.sample_7:


.pattern:
.loop:
	dw #c3f,#15a,#568,#0,#0,NOP_2
	dw #c00
	dw #c01,#15a
	dw #c00
	dw #c03,#268,#568
	dw #c02,#0
	dw #c03,#15a,#568
	dw #c00
	dw #c21,#15a
	dw #c02,#0
	dw #c03,#15a,#568
	dw #c00
	dw #c03,#2b4,#0
	dw #c02,#0
	dw #c03,#15a,#568
	dw #c00
	dw #c23,#39b,#40c
	dw #c00
	dw #c01,#103
	dw #c00
	dw #c03,#103,#40c
	dw #c02,#0
	dw #c03,#1cd,#40c
	dw #c00
	dw #c21,#103
	dw #c02,#0
	dw #c03,#206,#40c
	dw #c00
	dw #c03,#103,#0
	dw #c02,#0
	dw #c03,#2b4,#40c
	dw #c00
	dw #c23,#15a,#568
	dw #c00
	dw #c01,#15a
	dw #c00
	dw #c03,#2b4,#568
	dw #c02,#0
	dw #c03,#268,#568
	dw #c00
	dw #c21,#15a
	dw #c02,#0
	dw #c03,#337,#568
	dw #c00
	dw #c03,#308,#0
	dw #c02,#0
	dw #c03,#15a,#568
	dw #c00
	dw #c23,#103,#40c
	dw #c00
	dw #c01,#103
	dw #c00
	dw #c03,#1cd,#40c
	dw #c02,#0
	dw #c03,#103,#40c
	dw #c00
	dw #c21,#2b4
	dw #c02,#0
	dw #c03,#103,#40c
	dw #c00
	dw #c03,#206,#0
	dw #c02,#0
	dw #c03,#103,#40c
	dw #c00
	dw #c27,#15a,#568,#0
	dw #c00
	dw #c01,#15a
	dw #c00
	dw #c03,#268,#568
	dw #c02,#0
	dw #c03,#15a,#568
	dw #c00
	dw #c41,#15a
	dw #c02,#0
	dw #c03,#15a,#568
	dw #c00
	dw #c03,#2b4,#0
	dw #c02,#0
	dw #c03,#15a,#568
	dw #c00
	dw #c23,#39b,#40c
	dw #c00
	dw #c01,#103
	dw #c00
	dw #c03,#103,#40c
	dw #c02,#0
	dw #c03,#1cd,#40c
	dw #c00
	dw #c41,#103
	dw #c02,#0
	dw #c03,#206,#40c
	dw #c00
	dw #c03,#103,#0
	dw #c02,#0
	dw #c03,#2b4,#40c
	dw #c00
	dw #c23,#15a,#568
	dw #c00
	dw #c01,#15a
	dw #c00
	dw #c03,#2b4,#568
	dw #c02,#0
	dw #c03,#268,#568
	dw #c00
	dw #c41,#15a
	dw #c02,#0
	dw #c03,#337,#568
	dw #c00
	dw #c03,#308,#0
	dw #c02,#0
	dw #c03,#15a,#568
	dw #c00
	dw #c23,#103,#40c
	dw #c00
	dw #c01,#103
	dw #c00
	dw #c03,#1cd,#40c
	dw #c02,#0
	dw #c03,#103,#40c
	dw #c00
	dw #c41,#2b4
	dw #c02,#0
	dw #c03,#103,#40c
	dw #c00
	dw #c43,#206,#0
	dw #c02,#0
	dw #c43,#103,#40c
	dw #c00
	dw #c27,#15a,#568,#819
	dw #c00
	dw #c01,#15a
	dw #c00
	dw #c63,#268,#568
	dw #c02,#0
	dw #c0b,#15a,#568,#809
	dw #c00
	dw #c45,#15a,#9a2
	dw #c02,#0
	dw #c07,#15a,#568,#895
	dw #c00
	dw #c67,#2b4,#0,#819
	dw #c02,#0
	dw #c0f,#15a,#568,#737,#992
	dw #c00
	dw #c2f,#39b,#40c,#737,#885
	dw #c04,#727
	dw #c0d,#103,#717,#809
	dw #c04,#6ff
	dw #c6f,#103,#40c,#819,#727
	dw #c02,#0
	dw #c0b,#1cd,#40c,#737
	dw #c08,#727
	dw #c49,#103,#717
	dw #c0a,#0,#6ff
	dw #c0b,#206,#40c,#809
	dw #c00
	dw #c63,#103,#0
	dw #c02,#0
	dw #c03,#2b4,#40c
	dw #c00
	dw #c27,#15a,#568,#819
	dw #c00
	dw #c01,#15a
	dw #c00
	dw #c67,#2b4,#568,#819
	dw #c02,#0
	dw #c0f,#268,#568,#9a2,#809
	dw #c00
	dw #c45,#15a,#819
	dw #c02,#0
	dw #c0f,#337,#568,#737,#809
	dw #c00
	dw #c6f,#308,#0,#66e,#992
	dw #c02,#0
	dw #c0b,#15a,#568,#809
	dw #c00
	dw #c2f,#103,#40c,#1033,#727
	dw #c04,#e6e
	dw #c0d,#103,#cdc,#65e
	dw #c04,#c23
	dw #c67,#1cd,#40c,#ad0
	dw #c06,#0,#9a2
	dw #c0f,#103,#40c,#895,#1023
	dw #c0c,#819,#e5e
	dw #c4d,#2b4,#819,#ccc
	dw #c0e,#0,#895,#c13
	dw #c0f,#103,#40c,#9a2,#ac0
	dw #c0c,#ad0,#992
	dw #c6f,#206,#0,#c23,#885
	dw #c0e,#0,#cdc,#809
	dw #c0f,#103,#40c,#e6e,#809
	dw #c0c,#1033,#885
	dw #c2f,#15a,#568,#1033,#992
	dw #c08,#ac0
	dw #c09,#15a,#c13
	dw #c08,#ccc
	dw #c6b,#268,#568,#e5e
	dw #c0a,#0,#1023
	dw #c0b,#15a,#568,#1023
	dw #c00
	dw #c41,#15a
	dw #c02,#0
	dw #c03,#15a,#568
	dw #c00
	dw #c63,#2b4,#0
	dw #c02,#0
	dw #c03,#15a,#568
	dw #c00
	dw #c27,#39b,#40c,#102b
	dw #c04,#1023
	dw #c05,#103,#101b
	dw #c04,#1013
	dw #c67,#103,#40c,#100b
	dw #c06,#0,#1003
	dw #c0f,#1cd,#40c,#ffb,#102b
	dw #c0c,#ff3,#1023
	dw #c4d,#103,#ffb,#101b
	dw #c0e,#0,#1003,#1013
	dw #c0f,#206,#40c,#100b,#100b
	dw #c0c,#1013,#1003
	dw #c6f,#103,#0,#101b,#ffb
	dw #c0e,#0,#1023,#ff3
	dw #c0f,#2b4,#40c,#102b,#ffb
	dw #c0c,#1033,#1003
	dw #c2f,#15a,#568,#819,#100b
	dw #c08,#1013
	dw #c09,#15a,#101b
	dw #c08,#1023
	dw #c6b,#2b4,#568,#102b
	dw #c0a,#0,#1023
	dw #c0b,#268,#568,#809
	dw #c00
	dw #c45,#15a,#809
	dw #c02,#0
	dw #c07,#337,#568,#7f1
	dw #c00
	dw #c67,#308,#0,#7d9
	dw #c02,#0
	dw #c0f,#15a,#568,#7f9,#809
	dw #c00
	dw #c2f,#103,#40c,#809,#809
	dw #c00
	dw #c0d,#103,#819,#809
	dw #c00
	dw #c6b,#1cd,#40c,#809
	dw #c02,#0
	dw #c0b,#103,#40c,#809
	dw #c00
	dw #c49,#2b4,#809
	dw #c02,#0
	dw #c03,#103,#40c
	dw #c00
	dw #c63,#206,#0
	dw #c02,#0
	dw #c03,#103,#40c
	dw #c00
	dw #c27,#15a,#568,#819
	dw #c00
	dw #c01,#15a
	dw #c00
	dw #c63,#268,#568
	dw #c02,#0
	dw #c0b,#15a,#568,#809
	dw #c00
	dw #c45,#15a,#9a2
	dw #c02,#0
	dw #c07,#15a,#568,#895
	dw #c00
	dw #c67,#2b4,#0,#819
	dw #c02,#0
	dw #c0f,#15a,#568,#737,#992
	dw #c00
	dw #c2f,#39b,#40c,#737,#885
	dw #c04,#727
	dw #c0d,#103,#717,#809
	dw #c04,#6ff
	dw #c6f,#103,#40c,#819,#727
	dw #c02,#0
	dw #c0b,#1cd,#40c,#737
	dw #c08,#727
	dw #c49,#103,#717
	dw #c0a,#0,#6ff
	dw #c0b,#206,#40c,#809
	dw #c00
	dw #c63,#103,#0
	dw #c02,#0
	dw #c03,#2b4,#40c
	dw #c00
	dw #c27,#15a,#568,#819
	dw #c00
	dw #c01,#15a
	dw #c00
	dw #c67,#2b4,#568,#819
	dw #c02,#0
	dw #c0f,#268,#568,#9a2,#809
	dw #c00
	dw #c45,#15a,#819
	dw #c02,#0
	dw #c0f,#337,#568,#737,#809
	dw #c00
	dw #c6f,#308,#0,#66e,#992
	dw #c02,#0
	dw #c0b,#15a,#568,#809
	dw #c00
	dw #c2f,#103,#40c,#1033,#727
	dw #c04,#e6e
	dw #c0d,#103,#cdc,#65e
	dw #c04,#c23
	dw #c67,#1cd,#40c,#ad0
	dw #c06,#0,#9a2
	dw #c0f,#103,#40c,#895,#1023
	dw #c0c,#819,#e5e
	dw #c4d,#2b4,#819,#ccc
	dw #c0e,#0,#895,#c13
	dw #c0f,#103,#40c,#9a2,#ac0
	dw #c0c,#ad0,#992
	dw #c6f,#206,#0,#c23,#885
	dw #c0e,#0,#cdc,#809
	dw #c0f,#103,#40c,#e6e,#809
	dw #c0c,#1033,#885
	dw #c2f,#15a,#568,#1033,#992
	dw #c08,#ac0
	dw #c09,#15a,#c13
	dw #c08,#ccc
	dw #c6b,#268,#568,#e5e
	dw #c0a,#0,#1023
	dw #c0b,#15a,#568,#1023
	dw #c00
	dw #c41,#15a
	dw #c02,#0
	dw #c03,#15a,#568
	dw #c00
	dw #c63,#2b4,#0
	dw #c02,#0
	dw #c03,#15a,#568
	dw #c00
	dw #c27,#39b,#40c,#102b
	dw #c04,#1023
	dw #c05,#103,#101b
	dw #c04,#1013
	dw #c67,#103,#40c,#100b
	dw #c06,#0,#1003
	dw #c0f,#1cd,#40c,#ffb,#102b
	dw #c0c,#ff3,#1023
	dw #c4d,#103,#ffb,#101b
	dw #c0e,#0,#1003,#1013
	dw #c0f,#206,#40c,#100b,#100b
	dw #c0c,#1013,#1003
	dw #c6f,#103,#0,#101b,#ffb
	dw #c0e,#0,#1023,#ff3
	dw #c0f,#2b4,#40c,#102b,#ffb
	dw #c0c,#1033,#1003
	dw #c2f,#15a,#568,#819,#100b
	dw #c08,#1013
	dw #c09,#15a,#101b
	dw #c08,#1023
	dw #c6b,#2b4,#568,#102b
	dw #c0a,#0,#1023
	dw #c0b,#268,#568,#809
	dw #c00
	dw #c45,#15a,#809
	dw #c02,#0
	dw #c07,#337,#568,#7f1
	dw #c00
	dw #c67,#308,#0,#7d9
	dw #c02,#0
	dw #c0f,#15a,#568,#7f9,#809
	dw #c00
	dw #c2f,#103,#40c,#809,#809
	dw #c00
	dw #c0d,#103,#819,#809
	dw #c00
	dw #c6b,#1cd,#40c,#809
	dw #c02,#0
	dw #c0b,#103,#40c,#809
	dw #c00
	dw #c49,#2b4,#809
	dw #c02,#0
	dw #c43,#103,#40c
	dw #c00
	dw #c23,#206,#0
	dw #c02,#0
	dw #c43,#103,#40c
	dw #c00
	dw #c2f,#15a,#568,#819,#0
	dw #c00
	dw #c0d,#15a,#ad0,#809
	dw #c00
	dw #c0f,#268,#568,#c23,#ac0
	dw #c02,#0
	dw #c0f,#15a,#568,#819,#c13
	dw #c00
	dw #c2d,#15a,#ad0,#809
	dw #c02,#0
	dw #c0f,#15a,#568,#c23,#ac0
	dw #c00
	dw #c0f,#2b4,#0,#819,#c13
	dw #c02,#0
	dw #c0f,#15a,#568,#ad0,#809
	dw #c00
	dw #c2f,#39b,#40c,#c23,#ac0
	dw #c00
	dw #c0d,#103,#819,#c13
	dw #c00
	dw #c0f,#103,#40c,#ad0,#809
	dw #c02,#0
	dw #c0f,#1cd,#40c,#c23,#ac0
	dw #c00
	dw #c2d,#103,#819,#c13
	dw #c02,#0
	dw #c0f,#206,#40c,#ad0,#809
	dw #c00
	dw #c0f,#103,#0,#c23,#ac0
	dw #c02,#0
	dw #c0f,#2b4,#40c,#819,#c13
	dw #c00
	dw #c2f,#15a,#568,#ad0,#809
	dw #c00
	dw #c0d,#15a,#cdc,#ac0
	dw #c00
	dw #c0f,#2b4,#568,#e6e,#ccc
	dw #c02,#0
	dw #c0f,#268,#568,#ad0,#e5e
	dw #c00
	dw #c2d,#15a,#cdc,#ac0
	dw #c02,#0
	dw #c0f,#337,#568,#e6e,#ccc
	dw #c00
	dw #c0f,#308,#0,#ad0,#e5e
	dw #c02,#0
	dw #c0f,#15a,#568,#cdc,#ac0
	dw #c00
	dw #c2f,#103,#40c,#e6e,#ccc
	dw #c00
	dw #c0d,#103,#ad0,#e5e
	dw #c00
	dw #c0f,#1cd,#40c,#cdc,#ac0
	dw #c02,#0
	dw #c0f,#103,#40c,#e6e,#ccc
	dw #c00
	dw #c2d,#2b4,#ad0,#e5e
	dw #c02,#0
	dw #c0f,#103,#40c,#cdc,#ac0
	dw #c00
	dw #c0f,#206,#0,#e6e,#ccc
	dw #c02,#0
	dw #c0f,#103,#40c,#ad0,#e5e
	dw #c00
	dw #c2f,#15a,#568,#819,#ac0
	dw #c00
	dw #c0d,#15a,#ad0,#809
	dw #c00
	dw #c0f,#268,#568,#c23,#ac0
	dw #c02,#0
	dw #c0f,#15a,#568,#819,#c13
	dw #c00
	dw #c4d,#15a,#ad0,#809
	dw #c02,#0
	dw #c0f,#15a,#568,#c23,#ac0
	dw #c00
	dw #c0f,#2b4,#0,#819,#c13
	dw #c02,#0
	dw #c0f,#15a,#568,#ad0,#809
	dw #c00
	dw #c2f,#39b,#40c,#c23,#ac0
	dw #c00
	dw #c0d,#103,#819,#c13
	dw #c00
	dw #c0f,#103,#40c,#ad0,#809
	dw #c02,#0
	dw #c0f,#1cd,#40c,#c23,#ac0
	dw #c00
	dw #c4d,#103,#819,#c13
	dw #c02,#0
	dw #c0f,#206,#40c,#ad0,#809
	dw #c00
	dw #c0f,#103,#0,#c23,#ac0
	dw #c02,#0
	dw #c0f,#2b4,#40c,#819,#c13
	dw #c00
	dw #c2f,#15a,#568,#ad0,#809
	dw #c00
	dw #c0d,#15a,#cdc,#ac0
	dw #c00
	dw #c0f,#2b4,#568,#e6e,#ccc
	dw #c02,#0
	dw #c0f,#268,#568,#ad0,#e5e
	dw #c00
	dw #c4d,#15a,#cdc,#ac0
	dw #c02,#0
	dw #c0f,#337,#568,#e6e,#ccc
	dw #c00
	dw #c0f,#308,#0,#ad0,#e5e
	dw #c02,#0
	dw #c0f,#15a,#568,#cdc,#ac0
	dw #c00
	dw #c2f,#103,#40c,#e6e,#ccc
	dw #c00
	dw #c0d,#103,#ad0,#e5e
	dw #c00
	dw #c0f,#1cd,#40c,#cdc,#ac0
	dw #c02,#0
	dw #c0f,#103,#40c,#e6e,#ccc
	dw #c00
	dw #c4d,#2b4,#ad0,#e5e
	dw #c02,#0
	dw #c0d,#0,#0,#ac0
	dw #c00
	dw #c08,#0
	dw #c00
	dw #c20
	dw #c20
	dw #c27,#184,#611,#917
	dw #c00
	dw #c01,#184
	dw #c00
	dw #c63,#2b4,#611
	dw #c02,#0
	dw #c0b,#184,#611,#907
	dw #c00
	dw #c45,#184,#ad0
	dw #c02,#0
	dw #c07,#184,#611,#9a2
	dw #c00
	dw #c67,#308,#0,#917
	dw #c02,#0
	dw #c0f,#184,#611,#819,#ac0
	dw #c00
	dw #c2f,#40c,#48b,#819,#992
	dw #c04,#809
	dw #c0d,#122,#7f9,#907
	dw #c04,#7e1
	dw #c6f,#122,#48b,#917,#809
	dw #c02,#0
	dw #c0b,#206,#48b,#819
	dw #c08,#809
	dw #c49,#122,#7f9
	dw #c0a,#0,#7e1
	dw #c0b,#245,#48b,#907
	dw #c00
	dw #c63,#122,#0
	dw #c02,#0
	dw #c03,#308,#48b
	dw #c00
	dw #c27,#184,#611,#917
	dw #c00
	dw #c01,#184
	dw #c00
	dw #c67,#308,#611,#917
	dw #c02,#0
	dw #c0f,#2b4,#611,#ad0,#907
	dw #c00
	dw #c45,#184,#917
	dw #c02,#0
	dw #c0f,#39b,#611,#819,#907
	dw #c00
	dw #c6f,#367,#0,#737,#ac0
	dw #c02,#0
	dw #c0b,#184,#611,#907
	dw #c00
	dw #c2f,#122,#48b,#122f,#809
	dw #c04,#1033
	dw #c0d,#122,#e6e,#727
	dw #c04,#d9f
	dw #c67,#206,#48b,#c23
	dw #c06,#0,#ad0
	dw #c0f,#122,#48b,#9a2,#121f
	dw #c0c,#917,#1023
	dw #c4d,#308,#917,#e5e
	dw #c0e,#0,#9a2,#d8f
	dw #c0f,#122,#48b,#ad0,#c13
	dw #c0c,#c23,#ac0
	dw #c6f,#245,#0,#d9f,#992
	dw #c0e,#0,#e6e,#907
	dw #c0f,#122,#48b,#1033,#907
	dw #c0c,#122f,#992
	dw #c2f,#184,#611,#122f,#ac0
	dw #c08,#c13
	dw #c09,#184,#d8f
	dw #c08,#e5e
	dw #c6b,#2b4,#611,#1023
	dw #c0a,#0,#121f
	dw #c0b,#184,#611,#121f
	dw #c00
	dw #c41,#184
	dw #c02,#0
	dw #c03,#184,#611
	dw #c00
	dw #c63,#308,#0
	dw #c02,#0
	dw #c03,#184,#611
	dw #c00
	dw #c27,#40c,#48b,#1227
	dw #c04,#121f
	dw #c05,#122,#1217
	dw #c04,#120f
	dw #c67,#122,#48b,#1207
	dw #c06,#0,#11ff
	dw #c0f,#206,#48b,#11f7,#1227
	dw #c0c,#11ef,#121f
	dw #c4d,#122,#11f7,#1217
	dw #c0e,#0,#11ff,#120f
	dw #c0f,#245,#48b,#1207,#1207
	dw #c0c,#120f,#11ff
	dw #c6f,#122,#0,#1217,#11f7
	dw #c0e,#0,#121f,#11ef
	dw #c0f,#308,#48b,#1227,#11f7
	dw #c0c,#122f,#11ff
	dw #c2f,#184,#611,#917,#1207
	dw #c08,#120f
	dw #c09,#184,#1217
	dw #c08,#121f
	dw #c6b,#308,#611,#1227
	dw #c0a,#0,#121f
	dw #c0b,#2b4,#611,#907
	dw #c00
	dw #c45,#184,#907
	dw #c02,#0
	dw #c07,#39b,#611,#8ef
	dw #c00
	dw #c67,#367,#0,#8d7
	dw #c02,#0
	dw #c0f,#184,#611,#8f7,#907
	dw #c00
	dw #c2f,#122,#48b,#907,#907
	dw #c00
	dw #c0d,#122,#917,#907
	dw #c00
	dw #c6b,#206,#48b,#907
	dw #c02,#0
	dw #c0b,#122,#48b,#907
	dw #c00
	dw #c49,#308,#907
	dw #c02,#0
	dw #c03,#122,#48b
	dw #c00
	dw #c63,#245,#0
	dw #c02,#0
	dw #c03,#122,#48b
	dw #c00
	dw #c27,#184,#611,#917
	dw #c00
	dw #c01,#184
	dw #c00
	dw #c63,#2b4,#611
	dw #c02,#0
	dw #c0b,#184,#611,#907
	dw #c00
	dw #c45,#184,#ad0
	dw #c02,#0
	dw #c07,#184,#611,#9a2
	dw #c00
	dw #c67,#308,#0,#917
	dw #c02,#0
	dw #c0f,#184,#611,#819,#ac0
	dw #c00
	dw #c2f,#40c,#48b,#819,#992
	dw #c04,#809
	dw #c0d,#122,#7f9,#907
	dw #c04,#7e1
	dw #c6f,#122,#48b,#917,#809
	dw #c02,#0
	dw #c0b,#206,#48b,#819
	dw #c08,#809
	dw #c49,#122,#7f9
	dw #c0a,#0,#7e1
	dw #c0b,#245,#48b,#907
	dw #c00
	dw #c63,#122,#0
	dw #c02,#0
	dw #c03,#308,#48b
	dw #c00
	dw #c27,#184,#611,#917
	dw #c00
	dw #c01,#184
	dw #c00
	dw #c67,#308,#611,#917
	dw #c02,#0
	dw #c0f,#2b4,#611,#ad0,#907
	dw #c00
	dw #c45,#184,#917
	dw #c02,#0
	dw #c0f,#39b,#611,#819,#907
	dw #c00
	dw #c6f,#367,#0,#737,#ac0
	dw #c02,#0
	dw #c0b,#184,#611,#907
	dw #c00
	dw #c2f,#122,#48b,#122f,#809
	dw #c04,#1033
	dw #c0d,#122,#e6e,#727
	dw #c04,#d9f
	dw #c67,#206,#48b,#c23
	dw #c06,#0,#ad0
	dw #c0f,#122,#48b,#9a2,#121f
	dw #c0c,#917,#1023
	dw #c4d,#308,#917,#e5e
	dw #c0e,#0,#9a2,#d8f
	dw #c0f,#122,#48b,#ad0,#c13
	dw #c0c,#c23,#ac0
	dw #c6f,#245,#0,#d9f,#992
	dw #c0e,#0,#e6e,#907
	dw #c0f,#122,#48b,#1033,#907
	dw #c0c,#122f,#992
	dw #c2f,#184,#611,#122f,#ac0
	dw #c08,#c13
	dw #c09,#184,#d8f
	dw #c08,#e5e
	dw #c6b,#2b4,#611,#1023
	dw #c0a,#0,#121f
	dw #c0b,#184,#611,#121f
	dw #c00
	dw #c41,#184
	dw #c02,#0
	dw #c03,#184,#611
	dw #c00
	dw #c63,#308,#0
	dw #c02,#0
	dw #c03,#184,#611
	dw #c00
	dw #c27,#40c,#48b,#1227
	dw #c04,#121f
	dw #c05,#122,#1217
	dw #c04,#120f
	dw #c67,#122,#48b,#1207
	dw #c06,#0,#11ff
	dw #c0f,#206,#48b,#11f7,#1227
	dw #c0c,#11ef,#121f
	dw #c4d,#122,#11f7,#1217
	dw #c0e,#0,#11ff,#120f
	dw #c0f,#245,#48b,#1207,#1207
	dw #c0c,#120f,#11ff
	dw #c6f,#122,#0,#1217,#11f7
	dw #c0e,#0,#121f,#11ef
	dw #c0f,#308,#48b,#1227,#11f7
	dw #c0c,#122f,#11ff
	dw #c2f,#184,#611,#917,#1207
	dw #c08,#120f
	dw #c09,#184,#1217
	dw #c08,#121f
	dw #c6b,#308,#611,#1227
	dw #c0a,#0,#121f
	dw #c0b,#2b4,#611,#907
	dw #c00
	dw #c45,#184,#907
	dw #c02,#0
	dw #c07,#39b,#611,#8ef
	dw #c00
	dw #c67,#367,#0,#8d7
	dw #c02,#0
	dw #c0f,#184,#611,#8f7,#907
	dw #c00
	dw #c2f,#122,#48b,#907,#907
	dw #c00
	dw #c0d,#122,#917,#907
	dw #c00
	dw #c6b,#206,#48b,#907
	dw #c02,#0
	dw #c0b,#122,#48b,#907
	dw #c00
	dw #c49,#308,#907
	dw #c02,#0
	dw #c43,#122,#48b
	dw #c00
	dw #c23,#245,#0
	dw #c02,#0
	dw #c43,#122,#48b
	dw #c00
	dw #1727,#15a,#568,#819
	dw #1700
	dw #1700
	dw #1700
	dw #1700
	dw #1700
	dw #1700
	dw #1700
	dw #1701,#0
	dw #1702,#0
	dw #1705,#0,#0
	dw #1708,#0
	dw #1709,#0,#0
	dw #1700
	dw #1700
	dw #1700
	dw #1700
	dw #1700
	dw #1700
	dw 0
