
.include "fb32x32.inc"

.include "globals.inc"

.segment "GFXDATA"

.segment "PADATA"

greetings_gfx_start:
.include "greetings_gfx.inc"
greetings_gfx_end:

.assert <* = 0, error, "not page aligned"

.segment "DATA"

CURRTILE    := $e000
PREVTILE    := $e400

MOVE_NONE   := $00
MOVE_END    := $01
MOVE_DOWN   := $02
MOVE_UP     := $82
MOVE_RIGHT  := $03
MOVE_LEFT   := $83

movetable:
   .byte MOVE_UP    | offset_INTRO
   .byte MOVE_NONE

   .byte MOVE_DOWN  | offset_trsi
   .byte MOVE_NONE

   .byte MOVE_LEFT  | offset_titan
   .byte MOVE_NONE

   .byte MOVE_UP    | offset_abyss_connection1  ; sw
   .byte MOVE_LEFT  | offset_abyss_connection2

   .byte MOVE_LEFT  | offset_rabenauge
   .byte MOVE_NONE

   .byte MOVE_DOWN  | offset_onslaught          ; sw
   .byte MOVE_NONE

   .byte MOVE_UP    | offset_akronyme_analogiker1
   .byte MOVE_LEFT  | offset_akronyme_analogiker2

   .byte MOVE_LEFT  | offset_genesis_project    ; sw
   .byte MOVE_NONE

   .byte MOVE_UP    | offset_the_solaris_agency
   .byte MOVE_NONE

   .byte MOVE_DOWN  | offset_attentionwhore2    ; sw
   .byte MOVE_DOWN  | offset_attentionwhore1

   .byte MOVE_LEFT  | offset_digital_demolition_krew
   .byte MOVE_NONE

   .byte MOVE_UP    | offset_logicoma
   .byte MOVE_NONE

.if SHORTEST
.else
   .byte MOVE_RIGHT | offset_spare
   .byte MOVE_NONE
.endif

   .byte MOVE_DOWN  | offset_coders1            ; sw
   .byte MOVE_LEFT  | offset_coders2

   .byte MOVE_UP    | offset_people
   .byte MOVE_NONE

   .byte MOVE_RIGHT | offset_pizza              ; sw
   .byte MOVE_NONE
movetableend:

initdone    := localram+$00
tileidx     := localram+$01

.segment "CODE"


greetings:
   lda   initdone
   bne   @initdone

   lda   #$08
   sta   FB32X32_COLMAP
   sta   initdone

   ldx   #$00
:
   stz   PREVTILE+$000,x
   stz   PREVTILE+$100,x
   stz   PREVTILE+$200,x
   stz   PREVTILE+$300,x
   lda   greetings_start+$000,x
   sta   CURRTILE+$000,x
   lda   greetings_start+$100,x
   sta   CURRTILE+$100,x
   lda   greetings_start+$200,x
   sta   CURRTILE+$200,x
   lda   greetings_start+$300,x
   sta   CURRTILE+$300,x
   inx
   bne   :-

@initdone:
   jsr   @domove

   ldx   tileidx
   lda   frmcnt+0
   and   #$3f
   cmp   #$3f
   bne   @nonext

   lda   movetable,x
   inx
   cpx   #<(movetableend-movetable)
   bcc   :+
   jmp   schedulenext
:
   stx   tileidx
   lda   movetable,x
   beq   @nonext
   and   #$7c
   clc
   adc   #(>greetings_start)

   sta   @nexttile0+2
   inc
   sta   @nexttile1+2
   inc
   sta   @nexttile2+2
   inc
   sta   @nexttile3+2

   ldy   #$00
:
   lda   CURRTILE+$000,y
   sta   PREVTILE+$000,y
   lda   CURRTILE+$100,y
   sta   PREVTILE+$100,y
   lda   CURRTILE+$200,y
   sta   PREVTILE+$200,y
   lda   CURRTILE+$300,y
   sta   PREVTILE+$300,y

@nexttile0:
   lda   greetings_start+$000,y
   sta   CURRTILE+$000,y
@nexttile1:
   lda   greetings_start+$100,y
   sta   CURRTILE+$100,y
@nexttile2:
   lda   greetings_start+$200,y
   sta   CURRTILE+$200,y
@nexttile3:
   lda   greetings_start+$300,y
   sta   CURRTILE+$300,y

   iny
   bne   :-
@nonext:

   rts

@domove:
   ldx   tileidx
   lda   movetable,x
   bne   @nowait
   jmp   showfb
@nowait:
   bpl   @uporleft
   and   #$01
   beq   greetings_up
   jmp   greetings_left
@uporleft:
   and   #$01
   beq   greetings_down
   jmp   greetings_right


greetings_up:
   lda   frmcnt+0
   lsr
   and   #$1f
   ldx   #>PREVTILE
   ldy   #>CURRTILE
   bra   movevertical

greetings_down:
   lda   frmcnt+0
   lsr
   and   #$1f
   eor   #$1f
   ldy   #>PREVTILE
   ldx   #>CURRTILE

movevertical:
   ; IN:
   ; A: transistion line ($00-$20) ($00=top only, $20=bottom only)
   ; X: page of top image
   ; Y: page of bottom image

   pha

   ; prepare fallback: transfer full image
   stz   FB32X32_SRC+0
   stz   FB32X32_DEST_X
   stz   FB32X32_DEST_Y
   lda   #$1f
   sta   FB32X32_WIDTH
   sta   FB32X32_HEIGHT
   sta   FB32X32_STEP
   pla

   cmp   #$00
   bne   :+
   txa
   bra   @fullimage
:
   cmp   #$20
   bcc   :+
   tya
   bra   @fullimage
:

   pha
   stx   tmp8
   tax
   lda   #$00
@addloop:
   dex
   bmi   @done
   clc
   adc   #$20
   bcc   @addloop
   inc   tmp8
   bra   @addloop
@done:
   sta   FB32X32_SRC+0
   lda   tmp8
   sta   FB32X32_SRC+1
   pla
   sec
   eor   #$ff
   adc   #$1f
   sta   FB32X32_HEIGHT
   stz   FB32X32_COPYN

   stz   FB32X32_SRC+0
   sty   FB32X32_SRC+1
   inc
   sta   FB32X32_DEST_Y
   sec
   eor   #$ff
   adc   #$1f
   sta   FB32X32_HEIGHT

   bra   @copydata
@fullimage:
   sta   FB32X32_SRC+1
@copydata:
   stz   FB32X32_COPY
   rts


greetings_left:
   lda   frmcnt+0
   lsr
   and   #$1f
   ldx   #>PREVTILE
   ldy   #>CURRTILE
   bra   movehorizontal

greetings_right:
   lda   frmcnt+0
   lsr
   and   #$1f
   eor   #$1f
   ldy   #>PREVTILE
   ldx   #>CURRTILE

movehorizontal:
   ; IN:
   ; A: transistion line ($00-$20) ($00=left only, $20=right only)
   ; X: page of left image
   ; Y: page of right image

   stx   FB32X32_SRC+1     ; might be skipped, but reg can be reused.
   stz   FB32X32_DEST_X
   stz   FB32X32_DEST_Y
   ldx   #$1f
   stx   FB32X32_HEIGHT
   stx   FB32X32_STEP

   cmp   #$20              ; right image only
   bcs   @rightonly

   sta   FB32X32_SRC+0

   sec
   eor   #$ff
   adc   #$1f
   sta   FB32X32_WIDTH

   cmp   #$1f              ; width = 32 pixels -> no right image
   bcs   @leftonly
   stz   FB32X32_COPYN     ; copy first half to LED buffer
   inc
   .byte $2c
@rightonly:
   lda   #$00
   stz   FB32X32_SRC+0
   sty   FB32X32_SRC+1
   sta   FB32X32_DEST_X    ; next column for right picture

   sec
   eor   #$ff
   adc   #$1f
   sta   FB32X32_WIDTH

@leftonly:
   stz   FB32X32_COPY
   rts

.out .sprintf("greetings gfx size: $%04x", greetings_gfx_end-greetings_gfx_start)
