/*
 * Decompiled with CFR 0.152.
 */
package org.kd.tricks;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.util.Point;

public class StarsArray {
    public double spread = 1.2;
    public double spread2 = 20.0;
    private final int width;
    private final List<Point> stars;

    public StarsArray(int width, int height) {
        this.width = width;
        this.stars = new ArrayList<Point>(2 * height);
        for (int i = 0; i < height; ++i) {
            double x1 = -this.spread * (double)width * Math.random();
            Point p1 = new Point((int)x1, i);
            double x2 = x1 + this.spread * (double)width + this.spread2 * (double)i / (double)height;
            Point p2 = new Point((int)x2, i);
            this.stars.add(p1);
            this.stars.add(p2);
        }
    }

    public void move() {
        this.stars.forEach(star -> {
            double speed = 1.0 + 3.0 * Math.random();
            int newX = Long.valueOf(Math.round((double)star.getX() + speed)).intValue();
            star.setX(newX);
            if (star.getX() > this.width) {
                star.setX(0);
            }
        });
    }

    public void draw(ShapeRenderer shapeRenderer) {
        shapeRenderer.setColor(Color.WHITE);
        int maxX = Gdx.graphics.getWidth();
        this.stars.stream().filter(stars -> stars.getX() > 0 && stars.getX() < maxX).forEach(star -> shapeRenderer.rect(star.getX(), star.getY(), 1.0f, 1.0f));
    }
}

