float sdPlaneXZ(vec3 p) {
    return p.y;
}

float sdPlaneXY(vec3 p) {
    return -p.z;
}

float sdPlane(vec3 p, vec3 n, float h) {
    return dot(p, n) + h;
}

float sdSphere(vec3 p, float s) {
    return length(p) - s;
}

float sdTorus(vec3 p, vec2 t) {
    vec2 q = vec2(length(p.xz) - t.x, p.y);
    return length(q) - t.y;
}

float sdOctahedron(vec3 p, float s) {
    p = abs(p);
    return (p.x + p.y + p.z - s) * 0.57735027;
}

vec2 opUnion(vec2 a, vec2 b) {
    if (a.x < b.x) {
        return a;
    }
    return b;
}

vec3 repetition(vec3 p, vec3 s) {
    return p - s * round(p / s);
}
